/*
 * Decompiled with CFR 0.152.
 */
package org.virbo.autoplot.scriptconsole;

import java.awt.HeadlessException;
import java.beans.ExceptionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.LinkedHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.prefs.Preferences;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.filechooser.FileFilter;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import org.das2.components.DasProgressPanel;
import org.das2.util.filesystem.FileSystem;
import org.das2.util.filesystem.WebFileSystem;
import org.das2.util.monitor.NullProgressMonitor;
import org.das2.util.monitor.ProgressMonitor;
import org.python.core.Py;
import org.python.core.PyException;
import org.python.core.PyInteger;
import org.python.core.PySyntaxError;
import org.python.core.ThreadState;
import org.python.util.InteractiveInterpreter;
import org.python.util.PythonInterpreter;
import org.virbo.autoplot.ApplicationModel;
import org.virbo.autoplot.JythonUtil;
import org.virbo.autoplot.dom.ApplicationController;
import org.virbo.autoplot.scriptconsole.JythonScriptPanel;
import org.virbo.datasource.DataSetSelector;
import org.virbo.datasource.DataSetURI;
import org.virbo.datasource.URISplit;
import org.virbo.datasource.jython.JythonDataSourceFactory;
import org.virbo.jythonsupport.ui.EditorAnnotationsSupport;

public class ScriptPanelSupport {
    File file;
    final ApplicationModel model;
    final ApplicationController applicationController;
    final DataSetSelector selector;
    final JythonScriptPanel panel;
    final EditorAnnotationsSupport annotationsSupport;
    private String PREFERENCE_OPEN_FILE = "openFile";
    private InteractiveInterpreter interruptible;
    ThreadState ts;
    public static final String PROP_INTERRUPTABLE = "interruptable";
    private PropertyChangeSupport propertyChangeSupport = new PropertyChangeSupport(this);

    ScriptPanelSupport(JythonScriptPanel panel, ApplicationModel model, DataSetSelector selector) {
        this.model = model;
        this.applicationController = model.getDocumentModel().getController();
        this.selector = selector;
        this.panel = panel;
        this.annotationsSupport = panel.getEditorPanel().getEditorAnnotationsSupport();
        this.applicationController.addPropertyChangeListener("focusUri", new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                ScriptPanelSupport.this.maybeDisplayDataSourceScript();
            }
        });
    }

    private boolean maybeDisplayDataSourceScript() throws HeadlessException, NullPointerException {
        try {
            LinkedHashMap params;
            String sfile = this.applicationController.getFocusUri();
            if (sfile == null) {
                return false;
            }
            URISplit split = URISplit.parse((String)sfile);
            if (!URISplit.implicitVapScheme((URISplit)split).endsWith("jyds")) {
                return false;
            }
            if (this.panel.isDirty()) {
                int result = JOptionPane.showConfirmDialog(this.panel, "save edits before loading\n" + sfile + ",\nor cancel script loading?", "loading new script", 2);
                if (result == 2) {
                    return false;
                }
                if (this.saveAs() == 2) {
                    return false;
                }
            }
            if (split.params != null && (params = URISplit.parseParams((String)split.params)).containsKey("script")) {
                sfile = (String)params.get("script");
            }
            this.file = DataSetURI.getFile((URL)DataSetURI.getURL((String)sfile), (ProgressMonitor)new NullProgressMonitor());
            this.loadFile(this.file);
            this.panel.setContext(1);
            this.panel.setFilename(this.file.toString());
        }
        catch (NullPointerException ex) {
            Logger.getLogger(JythonScriptPanel.class.getName()).log(Level.SEVERE, null, ex);
            return false;
        }
        catch (IOException ex) {
            Logger.getLogger(JythonScriptPanel.class.getName()).log(Level.SEVERE, null, ex);
            return false;
        }
        return true;
    }

    public int getSaveFile() throws IOException {
        int r;
        Preferences prefs;
        String openFile;
        JFileChooser chooser = new JFileChooser();
        chooser.setFileFilter(this.getFileFilter());
        if (this.file != null && !this.file.getCanonicalPath().startsWith(WebFileSystem.getDownloadDirectory().toString())) {
            chooser.setSelectedFile(this.file);
        }
        if (this.file == null && !(openFile = (prefs = Preferences.userNodeForPackage(ScriptPanelSupport.class)).get(this.PREFERENCE_OPEN_FILE, "")).equals("")) {
            chooser.setCurrentDirectory(new File(openFile).getParentFile());
        }
        if ((r = chooser.showSaveDialog(this.panel)) == 0) {
            this.file = chooser.getSelectedFile();
            if (!(this.file.toString().endsWith(".jy") || this.file.toString().endsWith(".py") || this.file.toString().endsWith(".jyds"))) {
                this.file = this.panel.getContext() == 1 ? new File(this.file.toString() + ".jyds") : new File(this.file.toString() + ".jy");
            }
        }
        return r;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void save() throws FileNotFoundException, IOException {
        if (this.file == null) {
            this.saveAs();
            return;
        }
        OutputStream out = null;
        try {
            if (!(this.file.exists() && this.file.canWrite() || this.file.getParentFile().canWrite())) {
                throw new IOException("unable to write to file: " + this.file);
            }
            out = new FileOutputStream(this.file);
            String text = this.panel.getEditorPanel().getText();
            out.write(text.getBytes());
            this.panel.setDirty(false);
        }
        finally {
            if (out != null) {
                out.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void loadFile(File file) throws IOException, FileNotFoundException {
        FileInputStream r = null;
        try {
            r = new FileInputStream(file);
            this.file = file;
            this.panel.setFilename(file.toString());
            this.loadInputStream(r);
            if (file.toString().endsWith(".jyds")) {
                this.panel.setContext(1);
            } else {
                this.panel.setContext(0);
            }
        }
        finally {
            if (r != null) {
                ((InputStream)r).close();
            }
        }
    }

    protected void loadInputStream(InputStream in) throws IOException {
        BufferedReader r = null;
        try {
            StringBuilder buf = new StringBuilder();
            r = new BufferedReader(new InputStreamReader(in));
            String s = r.readLine();
            while (s != null) {
                buf.append(s).append("\n");
                s = r.readLine();
            }
            Document d = this.panel.getEditorPanel().getDocument();
            d.remove(0, d.getLength());
            d.insertString(0, buf.toString(), null);
            this.panel.setDirty(false);
        }
        catch (BadLocationException ex) {
            throw new RuntimeException(ex);
        }
        finally {
            if (r != null) {
                r.close();
            }
        }
    }

    private boolean uriFilesEqual(String surl1, String surl2) throws URISyntaxException {
        int i1 = surl1.indexOf("?");
        if (i1 == -1) {
            i1 = surl1.length();
        }
        URI uri1 = DataSetURI.getURI((String)surl1.substring(0, i1));
        int i2 = surl2.indexOf("?");
        if (i2 == -1) {
            i2 = surl2.length();
        }
        URI uri2 = DataSetURI.getURI((String)surl2.substring(0, i2));
        if (uri1 == null) {
            return false;
        }
        return uri1.equals(uri2);
    }

    private void annotateError(PyException ex, int offset, PythonInterpreter interp) {
        if (ex instanceof PySyntaxError) {
            Logger.getLogger(ScriptPanelSupport.class.getName()).log(Level.SEVERE, null, ex);
            int lineno = offset + ((PyInteger)ex.value.__getitem__(1).__getitem__(1)).getValue();
            this.annotationsSupport.annotateLine(lineno, "error", ex.toString(), interp);
        } else {
            Logger.getLogger(ScriptPanelSupport.class.getName()).log(Level.SEVERE, null, ex);
            this.annotationsSupport.annotateLine(offset + ex.traceback.tb_lineno, "error", ex.toString(), interp);
        }
    }

    protected void executeScript() {
        this.executeScript(false);
    }

    protected void executeScript(final boolean trace) {
        block17: {
            try {
                if (this.panel.getContext() == 1) {
                    if (this.file != null) {
                        URI uri;
                        try {
                            uri = new URI("vap+jyds:" + this.file.toURI().toString());
                        }
                        catch (URISyntaxException ex) {
                            throw new RuntimeException(ex);
                        }
                        JythonDataSourceFactory factory = (JythonDataSourceFactory)DataSetURI.getDataSourceFactory((URI)uri, (ProgressMonitor)new NullProgressMonitor());
                        if (factory != null) {
                            factory.addExeceptionListener(new ExceptionListener(){

                                public void exceptionThrown(Exception e) {
                                    if (e instanceof PyException) {
                                        ScriptPanelSupport.this.annotateError((PyException)((Object)e), 0, null);
                                    }
                                }
                            });
                        }
                    }
                    boolean updateSurl = false;
                    if (this.file == null || this.file.getCanonicalPath().startsWith(FileSystem.settings().getLocalCacheDir().toString())) {
                        if (this.getSaveFile() == 0) {
                            updateSurl = true;
                        } else {
                            return;
                        }
                    }
                    if (this.file == null) break block17;
                    try {
                        if (!this.uriFilesEqual(this.selector.getValue(), this.file.toURI().toString())) {
                            updateSurl = true;
                        }
                    }
                    catch (URISyntaxException ex) {
                        updateSurl = true;
                    }
                    if (this.panel.isDirty() && (this.file.exists() && this.file.canWrite() || this.file.getParentFile().canWrite())) {
                        this.save();
                    }
                    if (updateSurl) {
                        this.selector.setValue("vap+jyds:" + this.file.toURI().toString());
                    }
                    this.annotationsSupport.clearAnnotations();
                    this.selector.maybePlot(false);
                    if (updateSurl) {
                        this.panel.setFilename(this.file.toString());
                    }
                    break block17;
                }
                if (this.panel.getContext() == 0) {
                    this.applicationController.setStatus("busy: executing application script");
                    Runnable run = new Runnable(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        public void run() {
                            int offset = 0;
                            try {
                                if (ScriptPanelSupport.this.file != null && (ScriptPanelSupport.this.file.exists() && ScriptPanelSupport.this.file.canWrite() || ScriptPanelSupport.this.file.getParentFile().canWrite())) {
                                    ScriptPanelSupport.this.save();
                                    ScriptPanelSupport.this.applicationController.getApplicationModel().addRecent("script:" + ScriptPanelSupport.this.file.toURI().toString());
                                }
                                DasProgressPanel mon = DasProgressPanel.createComponentPanel(ScriptPanelSupport.this.model.getCanvas(), "running script");
                                InteractiveInterpreter interp = null;
                                try {
                                    interp = JythonUtil.createInterpreter(true, false);
                                    interp.set("dom", (Object)ScriptPanelSupport.this.model.getDocumentModel());
                                    interp.set("monitor", (Object)mon);
                                    ScriptPanelSupport.this.setInterruptible(interp);
                                    ScriptPanelSupport.this.ts = Py.getThreadState();
                                    boolean dirty0 = ScriptPanelSupport.this.panel.isDirty();
                                    ScriptPanelSupport.this.annotationsSupport.clearAnnotations();
                                    ScriptPanelSupport.this.panel.setDirty(dirty0);
                                    if (trace) {
                                        String text = ScriptPanelSupport.this.panel.getEditorPanel().getText();
                                        int i0 = 0;
                                        while (i0 < text.length()) {
                                            int i1 = text.indexOf("\n", i0);
                                            while (i1 < text.length() - 1 && Character.isWhitespace(text.charAt(i1 + 1))) {
                                                i1 = text.indexOf("\n", i1 + 1);
                                            }
                                            String s = i1 != -1 ? text.substring(i0, ++i1) : text.substring(i0);
                                            ScriptPanelSupport.this.annotationsSupport.clearAnnotations();
                                            ScriptPanelSupport.this.annotationsSupport.annotateChars(i0, i1, "programCounter", "pc", (PythonInterpreter)interp);
                                            interp.exec(s);
                                            i0 = i1;
                                            ++offset;
                                            System.err.println(s);
                                        }
                                        ScriptPanelSupport.this.annotationsSupport.clearAnnotations();
                                    } else {
                                        interp.exec(ScriptPanelSupport.this.panel.getEditorPanel().getText());
                                    }
                                    ScriptPanelSupport.this.setInterruptible(null);
                                    mon.finished();
                                    ScriptPanelSupport.this.applicationController.setStatus("done executing script");
                                }
                                catch (IOException ex) {
                                    mon.finished();
                                    Logger.getLogger(ScriptPanelSupport.class.getName()).log(Level.SEVERE, null, ex);
                                    ScriptPanelSupport.this.applicationController.setStatus("error: I/O exception: " + ex.toString());
                                }
                                catch (PyException ex) {
                                    mon.finished();
                                    ScriptPanelSupport.this.annotateError(ex, offset, (PythonInterpreter)interp);
                                    ex.printStackTrace();
                                    ScriptPanelSupport.this.applicationController.setStatus("error: " + ex.toString());
                                }
                            }
                            catch (IOException ex) {
                                throw new RuntimeException(ex);
                            }
                            catch (Error ex) {
                                if (!ex.getMessage().contains("Python interrupt")) {
                                    throw ex;
                                }
                                ScriptPanelSupport.this.applicationController.setStatus("script interrupted");
                            }
                            finally {
                                ScriptPanelSupport.this.setInterruptible(null);
                            }
                        }
                    };
                    new Thread(run, "sessionRunScriptThread").start();
                }
            }
            catch (IOException iOException) {
                this.model.getExceptionHandler().handle(iOException);
            }
        }
    }

    private FileFilter getFileFilter() {
        return new FileFilter(){

            public boolean accept(File f) {
                if (f.toString() == null) {
                    return false;
                }
                return f.isDirectory() || f.toString().endsWith(".jy") || f.toString().endsWith(".py") || f.toString().endsWith(".jyds");
            }

            public String getDescription() {
                return "python and jython scripts";
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int saveAs() {
        OutputStream out = null;
        int result = 1;
        try {
            boolean updateSurl = false;
            result = this.getSaveFile();
            if (result == 0) {
                updateSurl = this.panel.getContext() == 1;
                out = new FileOutputStream(this.file);
                String text = this.panel.getEditorPanel().getText();
                out.write(text.getBytes());
                this.panel.setDirty(false);
                this.panel.setFilename(this.file.toString());
                Preferences prefs = Preferences.userNodeForPackage(ScriptPanelSupport.class);
                prefs.put(this.PREFERENCE_OPEN_FILE, this.file.toString());
            }
        }
        catch (IOException iOException) {
            this.model.getExceptionHandler().handle(iOException);
        }
        finally {
            try {
                if (out != null) {
                    out.close();
                }
            }
            catch (IOException ex) {
                Logger.getLogger(ScriptPanelSupport.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        return result;
    }

    protected void newScript() {
        if (this.panel.isDirty()) {
            int result = JOptionPane.showConfirmDialog(this.panel, "save edits first?", "new script", 1);
            if (result == 2) {
                return;
            }
            if (result == 0 && this.saveAs() == 2) {
                return;
            }
        }
        try {
            Document d = this.panel.getEditorPanel().getDocument();
            d.remove(0, d.getLength());
            this.panel.setDirty(false);
            this.panel.setFilename(null);
            this.file = null;
        }
        catch (BadLocationException ex) {
            Logger.getLogger(ScriptPanelSupport.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    protected void open() {
        try {
            int r;
            if (this.file == null) {
                String sfile = this.selector.getValue();
                URISplit split = null;
                if (sfile != null) {
                    split = URISplit.parse((String)sfile);
                }
                this.file = split == null || split.file == null || !split.file.endsWith(".py") && !split.file.endsWith(".jy") ? null : DataSetURI.getFile((URL)DataSetURI.getURL((String)sfile), (ProgressMonitor)new NullProgressMonitor());
            }
            Preferences prefs = Preferences.userNodeForPackage(ScriptPanelSupport.class);
            String openFile = prefs.get(this.PREFERENCE_OPEN_FILE, "");
            JFileChooser chooser = new JFileChooser();
            if (openFile.length() > 0) {
                chooser.setSelectedFile(new File(openFile));
            }
            chooser.setFileFilter(this.getFileFilter());
            if (this.file != null) {
                chooser.setSelectedFile(this.file);
            }
            if ((r = chooser.showOpenDialog(this.panel)) == 0) {
                this.file = chooser.getSelectedFile();
                prefs.put(this.PREFERENCE_OPEN_FILE, this.file.toString());
                this.loadFile(this.file);
                this.panel.setFilename(this.file.toString());
            }
        }
        catch (IOException ex) {
            this.model.getExceptionHandler().handle(ex);
        }
    }

    void interrupt() {
        if (this.getInterruptible() != null) {
            this.getInterruptible().interrupt(this.ts);
        }
    }

    public InteractiveInterpreter getInterruptible() {
        return this.interruptible;
    }

    private void setInterruptible(InteractiveInterpreter interruptable) {
        InteractiveInterpreter old = this.interruptible;
        this.interruptible = interruptable;
        this.propertyChangeSupport.firePropertyChange(PROP_INTERRUPTABLE, old, interruptable);
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupport.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupport.removePropertyChangeListener(listener);
    }

    public void addPropertyChangeListener(String name, PropertyChangeListener listener) {
        this.propertyChangeSupport.addPropertyChangeListener(name, listener);
    }

    public void removePropertyChangeListener(String name, PropertyChangeListener listener) {
        this.propertyChangeSupport.removePropertyChangeListener(name, listener);
    }
}

