/*
 * Decompiled with CFR 0.152.
 */
package org.virbo.autoplot.state;

import java.text.ParseException;
import org.das2.datum.Datum;
import org.das2.datum.Units;
import org.virbo.dataset.SemanticOps;
import org.virbo.qstream.SerializeDelegate;

public class DatumSerializeDelegate
implements SerializeDelegate {
    public String format(Object o) {
        String svalue;
        Datum d = (Datum)o;
        Units u = d.getUnits();
        if (u == null) {
            u = Units.dimensionless;
        }
        if ((svalue = d.getFormatter().format(d, u)).contains(" ")) {
            throw new RuntimeException("formatted value contains string");
        }
        if (u == Units.dimensionless) {
            return svalue + " (dimensionless)";
        }
        return "" + u + ": " + svalue;
    }

    public Object parse(String typeId, String s) throws ParseException {
        if ((s = s.trim()).endsWith(" (dimensionless)")) {
            int i = s.indexOf(" (dimensionless)");
            return Units.dimensionless.parse(s.substring(0, i));
        }
        int i = s.indexOf(":");
        Units u = SemanticOps.lookupUnits((String)s.substring(0, i));
        return u.parse(s.substring(i + 1));
    }

    public String typeId(Class clas) {
        return "datum";
    }
}

