/*
 * Decompiled with CFR 0.152.
 */
package org.virbo.autoplot.state;

import java.beans.XMLDecoder;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PushbackInputStream;
import java.text.ParseException;
import java.util.List;
import java.util.Locale;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamSource;
import org.das2.util.AboutUtil;
import org.virbo.autoplot.RenderType;
import org.virbo.autoplot.dom.Application;
import org.virbo.autoplot.dom.DomNode;
import org.virbo.autoplot.dom.DomUtil;
import org.virbo.autoplot.dom.Plot;
import org.virbo.autoplot.dom.PlotElement;
import org.virbo.autoplot.state.AbstractVapScheme;
import org.virbo.autoplot.state.BindingPersistenceDelegate;
import org.virbo.autoplot.state.ConnectorPersistenceDelegate;
import org.virbo.autoplot.state.DatumPersistenceDelegate;
import org.virbo.autoplot.state.DatumRangePersistenceDelegate;
import org.virbo.autoplot.state.SerializeUtil;
import org.virbo.autoplot.state.TypeSafeEnumPersistenceDelegate;
import org.virbo.autoplot.state.UnitsPersistenceDelegate;
import org.virbo.autoplot.state.Vap1_06Scheme;
import org.virbo.autoplot.state.Vap1_07Scheme;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.ls.DOMImplementationLS;
import org.w3c.dom.ls.LSOutput;
import org.w3c.dom.ls.LSSerializer;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class StatePersistence {
    private StatePersistence() {
    }

    public static void saveState(File f, Object state) throws IOException {
        StatePersistence.saveState(f, state, "");
    }

    public static void saveState(File f, Object state, String sscheme) throws IOException {
        StatePersistence.saveState(new FileOutputStream(f), state, sscheme);
    }

    public static void saveState(OutputStream out, Object state, String sscheme) throws IOException {
        AbstractVapScheme scheme;
        Document document = null;
        try {
            document = DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();
        }
        catch (ParserConfigurationException ex) {
            Logger.getLogger(StatePersistence.class.getName()).log(Level.SEVERE, null, ex);
            throw new RuntimeException(ex);
        }
        if (sscheme.equals("")) {
            scheme = new Vap1_07Scheme();
        } else if (sscheme.equals("1.06")) {
            scheme = new Vap1_06Scheme();
        } else {
            throw new IllegalArgumentException("output scheme not supported: " + sscheme);
        }
        Element element = SerializeUtil.getDomElement(document, (DomNode)state, scheme);
        Element vap = document.createElement("vap");
        vap.appendChild(element);
        vap.setAttribute("domVersion", scheme.getId());
        vap.setAttribute("appVersionTag", AboutUtil.getReleaseTag());
        document.appendChild(vap);
        if (sscheme.length() > 0) {
            try {
                StatePersistence.doConvert(document, "1.07", sscheme);
            }
            catch (TransformerException ex) {
                ex.printStackTrace();
                IOException result = new IOException("Unable to export to version " + sscheme);
                result.initCause(ex);
                throw result;
            }
        }
        StatePersistence.writeDocument(out, document);
    }

    public static void writeDocument(OutputStream out, Document document) throws IOException {
        DOMImplementation impl = document.getImplementation();
        DOMImplementationLS ls = (DOMImplementationLS)impl.getFeature("LS", "3.0");
        LSSerializer serializer = ls.createLSSerializer();
        LSOutput output = ls.createLSOutput();
        output.setEncoding("UTF-8");
        output.setByteStream(out);
        try {
            if (serializer.getDomConfig().canSetParameter("format-pretty-print", Boolean.TRUE)) {
                serializer.getDomConfig().setParameter("format-pretty-print", Boolean.TRUE);
            }
        }
        catch (Error e2) {
            e2.printStackTrace();
        }
        serializer.write(document, output);
        out.close();
    }

    public static void writeDocument(File f, Document document) throws FileNotFoundException, IOException {
        FileOutputStream out = new FileOutputStream(f);
        StatePersistence.writeDocument(out, document);
    }

    public static Element getChildElement(Element parent, String tagName) {
        NodeList nl = parent.getChildNodes();
        for (int i = 0; i < nl.getLength(); ++i) {
            Node item = nl.item(i);
            if (!(item instanceof Element) || !((Element)item).getTagName().equals(tagName)) continue;
            return (Element)item;
        }
        return null;
    }

    public static Object restoreState(File f) throws IOException {
        FileInputStream in = new FileInputStream(f);
        Object result = StatePersistence.restoreState(in);
        ((InputStream)in).close();
        return result;
    }

    private static Document doConvert(Document document, String domVersion, String currentVersion) throws TransformerConfigurationException, TransformerException {
        double dstVersion;
        double srcVersion = Double.parseDouble(domVersion);
        if (srcVersion > (dstVersion = Double.parseDouble(currentVersion))) {
            for (double s = srcVersion; s > dstVersion; s -= 0.01) {
                DOMSource src = new DOMSource(document);
                DOMResult res = new DOMResult();
                String fname = String.format(Locale.US, "Vap_%4.2f_to_%4.2f", s, s - 0.01);
                InputStream xsl = StatePersistence.class.getResourceAsStream(fname = fname.replaceAll("\\.", "_") + ".xsl");
                if (xsl == null) {
                    throw new RuntimeException("Unable to find " + fname + ".");
                }
                TransformerFactory factory = TransformerFactory.newInstance();
                Transformer tr = factory.newTransformer(new StreamSource(xsl));
                tr.transform(src, res);
                document = (Document)res.getNode();
            }
        }
        return document;
    }

    public static Object restoreState(InputStream in) throws IOException {
        PushbackInputStream pbin = new PushbackInputStream(in, 10);
        if (pbin.available() < 5) {
            System.err.println("less than 5 chars available, can't check");
        } else {
            byte[] five = new byte[5];
            pbin.read(five);
            String magic = new String(five);
            if (!(magic.equals("<?xml") || magic.equals("<vap ") || magic.equals("<java"))) {
                throw new IllegalArgumentException("expected to find document that started with \"<?xml\" , this starts with \"" + magic + "\".");
            }
            pbin.unread(five);
        }
        InputStreamReader isr = new InputStreamReader(pbin);
        try {
            Application state;
            String domVersion;
            DocumentBuilder builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            InputSource source = new InputSource(isr);
            Document document = builder.parse(source);
            if (document.getDocumentElement().getNodeName().equals("java")) {
                domVersion = "0.99";
                StatePersistence.importLegacyVap(document.getDocumentElement());
                ByteArrayOutputStream baos = new ByteArrayOutputStream(10000);
                System.err.println("importing legacy vap file v0.99. ");
                System.err.println("These must be rewritten to new vap format, support will be dropped.");
                DOMImplementation impl = document.getImplementation();
                DOMImplementationLS ls = (DOMImplementationLS)impl.getFeature("LS", "3.0");
                LSSerializer serializer = ls.createLSSerializer();
                LSOutput output = ls.createLSOutput();
                output.setEncoding("UTF-8");
                output.setByteStream(baos);
                serializer.write(document, output);
                baos.close();
                XMLDecoder decode = new XMLDecoder(new ByteArrayInputStream(baos.toByteArray()));
                new DatumRangePersistenceDelegate();
                new UnitsPersistenceDelegate();
                new DatumPersistenceDelegate();
                new TypeSafeEnumPersistenceDelegate();
                new BindingPersistenceDelegate();
                new ConnectorPersistenceDelegate();
                Application app = state = (Application)decode.readObject();
                for (PlotElement plotElement : app.getPlotElements()) {
                    if (plotElement.getRenderType() != null) continue;
                    plotElement.setRenderTypeAutomatically(RenderType.series);
                }
                for (DomNode domNode : app.getPlots()) {
                    ((Plot)domNode).getZaxis().setVisible(false);
                    List<PlotElement> pes = DomUtil.getPlotElementsFor(app, (Plot)domNode);
                    for (PlotElement pe : pes) {
                        RenderType rt = pe.getRenderType();
                        if (rt != RenderType.spectrogram && rt != RenderType.nnSpectrogram && rt != RenderType.colorScatter) continue;
                        ((Plot)domNode).getZaxis().setVisible(true);
                    }
                }
            } else {
                String currentVersion;
                Element root = document.getDocumentElement();
                if (root.getNodeName().equals("exceptionReport")) {
                    NodeList maybeVap = root.getElementsByTagName("vap");
                    if (maybeVap.getLength() == 1) {
                        root = (Element)maybeVap.item(0);
                    } else {
                        throw new IllegalArgumentException("exception report doesn't have vap node");
                    }
                }
                if (!(domVersion = root.getAttribute("domVersion")).equals(currentVersion = "1.07")) {
                    Transformer tr;
                    TransformerFactory factory;
                    InputStream xsl;
                    DOMResult res;
                    DOMSource src;
                    double s;
                    double dstVersion;
                    double srcVersion = Double.parseDouble(domVersion);
                    if (srcVersion > (dstVersion = Double.parseDouble(currentVersion))) {
                        for (s = srcVersion; s > dstVersion; s -= 0.01) {
                            src = new DOMSource(root);
                            res = new DOMResult();
                            String string2 = String.format(Locale.US, "Vap_%4.2f_to_%4.2f", s, s - 0.01);
                            string2 = string2.replaceAll("\\.", "_") + ".xsl";
                            xsl = StatePersistence.class.getResourceAsStream(string2);
                            if (xsl == null) {
                                throw new RuntimeException("Unable to find " + string2 + ".");
                            }
                            factory = TransformerFactory.newInstance();
                            tr = factory.newTransformer(new StreamSource(xsl));
                            tr.transform(src, res);
                            root = (Element)res.getNode().getFirstChild();
                        }
                    } else {
                        for (s = srcVersion; s < dstVersion; s += 0.01) {
                            src = new DOMSource(root);
                            res = new DOMResult();
                            String string3 = String.format(Locale.US, "Vap_%4.2f_to_%4.2f", s, s + 0.01);
                            string3 = string3.replaceAll("\\.", "_") + ".xsl";
                            xsl = StatePersistence.class.getResourceAsStream(string3);
                            if (xsl == null) {
                                throw new RuntimeException("Unable to find " + string3 + ".");
                            }
                            factory = TransformerFactory.newInstance();
                            tr = factory.newTransformer(new StreamSource(xsl));
                            tr.transform(src, res);
                            root = (Element)res.getNode().getFirstChild();
                        }
                    }
                }
                Element dom = StatePersistence.getChildElement(root, "Application");
                state = (Application)SerializeUtil.getDomNode(dom, new Vap1_07Scheme());
            }
            if (domVersion.compareTo("1.00") < 0) {
                Plot[] pp = state.getPlots();
                for (int i = 0; i < pp.length; ++i) {
                    pp[i].getXaxis().setAutoRange(true);
                    pp[i].getYaxis().setAutoRange(true);
                    pp[i].getZaxis().setAutoRange(true);
                }
            }
            return state;
        }
        catch (ParseException ex) {
            Logger.getLogger(StatePersistence.class.getName()).log(Level.SEVERE, null, ex);
            throw new RuntimeException(ex);
        }
        catch (TransformerException ex) {
            Logger.getLogger(StatePersistence.class.getName()).log(Level.SEVERE, null, ex);
            throw new RuntimeException(ex);
        }
        catch (SAXException ex) {
            throw new RuntimeException(ex);
        }
        catch (ParserConfigurationException ex) {
            throw new RuntimeException(ex);
        }
    }

    private static void importLegacyVap(Element element) {
        NodeList nl = element.getChildNodes();
        for (int i = 0; i < nl.getLength(); ++i) {
            Node prop;
            NamedNodeMap nn;
            Node n = nl.item(i);
            if (n.getNodeName().equals("void")) {
                nn = n.getAttributes();
                prop = nn.getNamedItem("property");
                if (prop != null) {
                    if (prop.getNodeValue().equals("autorange")) {
                        prop.setNodeValue("autoRange");
                    }
                    if (prop.getNodeValue().equals("autolabel")) {
                        prop.setNodeValue("autoLabel");
                    }
                    if (prop.getNodeValue().equals("panels")) {
                        prop.setNodeValue("plotElements");
                    }
                    if (prop.getNodeValue().equals("parentPanel")) {
                        prop.setNodeValue("parent");
                    }
                }
            } else if (n.getNodeName().equals("object")) {
                nn = n.getAttributes();
                prop = nn.getNamedItem("class");
                if (prop == null) continue;
                if (prop.getNodeValue().equals("org.virbo.autoplot.dom.Panel")) {
                    prop.setNodeValue("org.virbo.autoplot.dom.PlotElement");
                } else if (prop.getNodeValue().equals("org.virbo.autoplot.dom.PanelStyle")) {
                    prop.setNodeValue("org.virbo.autoplot.dom.PlotElementStyle");
                }
            } else if (n.getNodeName().equals("array")) {
                nn = n.getAttributes();
                prop = nn.getNamedItem("class");
                if (prop == null) continue;
                if (prop.getNodeValue().equals("org.virbo.autoplot.dom.Panel")) {
                    prop.setNodeValue("org.virbo.autoplot.dom.PlotElement");
                } else if (prop.getNodeValue().equals("org.virbo.autoplot.dom.PanelStyle")) {
                    prop.setNodeValue("org.virbo.autoplot.dom.PlotElementStyle");
                }
            }
            if (!n.hasChildNodes() || !(n instanceof Element)) continue;
            StatePersistence.importLegacyVap((Element)n);
        }
    }
}

