/*
 * Decompiled with CFR 0.152.
 */
package org.virbo.autoplot.state;

import java.awt.event.ActionEvent;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.StringTokenizer;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ImageIcon;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import org.virbo.autoplot.ApplicationModel;
import org.virbo.autoplot.dom.Application;
import org.virbo.autoplot.dom.Diff;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UndoRedoSupport {
    ApplicationModel applicationModel;
    LinkedList<StateStackElement> stateStack = new LinkedList();
    int stateStackPos = 0;
    protected String redoLabel = null;
    public static final String PROP_REDOLABEL = "redoLabel";
    private PropertyChangeSupport propertyChangeSupport = new PropertyChangeSupport(this);
    private boolean ignoringUpdates;
    public static final String PROP_DEPTH = "depth";

    public UndoRedoSupport(ApplicationModel applicationModel) {
        this.applicationModel = applicationModel;
        applicationModel.addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent ev) {
                if (ev.getPropertyName().equals("vapFile")) {
                    UndoRedoSupport.this.resetHistory();
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refreshUndoMultipleMenu(JMenu undoMultipleMenu) {
        ArrayList<StateStackElement> lstateStack;
        int lstateStackPos;
        undoMultipleMenu.removeAll();
        UndoRedoSupport undoRedoSupport = this;
        synchronized (undoRedoSupport) {
            lstateStackPos = this.stateStackPos;
            lstateStack = new ArrayList<StateStackElement>(this.stateStack);
        }
        for (int i = lstateStackPos - 1; i > Math.max(0, lstateStackPos - 10); --i) {
            StateStackElement prevState = (StateStackElement)lstateStack.get(i);
            String label = prevState.deltaDesc;
            final int ii = lstateStackPos - i;
            JMenuItem item = new JMenuItem(new AbstractAction(label){

                public void actionPerformed(ActionEvent e) {
                    UndoRedoSupport.this.undo(ii);
                }
            });
            item.setToolTipText(prevState.docString);
            item.setIcon(new ImageIcon(((StateStackElement)lstateStack.get((int)(i - 1))).thumb));
            undoMultipleMenu.add(item);
        }
    }

    public synchronized void removePropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.propertyChangeSupport.removePropertyChangeListener(propertyName, listener);
    }

    public synchronized void removePropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupport.removePropertyChangeListener(listener);
    }

    public synchronized void addPropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.propertyChangeSupport.addPropertyChangeListener(propertyName, listener);
    }

    public synchronized void addPropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupport.addPropertyChangeListener(listener);
    }

    public Action getUndoAction() {
        return new AbstractAction("Undo"){

            public void actionPerformed(ActionEvent e) {
                UndoRedoSupport.this.undo();
            }
        };
    }

    public void undo() {
        this.undo(1);
    }

    public synchronized void undo(int level) {
        String oldRedoLabel = this.getRedoLabel();
        int oldDepth = this.stateStackPos;
        this.stateStackPos -= level;
        if (this.stateStackPos < 0) {
            this.stateStackPos = 0;
        }
        if (this.stateStackPos > 0) {
            StateStackElement elephant = this.stateStack.get(this.stateStackPos - 1);
            this.ignoringUpdates = true;
            this.applicationModel.setRestoringState(true);
            this.applicationModel.restoreState(elephant.state);
            this.applicationModel.setRestoringState(false);
            this.ignoringUpdates = false;
        }
        this.propertyChangeSupport.firePropertyChange(PROP_REDOLABEL, oldRedoLabel, this.redoLabel);
        this.propertyChangeSupport.firePropertyChange(PROP_DEPTH, oldDepth, this.stateStackPos);
    }

    public Action getRedoAction() {
        return new AbstractAction("redo"){

            public void actionPerformed(ActionEvent e) {
                UndoRedoSupport.this.redo();
            }
        };
    }

    public synchronized void redo() {
        String oldRedoLabel = this.getRedoLabel();
        int oldDepth = this.stateStackPos;
        if (this.stateStackPos >= this.stateStack.size()) {
            this.stateStackPos = this.stateStack.size() - 1;
        }
        if (this.stateStackPos < this.stateStack.size()) {
            StateStackElement elephant = this.stateStack.get(this.stateStackPos);
            this.ignoringUpdates = true;
            this.applicationModel.setRestoringState(true);
            this.applicationModel.restoreState(elephant.state);
            this.applicationModel.setRestoringState(false);
            this.ignoringUpdates = false;
            ++this.stateStackPos;
        }
        this.propertyChangeSupport.firePropertyChange(PROP_REDOLABEL, oldRedoLabel, this.redoLabel);
        this.propertyChangeSupport.firePropertyChange(PROP_DEPTH, oldDepth, this.stateStackPos);
    }

    public void pushState(PropertyChangeEvent ev) {
        this.pushState(ev, null);
    }

    private StateStackElement describeChanges(List<Diff> diffs, StateStackElement element) {
        String labelStr;
        StringBuilder docBuf = new StringBuilder();
        int count = 0;
        boolean axisRangeOnly = true;
        boolean zaxisRangeOnly = true;
        boolean axisAuto = false;
        boolean timeRange = false;
        String focus = null;
        for (Diff s : diffs) {
            if (s.getDescription().contains("plotDefaults")) continue;
            String thisDiffFocus = null;
            int i = s.propertyName().indexOf(".");
            if (i > -1) {
                thisDiffFocus = s.propertyName().substring(0, i);
            }
            if (focus == null) {
                focus = thisDiffFocus;
            } else if (!focus.equals(thisDiffFocus) && !s.propertyName().equals("timeRange")) {
                focus = "";
            } else if (s.propertyName().equals("timeRange")) {
                timeRange = true;
            }
            ++count;
            docBuf.append("<br>");
            docBuf.append(s.getDescription());
            if (s.propertyName().endsWith("axis.range") || s.propertyName().equals("timeRange")) {
                if (s.propertyName().endsWith("zaxis.range")) {
                    axisRangeOnly = false;
                    continue;
                }
                zaxisRangeOnly = false;
                continue;
            }
            if (s.propertyName().endsWith("autoRange")) {
                axisAuto = true;
                continue;
            }
            axisRangeOnly = false;
            zaxisRangeOnly = false;
        }
        if (focus == null) {
            focus = "";
        }
        String docString = docBuf.length() > 4 ? docBuf.substring(4) : "";
        docString = "<html>" + docString + "</html>";
        if (diffs.isEmpty()) {
            element.deltaDesc = "unidentified change";
            element.docString = "change was detected but could not be identified.";
            return element;
        }
        if (zaxisRangeOnly && focus.length() > 0 && count > 1) {
            labelStr = axisAuto ? focus + " first Z range change" : focus + " Z range change";
        } else if (axisRangeOnly && focus.length() > 0 && count > 1) {
            labelStr = axisAuto ? focus + " first range change" : focus + " range changes";
        } else if (count > 3) {
            labelStr = "" + count + " changes";
        } else {
            StringBuilder buf = new StringBuilder();
            for (Diff s : diffs) {
                if (s.getDescription().contains("plotDefaults")) continue;
                buf.append(", ").append(s.getLabel());
            }
            String string = labelStr = buf.length() > 2 ? buf.substring(2) : "";
        }
        if (labelStr.length() > 30) {
            StringTokenizer tok = new StringTokenizer(labelStr, ".,[", true);
            StringBuilder buf = new StringBuilder();
            while (tok.hasMoreTokens()) {
                String ss = tok.nextToken();
                buf.append(ss.substring(0, Math.min(ss.length(), 12)));
            }
            labelStr = buf.toString();
        }
        element.deltaDesc = labelStr;
        element.docString = docString;
        return element;
    }

    private synchronized void removeOldStates() {
        int len = 50;
        while (this.stateStack.size() > len) {
            this.stateStack.remove(0);
            --this.stateStackPos;
        }
    }

    public synchronized void pushState(PropertyChangeEvent ev, String label) {
        BufferedImage thumb;
        if (this.ignoringUpdates) {
            return;
        }
        Application state = this.applicationModel.createState(false);
        StateStackElement elephant = this.stateStackPos > 0 ? this.stateStack.get(this.stateStackPos - 1) : null;
        if (elephant != null && state.equals(elephant.state)) {
            return;
        }
        String labelStr = "initial";
        String docString = "initial state of application";
        StateStackElement element = new StateStackElement(state, labelStr, docString);
        if (elephant != null) {
            List<Diff> diffss = elephant.state.diffs(state);
            element = this.describeChanges(diffss, element);
            if (label != null && element.deltaDesc.endsWith(" changes")) {
                element.deltaDesc = label;
            }
        }
        int oldDepth = this.stateStackPos;
        element.thumb = thumb = this.applicationModel.getThumbnail(50);
        this.stateStack.add(this.stateStackPos, element);
        while (this.stateStack.size() > 1 + this.stateStackPos) {
            this.stateStack.removeLast();
        }
        ++this.stateStackPos;
        this.removeOldStates();
        this.propertyChangeSupport.firePropertyChange(PROP_DEPTH, oldDepth, this.stateStackPos);
    }

    public String getUndoDescription() {
        if (this.stateStackPos > 1) {
            return this.stateStack.get((int)(this.stateStackPos - 1)).docString;
        }
        return null;
    }

    public String getUndoLabel() {
        if (this.stateStackPos > 1) {
            return "Undo " + this.stateStack.get((int)(this.stateStackPos - 1)).deltaDesc;
        }
        return null;
    }

    public String getRedoDescription() {
        if (this.stateStackPos < this.stateStack.size()) {
            return this.stateStack.get((int)this.stateStackPos).docString;
        }
        return null;
    }

    public String getRedoLabel() {
        if (this.stateStackPos < this.stateStack.size()) {
            return "Redo " + this.stateStack.get((int)this.stateStackPos).deltaDesc;
        }
        return null;
    }

    public void resetHistory() {
        int oldDepth = this.stateStackPos;
        this.stateStack = new LinkedList();
        this.stateStackPos = 0;
        this.propertyChangeSupport.firePropertyChange(PROP_DEPTH, oldDepth, this.stateStackPos);
    }

    public boolean isIgnoringUpdates() {
        return this.ignoringUpdates;
    }

    public void setIgnoringUpdates(boolean ignoringUpdates) {
        this.ignoringUpdates = ignoringUpdates;
    }

    public int getDepth() {
        return this.stateStackPos;
    }

    public StateStackElement peekAt(int pos) {
        return this.stateStack.get(pos);
    }

    public String getLongUndoDescription(int i) {
        List<Diff> diffss = this.stateStack.get((int)i).state.diffs(this.stateStack.get((int)(i - 1)).state);
        StringBuffer docBuf = new StringBuffer();
        for (int j = 0; j < diffss.size(); ++j) {
            Diff s = diffss.get(j);
            if (s.getDescription().contains("plotDefaults")) continue;
            if (j > 0) {
                docBuf.append(";\n");
            }
            docBuf.append(s.getDescription());
        }
        return docBuf.toString();
    }

    public static class StateStackElement {
        Application state;
        String deltaDesc;
        String docString;
        BufferedImage thumb;

        public StateStackElement(Application state, String deltaDesc, String docString, BufferedImage thumb) {
            this(state, deltaDesc, docString);
            this.thumb = thumb;
        }

        public StateStackElement(Application state, String deltaDesc, String docString) {
            this.state = state;
            this.deltaDesc = deltaDesc;
            this.docString = docString;
        }

        public String toString() {
            return this.deltaDesc;
        }
    }
}

