/*
 * Decompiled with CFR 0.152.
 */
package org.virbo.autoplot.transferrable;

import java.awt.Image;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;
import javax.swing.AbstractButton;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JLabel;

public class ImageSelection
implements Transferable {
    private static final DataFlavor defaultFlavor = DataFlavor.imageFlavor;
    private Image image;

    public int getSourceActions(JComponent c) {
        return 1;
    }

    public void setImage(Image i) {
        this.image = i;
    }

    public boolean canImport(JComponent comp, DataFlavor[] flavors) {
        if (!(comp instanceof JLabel) || comp instanceof AbstractButton) {
            return false;
        }
        int n = flavors.length;
        for (int i = 0; i < n; ++i) {
            if (!flavors[i].equals(defaultFlavor)) continue;
            return true;
        }
        return false;
    }

    public Transferable createTransferable(JComponent comp) {
        this.image = null;
        Icon icon = null;
        if (comp instanceof JLabel) {
            JLabel label = (JLabel)comp;
            icon = label.getIcon();
        } else if (comp instanceof AbstractButton) {
            AbstractButton button = (AbstractButton)comp;
            icon = button.getIcon();
        }
        if (icon instanceof ImageIcon) {
            this.image = ((ImageIcon)icon).getImage();
            return this;
        }
        return null;
    }

    public boolean importData(JComponent comp, Transferable t) {
        ImageIcon icon = null;
        try {
            if (t.isDataFlavorSupported(defaultFlavor)) {
                this.image = (Image)t.getTransferData(defaultFlavor);
                icon = new ImageIcon(this.image);
            }
            if (comp instanceof JLabel) {
                JLabel label = (JLabel)comp;
                label.setIcon(icon);
                return true;
            }
            if (comp instanceof AbstractButton) {
                AbstractButton button = (AbstractButton)comp;
                button.setIcon(icon);
                return true;
            }
        }
        catch (UnsupportedFlavorException ignored) {
            ignored.printStackTrace();
        }
        catch (IOException ignored) {
            ignored.printStackTrace();
        }
        return false;
    }

    public Object getTransferData(DataFlavor flavor) {
        if (this.isDataFlavorSupported(flavor)) {
            return this.image;
        }
        return null;
    }

    public DataFlavor[] getTransferDataFlavors() {
        return new DataFlavor[]{defaultFlavor};
    }

    public boolean isDataFlavorSupported(DataFlavor flavor) {
        return flavor.equals(defaultFlavor);
    }
}

