/*
 * Decompiled with CFR 0.152.
 */
package org.virbo.autoplot.util;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import org.das2.system.RequestProcessor;

public abstract class RunLaterListener
implements PropertyChangeListener,
Runnable {
    PropertyChange node;
    String propertyName;
    boolean immediatelyAfter;
    int invocationCount = 0;
    private static int instanceCount = 0;

    public RunLaterListener(String propertyName, PropertyChange node, boolean immediatelyAfter) {
        ++instanceCount;
        this.node = node;
        this.propertyName = propertyName;
        this.immediatelyAfter = immediatelyAfter;
        if (propertyName != null) {
            this.node.addPropertyChangeListener(propertyName, this);
        } else {
            this.node.addPropertyChangeListener(this);
        }
    }

    public void propertyChange(PropertyChangeEvent evt) {
        ++this.invocationCount;
        if (this.invocationCount > 1) {
            // empty if block
        }
        if (this.propertyName != null) {
            this.node.removePropertyChangeListener(this.propertyName, this);
        } else {
            this.node.removePropertyChangeListener(this);
        }
        if (this.invocationCount > 1) {
            return;
        }
        if (this.immediatelyAfter) {
            this.run();
        } else {
            RequestProcessor.invokeLater(this);
        }
    }

    public abstract void run();

    public static interface PropertyChange {
        public void addPropertyChangeListener(String var1, PropertyChangeListener var2);

        public void addPropertyChangeListener(PropertyChangeListener var1);

        public void removePropertyChangeListener(PropertyChangeListener var1);

        public void removePropertyChangeListener(String var1, PropertyChangeListener var2);
    }
}

