/*
 * Decompiled with CFR 0.152.
 */
package test;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.LineNumberInputStream;
import java.util.Scanner;
import java.util.regex.Pattern;
import org.virbo.autoplot.ScriptContext;
import org.virbo.dataset.DDataSet;
import org.virbo.dataset.QDataSet;
import org.virbo.dsops.Ops;
import org.virbo.dsutil.DataSetBuilder;

public class ScannerTest {
    private static String TEST_FILE;

    public static void main(String[] args) throws FileNotFoundException, Exception {
        TEST_FILE = "/home/jbf/project/cassini/BobsFiles/data_look_asc";
        File file = new File(TEST_FILE);
        int nds = 16;
        DataSetBuilder ttag = new DataSetBuilder(1, 100);
        LineNumberInputStream lnr = new LineNumberInputStream(new FileInputStream(file));
        Scanner s = new Scanner(lnr);
        s.next("sizes");
        int nfreq = s.nextInt();
        s.nextInt();
        s.next("freqs");
        DDataSet freqs = DDataSet.createRank1((int)nfreq);
        for (int i = 0; i < nfreq; ++i) {
            freqs.putValue(i, s.nextDouble());
        }
        Pattern p = Pattern.compile("time");
        String n = s.next(p);
        Pattern pid = Pattern.compile("\\S+");
        DataSetBuilder data = new DataSetBuilder(3, 100, nds, nfreq);
        String[] labels = new String[nds];
        int irec = 0;
        while (n != null) {
            ttag.putValue(irec, s.nextDouble());
            System.err.printf("%s %s\n", n, ttag.toString());
            for (int ids = 0; ids < nds; ++ids) {
                String dsid = s.next(pid);
                if (dsid.equals("kmat")) {
                    dsid = dsid + "__" + s.nextInt();
                }
                labels[ids] = dsid;
                for (int i = 0; i < nfreq; ++i) {
                    double d = s.nextDouble();
                    data.putValue(irec, ids, i, d);
                }
            }
            if (s.hasNext(p)) {
                n = s.next(p);
                ++irec;
                continue;
            }
            n = null;
        }
        ttag.putProperty("NAME", (Object)"Time");
        DDataSet ttagds = ttag.getDataSet();
        freqs.putProperty("NAME", (Object)"Freq");
        data.putProperty("DEPEND_0", (Object)ttagds);
        data.putProperty("DEPEND_1", (Object)Ops.labels((String[])labels));
        data.putProperty("DEPEND_2", (Object)freqs);
        data.putProperty("NAME", (Object)"Data");
        DDataSet datads = data.getDataSet();
        ScriptContext.formatDataSet((QDataSet)datads, "file:///home/jbf/tmp/foo.qds?type=binary");
    }
}

