/*
 * Decompiled with CFR 0.152.
 */
package test.endtoend;

import java.io.IOException;
import org.das2.dataset.VectorUtil;
import org.das2.datum.DatumRange;
import org.das2.datum.DatumRangeUtil;
import org.das2.datum.Units;
import org.das2.graph.DefaultPlotSymbol;
import org.virbo.autoplot.ScriptContext;
import org.virbo.autoplot.dom.Application;
import org.virbo.dataset.DataSetOps;
import org.virbo.dataset.MutablePropertyDataSet;
import org.virbo.dataset.QDataSet;
import org.virbo.dataset.WritableDataSet;
import org.virbo.dsops.Ops;

public class Test009 {
    static long t0 = System.currentTimeMillis();

    public static void writePng(String name) throws InterruptedException, IOException {
        ScriptContext.writeToPng(name);
        System.out.println("wrote " + name + "  timer: " + (System.currentTimeMillis() - t0));
        Test009.resetTimer();
    }

    static void resetTimer() {
        t0 = System.currentTimeMillis();
    }

    private static void extremes() throws InterruptedException, IOException {
        Application dom = ScriptContext.getDocumentModel();
        ScriptContext.reset();
        ScriptContext.setCanvasSize(640, 480);
        dom.getCanvases(0).setFont("sans-14");
        Test009.resetTimer();
        ScriptContext.plot("vap+inline:6.28");
        dom.getPlotElements(0).getStyle().setSymbolSize(10.0);
        dom.getPlotElements(0).getStyle().setPlotSymbol(DefaultPlotSymbol.STAR);
        Test009.writePng("test009_040.png");
        ScriptContext.plot("vap+inline:ripples(1,30)");
        Test009.writePng("test009_041.png");
        ScriptContext.plot("vap+inline:1,2,3,4,5");
        dom.getPlots(0).getXaxis().setRange(DatumRangeUtil.newDimensionless(1.9999, 2.0001));
        dom.getPlots(0).getYaxis().setRange(DatumRangeUtil.newDimensionless(2.9999, 3.0001));
        dom.getPlots(0).setTitle("Colinear points are not colinear when you zoom in");
        Test009.writePng("test009_042.png");
        ScriptContext.plot("vap+inline:ripples(50)");
        dom.getCanvases(0).setFont("sans-16");
        dom.getPlots(0).setTitle(".......... This is a really really really really really really really really long title, yes it is ........!cwith a subtitle and extreme symbols: &Sigma;&tau;&prime;&diams;&euro;&Dagger;!c");
        String l = "B-GSM!n!u2!r!d3!n!uUP";
        l = "B-GSM!s!n!u2!r!d3!n!kUP!n";
        dom.getPlots(0).getXaxis().setLabel("... This is a really really really really really really really really long label ...!c" + l);
        dom.getPlots(0).getYaxis().setLabel("... This is a really really really really really really really really long label ...!c" + l);
        Test009.writePng("test009_043.png");
    }

    private static void test1() throws IOException, InterruptedException {
        Application dom = ScriptContext.getDocumentModel();
        ScriptContext.setCanvasSize(800, 600);
        dom.getOptions().setAutolayout(false);
        dom.getCanvases(0).getMarginColumn().setRight("100%-10em");
        ScriptContext.setCanvasSize(800, 600);
        dom.getCanvases(0).setFont("sans-14");
        Test009.resetTimer();
        Test009.writePng("test009_001.png");
        ScriptContext.save("test009_001.vap");
        dom.getPlots(0).getXaxis().setRange(DatumRangeUtil.parseTimeRangeValid("2009-08-10"));
        Test009.writePng("test009_002.png");
        dom.getPlots(0).getXaxis().setRange(DatumRangeUtil.parseTimeRangeValid("1990-01-01 03:15:01 to 03:15:02"));
        Test009.writePng("test009_003.png");
        dom.getPlots(0).getXaxis().setRange(DatumRangeUtil.parseTimeRangeValid("1990-01-01 03:15:01.100 to 03:15:01.110"));
        Test009.writePng("test009_004.png");
        dom.getPlots(0).getYaxis().setLog(true);
        Test009.writePng("test009_005.png");
        dom.getPlots(0).getYaxis().setRange(DatumRangeUtil.newDimensionless(1.0, 100.0));
        Test009.writePng("test009_006.png");
        dom.getPlots(0).getYaxis().setRange(DatumRangeUtil.newDimensionless(1.0, 1.1));
        Test009.writePng("test009_007.png");
        dom.getPlots(0).getYaxis().setLabel("Y-Axis Label");
        QDataSet rank1Rand = Ops.accum((QDataSet)Ops.randomn((long)-12345L, (int)10000000));
        Test009.resetTimer();
        Test009.writePng("test009_008.png");
        ScriptContext.plot((QDataSet)DataSetOps.trim((QDataSet)rank1Rand, (int)0, (int)1000));
        Test009.writePng("test009_009.png");
        ScriptContext.plot((QDataSet)DataSetOps.trim((QDataSet)rank1Rand, (int)0, (int)100000));
        Test009.writePng("test009_010.png");
        ScriptContext.plot((QDataSet)DataSetOps.trim((QDataSet)rank1Rand, (int)0, (int)10000000));
        Test009.writePng("test009_011.png");
        QDataSet vds = rank1Rand;
        QDataSet xds = Ops.findgen((int)vds.length());
        vds = VectorUtil.reduce2D(xds, vds, 0, vds.length(), Units.dimensionless.createDatum(100000.0), Units.dimensionless.createDatum(100));
        ScriptContext.plot(vds);
        Test009.writePng("test009_011a.png");
        QDataSet rank2Rand = Ops.add((QDataSet)Ops.randomn((long)-12345L, (int)100000, (int)100), (QDataSet)Ops.sin((QDataSet)Ops.add((QDataSet)Ops.outerProduct((QDataSet)Ops.linspace((double)0.0, (double)1000.0, (int)100000), (QDataSet)Ops.replicate((long)1L, (int)100)), (QDataSet)Ops.outerProduct((QDataSet)Ops.replicate((long)1L, (int)100000), (QDataSet)Ops.linspace((double)0.0, (double)10.0, (int)100)))));
        Test009.resetTimer();
        ScriptContext.plot((QDataSet)DataSetOps.trim((QDataSet)rank2Rand, (int)0, (int)100));
        Test009.writePng("test009_012.png");
        ScriptContext.plot((QDataSet)DataSetOps.trim((QDataSet)rank2Rand, (int)0, (int)10000));
        Test009.writePng("test009_013.png");
        ScriptContext.plot((QDataSet)DataSetOps.trim((QDataSet)rank2Rand, (int)0, (int)100000));
        Test009.writePng("test009_014.png");
        QDataSet x = Ops.randomn((long)-12345L, (int)1000);
        QDataSet y = Ops.randomn((long)-12344L, (int)1000);
        ScriptContext.plot(x, y, Ops.sqrt((QDataSet)Ops.add((QDataSet)Ops.pow((QDataSet)x, (double)2.0), (QDataSet)Ops.pow((QDataSet)y, (double)2.0))));
        ScriptContext.setRenderStyle("colorScatter");
        dom.getPlotElements(0).getStyle().setSymbolSize(10.0);
        Test009.writePng("test009_015.png");
        ScriptContext.writeToPdf("test009_015.pdf");
        ScriptContext.setCanvasSize(200, 160);
        dom.getCanvases(0).getMarginColumn().setRight("100%-3em");
        dom.getCanvases(0).setFont("sans-8");
        dom.getPlots(0).getXaxis().setRange(DatumRange.newDatumRange(999.0, 1021.0, Units.dimensionless));
        Test009.writePng("test009_016.png");
        x = Ops.linspace((double)-9.0, (double)9.0, (int)1000);
        y = Ops.cos((QDataSet)x);
        ((MutablePropertyDataSet)y).putProperty("FILL_VALUE", (Object)-1.0E31);
        for (int i = 50; i < 60; ++i) {
            ((WritableDataSet)y).putValue(i, -1.0E31);
        }
        ScriptContext.plot(x, y);
        ScriptContext.setRenderStyle("fillToZero");
        ScriptContext.setCanvasSize(800, 600);
        dom.getPlotElements(0).getStyle().setSymbolSize(2.0);
        Test009.writePng("test009_017.png");
    }

    public static void main(String[] args) {
        try {
            Test009.test1();
            Test009.extremes();
            System.exit(0);
        }
        catch (RuntimeException ex) {
            ex.printStackTrace();
            System.exit(1);
        }
        catch (InterruptedException ex) {
            ex.printStackTrace();
            System.exit(1);
        }
        catch (IOException ex) {
            ex.printStackTrace();
            System.exit(1);
        }
    }
}

