/*
 * Decompiled with CFR 0.152.
 */
package test.endtoend;

import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.das2.dataset.DataSetUtil;
import org.das2.dataset.VectorDataSet;
import org.das2.dataset.VectorDataSetAdapter;
import org.das2.datum.DatumRange;
import org.das2.datum.Units;
import org.virbo.dataset.BundleDataSet;
import org.virbo.dataset.DRank0DataSet;
import org.virbo.dataset.DataSetOps;
import org.virbo.dataset.MutablePropertyDataSet;
import org.virbo.dataset.QDataSet;
import org.virbo.dataset.QubeDataSetIterator;
import org.virbo.dataset.SemanticOps;
import org.virbo.dataset.WritableDataSet;
import org.virbo.dsops.Ops;
import org.virbo.qstream.SimpleStreamFormatter;
import org.virbo.qstream.StreamException;
import test.endtoend.TestSupport;

public class Test011 {
    static long t0 = System.currentTimeMillis();

    private static void timer(String id) {
        System.out.printf("%s (millis): %5d \n", id, System.currentTimeMillis() - t0);
        t0 = System.currentTimeMillis();
    }

    public static void main(String[] args) {
        try {
            Test011.timer("reset");
            QDataSet ds = Ops.findgen((int)4000, (int)30);
            Test011.timer("ds=findgen(4000,30)");
            for (int i = 0; i < 4000; ++i) {
                String cmd = "_s0(40)";
                DataSetOps.sprocess((String)cmd, (QDataSet)ds, null);
            }
            Test011.timer("sprocess ds 4000 times");
            QDataSet ds2 = Ops.fftPower((QDataSet)ds);
            System.err.println(ds2);
            Test011.timer("fftPower(ds)");
            Ops.add((QDataSet)ds, (QDataSet)ds);
            Test011.timer("Ops.add( ds,ds )");
            WritableDataSet ds3 = Ops.zeros((int)40000, (int)256);
            Test011.timer("Ops.zeroes(40000,256)");
            double total = 0.0;
            for (int i = 0; i < ds3.length(); ++i) {
                for (int j = 0; j < ds3.length(0); ++j) {
                    total += ds3.value(i, j);
                }
            }
            Test011.timer("access each ds3.value(i,j)");
            total = 0.0;
            QubeDataSetIterator it = new QubeDataSetIterator((QDataSet)ds3);
            while (it.hasNext()) {
                it.next();
                total += it.getValue((QDataSet)ds3);
            }
            Test011.timer("iterator over ds3 to access");
            MutablePropertyDataSet rank1 = TestSupport.sampleDataRank1(10000000);
            Test011.timer("rank1= TestSupport.sampleDataRank1(10000000)");
            total = 0.0;
            for (int i = 0; i < rank1.length(); ++i) {
                total += rank1.value(i);
            }
            System.err.println(total);
            Test011.timer("access each of rank1.value(i)");
            Ops.histogram((QDataSet)ds, (double)-10.0, (double)10.0, (double)1.0);
            Test011.timer("simple histogram of rank1");
            QDataSet hist = Ops.autoHistogram((QDataSet)rank1);
            Test011.timer("autoHistogram of rank1");
            SimpleStreamFormatter ff = new SimpleStreamFormatter();
            ff.format(hist, (OutputStream)new FileOutputStream("test011_000.qds"), true);
            Test011.timer("format autoHistogram of rank1");
            double min = Double.MAX_VALUE;
            double max = Double.MIN_VALUE;
            QDataSet wds = org.virbo.dataset.DataSetUtil.weightsDataSet((QDataSet)rank1);
            for (int i = 0; i < rank1.length(); ++i) {
                if (wds.value(i) == 0.0) continue;
                double d = rank1.value(i);
                if (d < min) {
                    min = d;
                }
                if (!(d > max)) continue;
                max = d;
            }
            Test011.timer("range(rank1)=" + min + " to " + max);
            VectorDataSet vds = VectorDataSetAdapter.create((QDataSet)rank1);
            DatumRange dr = DataSetUtil.yRange(vds);
            Test011.timer("range(vds(rank1))=" + dr);
            BundleDataSet bds = BundleDataSet.createRank0Bundle();
            DRank0DataSet mds = org.virbo.dataset.DataSetUtil.asDataSet((double)0.0, (Units)Units.t2000);
            mds.putProperty("NAME", (Object)"time");
            mds.putProperty("FORMAT", (Object)"%1$tFT");
            bds.bundle((QDataSet)mds);
            mds = org.virbo.dataset.DataSetUtil.asDataSet((double)1000.0, (Units)Units.eV);
            mds.putProperty("NAME", (Object)"channelEnergy");
            mds.putProperty("FORMAT", (Object)"%9.3f");
            bds.bundle((QDataSet)mds);
            mds = org.virbo.dataset.DataSetUtil.asDataSet((double)90.0, (Units)Units.degrees);
            mds.putProperty("NAME", (Object)"pitchAngle");
            mds.putProperty("FORMAT", (Object)"%5.0f");
            bds.bundle((QDataSet)mds);
            mds = org.virbo.dataset.DataSetUtil.asDataSet((double)1.0E7, (Units)Units.dimensionless);
            mds.putProperty("NAME", (Object)"flux");
            mds.putProperty("CONTEXT_0", (Object)bds);
            mds.putProperty("FORMAT", (Object)"%9.2f");
            mds.putProperty("TITLE", (Object)org.virbo.dataset.DataSetUtil.format((QDataSet)mds));
            System.err.println("test011_001: " + org.virbo.dataset.DataSetUtil.format((QDataSet)bds));
            System.err.println("test011_001: " + org.virbo.dataset.DataSetUtil.format((QDataSet)mds));
            ff = new SimpleStreamFormatter();
            ff.format((QDataSet)bds, (OutputStream)new FileOutputStream("test011_001.qds"), true);
            Test011.timer("test bundle of rank 0");
            bds = BundleDataSet.createRank1Bundle();
            mds = (MutablePropertyDataSet)Ops.linspace((double)0.0, (double)777600.0, (int)10);
            mds.putProperty("UNITS", (Object)Units.t2000);
            mds.putProperty("NAME", (Object)"time");
            mds.putProperty("FORMAT", (Object)"%1$tFT");
            bds.bundle((QDataSet)mds);
            mds = Ops.replicate((long)1000L, (int)10);
            mds.putProperty("UNITS", (Object)Units.eV);
            mds.putProperty("NAME", (Object)"channelEnergy");
            mds.putProperty("FORMAT", (Object)"%9.3f");
            bds.bundle((QDataSet)mds);
            mds = (MutablePropertyDataSet)Ops.linspace((double)0.0, (double)180.0, (int)10);
            mds.putProperty("UNITS", (Object)Units.degrees);
            mds.putProperty("NAME", (Object)"pitchAngle");
            mds.putProperty("FORMAT", (Object)"%5.0f");
            bds.bundle((QDataSet)mds);
            System.err.println("test011_002: " + org.virbo.dataset.DataSetUtil.format((QDataSet)bds));
            ff = new SimpleStreamFormatter();
            ff.format((QDataSet)bds, (OutputStream)new FileOutputStream("test011_002.qds"), true);
            Test011.timer("test bundle of rank 1");
            Units u = SemanticOps.lookupUnits((String)"[foos]");
            Units u2 = SemanticOps.lookupUnits((String)"foos");
            if (!u.isConvertableTo(u2)) {
                throw new IllegalArgumentException("[foos] is not convertable to foos");
            }
            Test011.timer("test units");
            ds = Ops.ripples((int)20);
            QDataSet r = Ops.where((QDataSet)Ops.eq((QDataSet)Ops.valid((QDataSet)ds), (QDataSet)org.virbo.dataset.DataSetUtil.asDataSet((double)0.0)));
            System.err.println(r.slice(0));
            ds = Ops.ripples((int)20, (int)20);
            r = Ops.where((QDataSet)Ops.lt((QDataSet)ds, (QDataSet)org.virbo.dataset.DataSetUtil.asDataSet((double)0.0)));
            System.err.println(r);
            Test011.timer("test where");
            System.exit(0);
        }
        catch (RuntimeException ex) {
            ex.printStackTrace();
            System.exit(1);
        }
        catch (IOException ex) {
            ex.printStackTrace();
            System.exit(1);
        }
        catch (StreamException ex) {
            ex.printStackTrace();
            System.exit(1);
        }
    }
}

