/*
 * Decompiled with CFR 0.152.
 */
package test.endtoend;

import java.util.Map;
import org.das2.graph.DasAxis;
import org.virbo.autoplot.AutoplotUtil;
import org.virbo.autoplot.ScriptContext;
import org.virbo.dataset.DataSetUtil;
import org.virbo.dataset.MutablePropertyDataSet;
import org.virbo.dataset.QDataSet;
import org.virbo.datasource.MetadataModel;
import org.virbo.dsops.Ops;
import org.virbo.jythonsupport.Util;
import org.virbo.metatree.MetadataUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Test016 {
    public static void doTest(int id, String uri, QDataSet ds, Map<String, Object> meta, String dim) throws Exception {
        MutablePropertyDataSet dep0;
        MutablePropertyDataSet hist;
        long t0 = System.currentTimeMillis();
        String label = String.format("test016_%03d", id);
        if (dim != null) {
            ds = (QDataSet)ds.property(dim);
            meta = (Map)meta.get(dim);
        }
        double t = (double)(System.currentTimeMillis() - t0) / 1000.0;
        System.err.printf("Read data in %9.3f seconds (%s): %s\n", t, label, uri);
        AutoplotUtil.AutoRangeDescriptor ard = AutoplotUtil.autoRange(ds, meta);
        QDataSet autoRange = AutoplotUtil.toDataSet(ard);
        t = (double)(System.currentTimeMillis() - t0) / 1000.0;
        System.err.printf("Autorange in %9.3f seconds (%s): %s\n", t, label, uri);
        System.err.printf("autorange= %s \n", DataSetUtil.format((QDataSet)autoRange));
        if ("log".equals(autoRange.property("SCALE_TYPE"))) {
            hist = (MutablePropertyDataSet)Ops.histogram((QDataSet)Ops.log((QDataSet)ds), (double)Math.log10(autoRange.value(0)), (double)Math.log10(autoRange.value(1)), (double)(Math.log10(autoRange.value(1) / autoRange.value(0)) / 20.0));
            dep0 = (MutablePropertyDataSet)Ops.exp10((QDataSet)((QDataSet)hist.property("DEPEND_0")));
            dep0.putProperty("SCALE_TYPE", (Object)"log");
            hist.putProperty("DEPEND_0", (Object)dep0);
            dep0.putProperty("UNITS", autoRange.property("UNITS"));
        } else {
            hist = (MutablePropertyDataSet)Ops.histogram((QDataSet)ds, (double)autoRange.value(0), (double)autoRange.value(1), (double)((autoRange.value(1) - autoRange.value(0)) / 20.0));
            dep0 = (MutablePropertyDataSet)((QDataSet)hist.property("DEPEND_0"));
            dep0.putProperty("UNITS", autoRange.property("UNITS"));
        }
        DasAxis xAxis = ScriptContext.getDocumentModel().getPlots(0).getXaxis().getController().getDasAxis();
        ScriptContext.plot((QDataSet)hist);
        ScriptContext.setCanvasSize(600, 600);
        xAxis = ScriptContext.getDocumentModel().getPlots(0).getXaxis().getController().getDasAxis();
        xAxis.setLabel(DataSetUtil.format((QDataSet)autoRange));
        ScriptContext.writeToPng(String.format("test016_%03d.png", id));
        ScriptContext.formatDataSet(autoRange, label + ".qds");
    }

    public static void main(String[] args) {
        try {
            ScriptContext.getDocumentModel().getOptions().setAutolayout(false);
            ScriptContext.getDocumentModel().getCanvases(0).getMarginColumn().setRight("100%-10em");
            QDataSet ds = Util.getDataSet((String)"vap:file:///home/jbf/ct/hudson/data.backup/cdf/po_k1_cam_19980117_v00.cdf?HCounts");
            MetadataModel mm = MetadataUtil.getMetadataModel((String)((String)ds.property("METADATA_MODEL")));
            Map metaraw = (Map)ds.property("METADATA");
            Map meta = mm.properties(metaraw);
            Test016.doTest(3, "po_k1_cam_19980117_v00.cdf?FEDU", ds, meta, null);
            Test016.doTest(4, "po_k1_cam_19980117_v00.cdf?FEDU dep0", ds, meta, "DEPEND_0");
            Test016.doTest(5, "po_k1_cam_19980117_v00.cdf?FEDU dep1", ds, meta, "DEPEND_1");
            ds = Util.getDataSet((String)"vap:file:///home/jbf/ct/lanl/hudson/LANL_LANL-97A_H3_SOPA_20060505_V01.cdf?FEDU");
            mm = MetadataUtil.getMetadataModel((String)((String)ds.property("METADATA_MODEL")));
            metaraw = (Map)ds.property("METADATA");
            meta = mm.properties(metaraw);
            Test016.doTest(0, "LANL_LANL-97A_H3_SOPA_20060505_V01.cdf?FEDU", ds, meta, null);
            Test016.doTest(1, "LANL_LANL-97A_H3_SOPA_20060505_V01.cdf?FEDU dep0", ds, meta, "DEPEND_0");
            Test016.doTest(2, "LANL_LANL-97A_H3_SOPA_20060505_V01.cdf?FEDU dep1", ds, meta, "DEPEND_1");
            System.exit(0);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            System.exit(1);
        }
    }
}

