/*
 * Decompiled with CFR 0.152.
 */
package test.endtoend;

import java.io.IOException;
import java.util.List;
import org.das2.datum.DatumRange;
import org.das2.datum.DatumRangeUtil;
import org.das2.graph.SpectrogramRenderer;
import org.virbo.autoplot.ScriptContext;
import org.virbo.autoplot.dom.Application;
import org.virbo.autoplot.dom.ApplicationController;
import org.virbo.autoplot.dom.Axis;
import org.virbo.autoplot.dom.Plot;
import org.virbo.autoplot.dom.PlotElement;
import org.virbo.autoplot.layout.LayoutConstants;
import org.virbo.dataset.SemanticOps;

public class Test018 {
    static long t0 = System.currentTimeMillis();

    public static void xxx(String id) {
        System.err.println("-- timer -- " + id + " --: " + (System.currentTimeMillis() - t0));
        t0 = System.currentTimeMillis();
    }

    private static void test2(String testId) throws IOException, InterruptedException {
        Application dom = ScriptContext.getDocumentModel();
        dom.getController().reset();
        dom.getDataSourceFilters(0).setUri("file:///home/jbf/ct/hudson/data.backup/qds/series/hyd_%Y%m%d.qds?timerange=2000-01-01 through 2000-01-12");
        ScriptContext.getApplicationModel().waitUntilIdle(false);
        Axis xaxis = dom.getPlots(0).getXaxis();
        ApplicationController controller = dom.getController();
        Plot domPlot = dom.getPlots(0);
        System.err.println(domPlot.getXaxis().getRange());
        Plot that = dom.getController().copyPlotAndPlotElements(domPlot, null, false, false);
        controller.bind(domPlot.getZaxis(), "range", that.getZaxis(), "range");
        controller.bind(domPlot.getZaxis(), "log", that.getZaxis(), "log");
        controller.bind(domPlot.getZaxis(), "label", that.getZaxis(), "label");
        controller.addConnector(domPlot, that);
        that.getController().resetZoom(true, true, false);
        that.getZaxis().setRange(DatumRange.newDatumRange(10000.0, 1.0E8, that.getZaxis().getRange().getUnits()));
        ScriptContext.getApplicationModel().waitUntilIdle(false);
        xaxis.setRange(DatumRangeUtil.rescale(xaxis.getRange(), 0.2, 0.5));
        ScriptContext.getApplicationModel().waitUntilIdle(false);
        SpectrogramRenderer r = (SpectrogramRenderer)domPlot.getController().getDasPlot().getRenderer(0);
        ScriptContext.writeToPng(testId + "_003.png");
    }

    private static void test1(String testId) throws IOException, InterruptedException {
        Application dom = ScriptContext.getDocumentModel();
        dom.getDataSourceFilters(0).setUri("vap:file:///home/jbf/ct/hudson/data.backup/cdf/ac_k0_mfi_20080602_v01.cdf?BGSEc");
        dom.getPlots(0).getYaxis().setRange(new DatumRange(-10.0, 10.0, SemanticOps.lookupUnits((String)"nT")));
        dom.getController().waitUntilIdle();
        ScriptContext.writeToPng(testId + "_000.png");
        dom.getController().copyPlotAndPlotElements(dom.getPlots(0), null, true, false);
        ScriptContext.writeToPng(testId + "_001.png");
        dom.getController().setPlot(dom.getPlots(1));
        List<Plot> plots = dom.getController().addPlots(1, 3, LayoutConstants.BELOW);
        for (int i = 0; i < plots.size(); ++i) {
            Plot pl = plots.get(i);
            PlotElement p = dom.getController().getPlotElementsFor(pl).get(0);
            p.setComponent(String.format("B%s GSE", Character.valueOf((char)(120 + i))));
            p.setDataSourceFilterId("data_0");
            pl.setTitle("");
            pl.getYaxis().setLabel(p.getComponent());
        }
        ScriptContext.writeToPng(testId + "_002.png");
    }

    public static void test4(String testId) throws IOException, InterruptedException {
        ScriptContext.reset();
        ScriptContext.setCanvasSize(400, 300);
        System.err.println("+++++++++++++++++++++++++");
        ScriptContext.plot(0, "http://autoplot.org/data/autoplot.cdf?BGSM");
        ScriptContext.waitUntilIdle();
        ScriptContext.plot(0, "http://autoplot.org/data/autoplot.cdf?BGSEc");
        ScriptContext.waitUntilIdle();
        ScriptContext.writeToPng(testId + "_004a.png");
        System.err.println("+++++++++++++++++++++++++");
        ScriptContext.plot(0, "vap+cdfj:file:///home/jbf/ct/hudson/data.backup/cdf/lon/thb_l2_esa_20080907_v01.cdf?thb_peef_velocity_dsl");
        ScriptContext.waitUntilIdle();
        ScriptContext.plot(0, "vap+cdf:file:///home/jbf/ct/hudson/data.backup/cdf/lon/thb_l2_esa_20080907_v01.cdf?thb_peef_velocity_dsl");
        ScriptContext.waitUntilIdle();
        ScriptContext.writeToPng(testId + "_004.png");
        System.err.println("+++++++++++++++++++++++++");
    }

    public static void main(String[] args) {
        boolean exit = true;
        try {
            if (!exit) {
                ScriptContext.createGui();
            }
            String testId = "test018";
            ScriptContext.setCanvasSize(600, 600);
            ScriptContext.getDocumentModel().getOptions().setAutolayout(false);
            ScriptContext.getDocumentModel().getOptions().setCanvasFont("sans-8");
            ScriptContext.getDocumentModel().getCanvases(0).getMarginColumn().setRight("100%-10em");
            Test018.test1(testId);
            Test018.test2(testId);
            Test018.test4(testId);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            System.exit(1);
        }
        if (exit) {
            System.exit(0);
        }
    }
}

