/*
 * Decompiled with CFR 0.152.
 */
package test.endtoend;

import java.io.File;
import java.net.URI;
import java.text.ParseException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.das2.datum.DatumRange;
import org.das2.datum.DatumRangeUtil;
import org.das2.datum.DatumUtil;
import org.das2.fsm.FileStorageModelNew;
import org.das2.graph.DasDevicePosition;
import org.das2.util.filesystem.FileSystem;

public class Test019 {
    private static boolean testTimeRange(String norm, String test) {
        DatumRange dr2;
        DatumRange dr1 = DatumRangeUtil.parseTimeRangeValid(test);
        if (!dr1.equals(dr2 = DatumRangeUtil.parseTimeRangeValid(norm))) {
            throw new IllegalStateException("fail after parsing test->" + dr1.toString() + " width=" + DatumUtil.asOrderOneUnits(dr1.width()));
        }
        String format = DatumRangeUtil.formatTimeRange(dr1);
        if (!(dr1 = DatumRangeUtil.parseTimeRangeValid(format)).equals(dr2)) {
            throw new IllegalStateException("fail after format:  format=" + format + " width=" + DatumUtil.asOrderOneUnits(dr1.width()));
        }
        return true;
    }

    public static void testTimeRangeFormatParse() {
        Test019.testTimeRange("2001-11-03 23:00 to 2001-11-05 00:00", "2001-11-03 23:00 to 2001-11-04 24:00");
        Test019.testTimeRange("2001-01-01 00:00 to 2002-01-01 00:00", "2001");
        Test019.testTimeRange("2001-01-01 00:00 to 2004-01-01 00:00", "2001-2004");
        Test019.testTimeRange("2001-01-01 00:00 to 2004-01-01 00:00", "2001 to 2004");
        Test019.testTimeRange("2001-01-01 00:00 to 2004-01-01 00:00", "2001 through 2003");
        Test019.testTimeRange("2001-06-01 00:00 to 2001-07-01 00:00", "2001 Jun");
        Test019.testTimeRange("2001-06-01 00:00 to 2001-08-01 00:00", "2001 Jun through July");
        Test019.testTimeRange("2001-06-01 00:00 to 2001-07-01 00:00", "2001 Jun to July");
        Test019.testTimeRange("2001-06-08 00:00 to 2001-06-09 00:00", "2001 Jun 8");
        Test019.testTimeRange("2001-06-01 00:00 to 2001-07-01 00:00", "2001 Jun to July");
        Test019.testTimeRange("2001-06-08 00:00 to 2001-06-09 00:00", "2001 Jun 8 00:00 to 24:00");
        Test019.testTimeRange("2001-01-01 00:00 to 2001-01-06 00:00", "2001 Jan 01 span 5 day");
        Test019.testTimeRange("2001-01-01 05:00 to 2001-01-01 07:00", "2001 Jan 01 05:00 span 2 hr");
        Test019.testTimeRange("2010-09-01 00:00 to 2010-09-02 00:00", "2010-244");
        Test019.testTimeRange("2010-03-01 00:00 to 2010-03-02 00:00", "2010-060");
    }

    public static void testRestrictedFileSystemAccess() throws Exception {
        String uri = "http://autoplot.org/data/pngwalk/";
        FileStorageModelNew fsm = FileStorageModelNew.create(FileSystem.create(new URI(uri)), "product_$Y$m$d.png");
        File[] ff = fsm.getBestFilesFor(DatumRangeUtil.parseTimeRange("2008-003"));
        if (ff.length != 1) {
            throw new IllegalStateException("no files found");
        }
        System.err.println(ff[0]);
        uri = "http://demo:demo@www-pw.physics.uiowa.edu/~jbf/data/restrict/";
        fsm = FileStorageModelNew.create(FileSystem.create(new URI(uri)), "data_$Y_$m_$d_v$v.qds");
        ff = fsm.getBestFilesFor(DatumRangeUtil.parseTimeRange("2010-03-02"));
        if (ff.length != 1) {
            throw new IllegalStateException("no files found");
        }
        System.err.println(ff[0]);
        uri = "http://demo@host:demo@www-pw.physics.uiowa.edu/~jbf/data/restrictAt/";
        fsm = FileStorageModelNew.create(FileSystem.create(new URI(uri)), "data_$Y_$m_$d_v$v.qds");
        ff = fsm.getBestFilesFor(DatumRangeUtil.parseTimeRange("2010-03-02"));
        if (ff.length != 1) {
            throw new IllegalStateException("no files found");
        }
        System.err.println(ff[0]);
    }

    public static void testLayout() throws ParseException {
        double[] res0 = DasDevicePosition.parseFormatStr("100 % -5 em +4 px");
        res0 = DasDevicePosition.parseFormatStr("100% -5em +4px");
        double[] res1 = DasDevicePosition.parseFormatStr("100%-5em+4pt");
        double[] res2 = DasDevicePosition.parseFormatStr("+4pt-5em+100%");
        for (int i = 0; i < 3; ++i) {
            if (res0[i] != res1[i]) {
                throw new IllegalArgumentException("layout parsing res0!=res1");
            }
            if (res0[i] == res2[i]) continue;
            throw new IllegalArgumentException("layout parsing res0!=res2");
        }
        res0 = DasDevicePosition.parseFormatStr("100%");
        res0 = DasDevicePosition.parseFormatStr("0%");
        res0 = DasDevicePosition.parseFormatStr("");
    }

    public static void main(String[] args) {
        try {
            Test019.testTimeRangeFormatParse();
            Test019.testRestrictedFileSystemAccess();
            Test019.testLayout();
        }
        catch (Exception ex) {
            Logger.getLogger(Test019.class.getName()).log(Level.SEVERE, "error in test019", ex);
            ex.printStackTrace();
            System.exit(1);
        }
        System.exit(0);
    }
}

