/*
 * Decompiled with CFR 0.152.
 */
package test.endtoend;

import java.io.File;
import java.util.HashMap;
import java.util.Map;
import org.das2.datum.DatumRange;
import org.das2.datum.Units;
import org.virbo.autoplot.AutoplotUtil;
import org.virbo.autoplot.RenderType;
import org.virbo.autoplot.ScriptContext;
import org.virbo.dataset.DDataSet;
import org.virbo.dataset.DataSetOps;
import org.virbo.dataset.DataSetUtil;
import org.virbo.dataset.JoinDataSet;
import org.virbo.dataset.MutablePropertyDataSet;
import org.virbo.dataset.QDataSet;
import org.virbo.dataset.SemanticOps;
import test.endtoend.TestSupport;

public class Test022 {
    private static void setRange(DDataSet range, DatumRange drange, boolean log) {
        range.putProperty("UNITS", (Object)drange.getUnits());
        range.putValue(0, drange.min().doubleValue(drange.getUnits()));
        range.putValue(1, drange.max().doubleValue(drange.getUnits()));
        if (log) {
            range.putProperty("SCALE_TYPE", (Object)"log");
        }
    }

    private static QDataSet bounds(QDataSet fillDs, RenderType spec) throws Exception {
        DDataSet xrange = DDataSet.createRank1((int)2);
        DDataSet yrange = DDataSet.createRank1((int)2);
        DDataSet zrange = DDataSet.createRank1((int)2);
        JoinDataSet result = new JoinDataSet(2);
        result.join((QDataSet)xrange);
        result.join((QDataSet)yrange);
        result.join((QDataSet)zrange);
        HashMap props = new HashMap();
        if (spec == RenderType.spectrogram || spec == RenderType.nnSpectrogram) {
            QDataSet xds = (QDataSet)fillDs.property("DEPEND_0");
            if (xds == null) {
                if (fillDs.property("JOIN_0") != null) {
                    JoinDataSet ds = new JoinDataSet(2);
                    for (int i = 0; i < fillDs.length(); ++i) {
                        ds.join((QDataSet)fillDs.property("DEPEND_0", i));
                    }
                    xds = ds;
                } else {
                    xds = DataSetUtil.indexGenDataSet((int)fillDs.length());
                }
            }
            QDataSet yds = (QDataSet)fillDs.property("DEPEND_1");
            Map yprops = (Map)props.get("DEPEND_1");
            if (yds == null) {
                if (fillDs.property("JOIN_0") != null) {
                    JoinDataSet ds = new JoinDataSet(2);
                    for (int i = 0; i < fillDs.length(); ++i) {
                        QDataSet qds = fillDs.slice(i);
                        String f = new File("foo.qds").getAbsolutePath().toString();
                        ScriptContext.formatDataSet(fillDs, f);
                        ds.join((QDataSet)fillDs.property("DEPEND_1", i));
                    }
                    yds = ds;
                } else if (fillDs.rank() > 1) {
                    yds = DataSetUtil.indexGenDataSet((int)fillDs.length(0));
                } else {
                    yds = DataSetUtil.indexGenDataSet((int)10);
                    yprops = null;
                }
            }
            AutoplotUtil.AutoRangeDescriptor xdesc = AutoplotUtil.autoRange(xds, (Map)props.get("DEPEND_0"));
            AutoplotUtil.AutoRangeDescriptor ydesc = AutoplotUtil.autoRange(yds, yprops);
            AutoplotUtil.AutoRangeDescriptor desc = AutoplotUtil.autoRange(fillDs, props);
            Test022.setRange(zrange, desc.range, desc.log);
            Test022.setRange(xrange, xdesc.range, xdesc.log);
            Test022.setRange(yrange, ydesc.range, ydesc.log);
        } else {
            QDataSet depend0;
            AutoplotUtil.AutoRangeDescriptor ydesc;
            Object hist = null;
            if (SemanticOps.isBundle((QDataSet)fillDs)) {
                ydesc = AutoplotUtil.autoRange(DataSetOps.unbundle((QDataSet)fillDs, (int)1), props);
                depend0 = DataSetOps.unbundle((QDataSet)fillDs, (int)0);
            } else {
                ydesc = AutoplotUtil.autoRange(fillDs, props);
                depend0 = (QDataSet)fillDs.property("DEPEND_0");
            }
            Test022.setRange(yrange, ydesc.range, ydesc.log);
            QDataSet xds = depend0;
            if (xds == null) {
                xds = DataSetUtil.indexGenDataSet((int)fillDs.length());
            }
            AutoplotUtil.AutoRangeDescriptor xdesc = AutoplotUtil.autoRange(xds, (Map)props.get("DEPEND_0"));
            Test022.setRange(xrange, xdesc.range, xdesc.log);
            if (spec == RenderType.colorScatter) {
                AutoplotUtil.AutoRangeDescriptor zdesc;
                if (fillDs.property("BUNDLE_1") != null) {
                    zdesc = AutoplotUtil.autoRange(DataSetOps.unbundle((QDataSet)fillDs, (int)2), null);
                } else {
                    QDataSet plane0 = (QDataSet)fillDs.property("PLANE_0");
                    zdesc = AutoplotUtil.autoRange(plane0, (Map)props.get("PLANE_0"));
                }
                Test022.setRange(zrange, zdesc.range, zdesc.log);
            }
        }
        for (int i = 0; i < result.length(); ++i) {
            Units u = (Units)result.property("UNITS", i);
            if (u != null) {
                DatumRange dr = DatumRange.newDatumRange(result.value(i, 0), result.value(i, 1), u);
                System.err.println("" + i + ": " + dr);
                continue;
            }
            System.err.println("" + i + ": " + result.value(i, 0) + "," + result.value(i, 1));
        }
        return result;
    }

    private static boolean doTest(QDataSet ds, QDataSet bounds) throws Exception {
        QDataSet tbounds = Test022.bounds(ds, RenderType.spectrogram);
        System.err.println("tbounds=" + tbounds);
        if (bounds != null) {
            System.err.println("bounds=" + bounds);
        }
        return true;
    }

    private static void dumpRank3Ds(QDataSet ds) {
        for (int i = 0; i < ds.length(); ++i) {
            QDataSet slice = ds.slice(i);
            System.err.println("--- " + slice + " ---");
            for (int j = 0; j < slice.length(); ++j) {
                for (int k = 0; k < slice.length(j); ++k) {
                    System.err.print(" \t" + slice.value(j, k));
                }
                System.err.println("");
            }
        }
    }

    private static void testSchemes() {
        System.err.println("---");
        MutablePropertyDataSet ds = TestSupport.sampleDataRank1(99);
        System.err.println(ds);
        System.err.println("x: " + SemanticOps.xtagsDataSet((QDataSet)ds));
        System.err.println("y: " + SemanticOps.ytagsDataSet((QDataSet)ds));
        System.err.println("---");
        ds = TestSupport.sampleDataRank2(99, 20);
        System.err.println(ds);
        System.err.println("x: " + SemanticOps.xtagsDataSet((QDataSet)ds));
        System.err.println("y: " + SemanticOps.ytagsDataSet((QDataSet)ds));
        System.err.println("---");
        ds = TestSupport.sampleQube1(3.4, 4.5, 22, 32);
        System.err.println(ds);
        System.err.println("x: " + SemanticOps.xtagsDataSet((QDataSet)ds));
        System.err.println("y: " + SemanticOps.ytagsDataSet((QDataSet)ds));
        System.err.println("---");
        ds = TestSupport.sampleRank3Join();
        System.err.println(ds);
        System.err.println("x: " + SemanticOps.xtagsDataSet((QDataSet)ds));
        System.err.println("y: " + SemanticOps.ytagsDataSet((QDataSet)ds));
    }

    public static void main(String[] args) {
        try {
            Test022.doTest((QDataSet)TestSupport.sampleDataRank1(100), null);
            Test022.doTest((QDataSet)TestSupport.sampleRank3Join(), null);
            Test022.testSchemes();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            System.exit(1);
        }
    }
}

