/*
 * Decompiled with CFR 0.152.
 */
package org.das2.beans;

import java.awt.Color;
import java.beans.BeanInfo;
import java.beans.IndexedPropertyDescriptor;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.beans.PropertyEditor;
import java.beans.PropertyEditorManager;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.logging.Logger;
import org.das2.DasApplication;
import org.das2.beans.AccessLevelBeanInfo;
import org.das2.beans.ImplicitAccessLevelBeanInfo;
import org.das2.beans.UnitsEditor;
import org.das2.components.DatumEditor;
import org.das2.components.DatumRangeEditor;
import org.das2.components.propertyeditor.BooleanEditor;
import org.das2.components.propertyeditor.ColorEditor;
import org.das2.components.propertyeditor.EnumerationEditor;
import org.das2.datum.Datum;
import org.das2.datum.DatumRange;
import org.das2.datum.NumberUnits;
import org.das2.datum.Units;
import org.das2.graph.DasColorBar;
import org.das2.graph.DigitalRenderer;
import org.das2.graph.FillStyle;
import org.das2.graph.LegendPosition;
import org.das2.graph.PlotSymbol;
import org.das2.graph.Psym;
import org.das2.graph.PsymConnector;
import org.das2.graph.SpectrogramRenderer;
import org.das2.system.DasLogger;
import org.das2.util.ClassMap;

public class BeansUtil {
    static Logger log = DasLogger.getLogger(DasLogger.SYSTEM_LOG);
    static ClassMap editorRegistry;
    static HashSet nullPropertyEditors;

    public static void registerEditor(Class beanClass, Class editorClass) {
        if (DasApplication.hasAllPermission()) {
            PropertyEditorManager.registerEditor(beanClass, editorClass);
            editorRegistry.put(beanClass, (Object)editorClass);
        }
    }

    public static PropertyEditor findEditor(Class propertyClass) {
        PropertyEditor result = null;
        if (nullPropertyEditors.contains(propertyClass)) {
            result = null;
        } else {
            Class resultClass;
            result = PropertyEditorManager.findEditor(propertyClass);
            if (result == null && (resultClass = (Class)editorRegistry.get((Object)propertyClass)) != null) {
                try {
                    result = (PropertyEditor)resultClass.newInstance();
                }
                catch (InstantiationException ex) {
                    ex.printStackTrace();
                }
                catch (IllegalAccessException ex) {
                    ex.printStackTrace();
                }
            }
            if (result == null) {
                nullPropertyEditors.add(propertyClass);
            } else if (DasApplication.hasAllPermission()) {
                PropertyEditorManager.registerEditor(propertyClass, result.getClass());
            }
        }
        return result;
    }

    public static PropertyEditor getEditor(PropertyDescriptor pd) {
        PropertyEditor editor = null;
        try {
            Class<?> editorClass = pd.getPropertyEditorClass();
            if (editorClass != null) {
                editor = (PropertyEditor)editorClass.newInstance();
            }
        }
        catch (InstantiationException ex) {
        }
        catch (IllegalAccessException illegalAccessException) {
            // empty catch block
        }
        if (editor == null) {
            editor = BeansUtil.findEditor(pd.getPropertyType());
        }
        return editor;
    }

    public static PropertyDescriptor[] getPropertyDescriptors(Class c) {
        HashSet<String> excludePropertyNames = new HashSet<String>();
        excludePropertyNames.add("class");
        excludePropertyNames.add("listLabel");
        excludePropertyNames.add("listIcon");
        if (!Modifier.isPublic(c.getModifiers())) {
            System.err.println("cannot use class: " + c);
            return new PropertyDescriptor[0];
        }
        try {
            PropertyDescriptor[] pdthis;
            BeanInfo beanInfo = BeansUtil.getBeanInfo(c);
            ArrayList<PropertyDescriptor> propertyList = new ArrayList<PropertyDescriptor>();
            try {
                pdthis = beanInfo.getPropertyDescriptors();
            }
            catch (IllegalStateException e) {
                throw new RuntimeException(e);
            }
            for (int i = 0; i < pdthis.length; ++i) {
                boolean isUseable;
                boolean isWriteable = pdthis[i].getWriteMethod() != null;
                boolean bl = isUseable = pdthis[i].getReadMethod() != null && !excludePropertyNames.contains(pdthis[i].getName());
                if (!isUseable && !(pdthis[i] instanceof IndexedPropertyDescriptor)) continue;
                propertyList.add(pdthis[i]);
            }
            if (beanInfo.getAdditionalBeanInfo() != null) {
                ArrayList<BeanInfo> additionalBeanInfo = new ArrayList<BeanInfo>(Arrays.asList(beanInfo.getAdditionalBeanInfo()));
                while (additionalBeanInfo.size() > 0) {
                    BeanInfo aBeanInfo = (BeanInfo)additionalBeanInfo.remove(0);
                    pdthis = aBeanInfo.getPropertyDescriptors();
                    for (int i = 0; i < pdthis.length; ++i) {
                        boolean isUseable;
                        String name = pdthis[i].getName();
                        boolean isWriteable = pdthis[i].getWriteMethod() != null;
                        boolean bl = isUseable = pdthis[i].getReadMethod() != null && !excludePropertyNames.contains(name);
                        if (!isUseable && !(pdthis[i] instanceof IndexedPropertyDescriptor)) continue;
                        propertyList.add(pdthis[i]);
                    }
                }
            }
            return propertyList.toArray(new PropertyDescriptor[propertyList.size()]);
        }
        catch (IntrospectionException e) {
            return null;
        }
    }

    public static BeanInfo getBeanInfo(Class c) throws IntrospectionException {
        BeanInfo beanInfo = null;
        if (c.getPackage() == null) {
            beanInfo = Introspector.getBeanInfo(c);
            log.finer("using BeanInfo " + beanInfo.getClass().getName() + " for " + c.getName());
        } else {
            String s;
            try {
                s = c.getName().substring(c.getPackage().getName().length() + 1);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            Class<?> maybeClass = null;
            String beanInfoClassName = null;
            try {
                beanInfoClassName = c.getPackage() + "." + s + "BeanInfo";
                maybeClass = Class.forName(beanInfoClassName);
            }
            catch (ClassNotFoundException e) {
                try {
                    beanInfoClassName = "org.das2.beans." + s + "BeanInfo";
                    maybeClass = Class.forName(beanInfoClassName);
                }
                catch (ClassNotFoundException e2) {
                    beanInfo = Introspector.getBeanInfo(c);
                    beanInfoClassName = beanInfo.getClass().getName();
                }
            }
            log.finer("using BeanInfo " + beanInfoClassName + " for " + c.getName());
            if (beanInfo == null) {
                try {
                    beanInfo = (BeanInfo)maybeClass.newInstance();
                }
                catch (IllegalAccessException ex) {
                    throw new RuntimeException(ex);
                }
                catch (InstantiationException ex) {
                    throw new RuntimeException(ex);
                }
            }
        }
        return beanInfo;
    }

    public static String[] getPropertyNames(PropertyDescriptor[] propertyList) {
        String[] result = new String[propertyList.length];
        for (int i = 0; i < result.length; ++i) {
            result[i] = propertyList[i].getName();
        }
        return result;
    }

    public static String[] getPropertyNames(Class c) {
        PropertyDescriptor[] propertyList = BeansUtil.getPropertyDescriptors(c);
        return BeansUtil.getPropertyNames(propertyList);
    }

    public static AccessLevelBeanInfo asAccessLevelBeanInfo(BeanInfo beanInfo, Class beanClass) {
        if (beanInfo instanceof AccessLevelBeanInfo) {
            return (AccessLevelBeanInfo)beanInfo;
        }
        return ImplicitAccessLevelBeanInfo.create(beanInfo, beanClass);
    }

    static {
        String[] beanInfoSearchPath = new String[]{"org.das2.beans", "sun.beans.infos"};
        if (DasApplication.hasAllPermission()) {
            Introspector.setBeanInfoSearchPath(beanInfoSearchPath);
        }
        editorRegistry = new ClassMap();
        if (DasApplication.hasAllPermission()) {
            BeansUtil.registerEditor(Datum.class, DatumEditor.class);
            BeansUtil.registerEditor(DatumRange.class, DatumRangeEditor.class);
            BeansUtil.registerEditor(Color.class, ColorEditor.class);
            BeansUtil.registerEditor(Units.class, UnitsEditor.class);
            BeansUtil.registerEditor(NumberUnits.class, UnitsEditor.class);
            BeansUtil.registerEditor(Boolean.TYPE, BooleanEditor.class);
            BeansUtil.registerEditor(Boolean.class, BooleanEditor.class);
            BeansUtil.registerEditor(PsymConnector.class, EnumerationEditor.class);
            BeansUtil.registerEditor(Psym.class, EnumerationEditor.class);
            BeansUtil.registerEditor(PlotSymbol.class, EnumerationEditor.class);
            BeansUtil.registerEditor(FillStyle.class, EnumerationEditor.class);
            BeansUtil.registerEditor(DigitalRenderer.Align.class, EnumerationEditor.class);
            BeansUtil.registerEditor(DasColorBar.Type.class, EnumerationEditor.class);
            BeansUtil.registerEditor(SpectrogramRenderer.RebinnerEnum.class, EnumerationEditor.class);
            BeansUtil.registerEditor(LegendPosition.class, EnumerationEditor.class);
        }
        nullPropertyEditors = new HashSet();
    }
}

