/*
 * Decompiled with CFR 0.152.
 */
package org.das2.client;

import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import org.das2.DasException;
import org.das2.client.StandardDataStreamSource;
import org.das2.client.StreamDataSetDescriptor;
import org.das2.datum.Datum;
import org.das2.datum.Units;

public class FakeStandardDataStreamSource
implements StandardDataStreamSource {
    public InputStream getInputStream(StreamDataSetDescriptor dsd, Datum start, Datum end) throws DasException {
        double recsPerSecond = 8.333333333333334E-6;
        int nRec = (int)(end.subtract(start).doubleValue(Units.seconds) * recsPerSecond);
        int nitems = 12;
        FakeInputStream result = new FakeInputStream(nRec, recsPerSecond, nitems);
        return result;
    }

    public InputStream getReducedInputStream(StreamDataSetDescriptor dsd, Datum start, Datum end, Datum timeResolution) throws DasException {
        return this.getInputStream(dsd, start, end);
    }

    public void reset() {
    }

    class FakeInputStream
    extends InputStream {
        int nitems;
        long nRecs;
        double recsPerSecond;
        long floatCount;
        long byteCount;
        long recCount;
        long recSize;
        float currentFloat;
        byte[] iCurrentFloat;
        ByteBuffer buff;
        FloatBuffer fbuff;
        double transferRateBps;
        long transferBirthMilli;

        FakeInputStream(long nRecs, double recsPerSecond, int nitems) {
            this.nitems = nitems;
            this.nRecs = nRecs;
            this.recsPerSecond = recsPerSecond;
            this.buff = ByteBuffer.allocate(4 * (nitems + 1));
            this.fbuff = this.buff.asFloatBuffer();
            this.buff.position(this.buff.limit());
            this.floatCount = 0L;
            this.byteCount = 0L;
            this.recCount = 0L;
            this.recSize = (nitems + 1) * 4;
            this.iCurrentFloat = new byte[4];
            this.transferRateBps = 210000.0;
            this.transferBirthMilli = System.currentTimeMillis();
        }

        public int read() throws IOException {
            try {
                while ((double)(this.byteCount * 1000L / (1L + (System.currentTimeMillis() - this.transferBirthMilli))) > this.transferRateBps) {
                    Thread.sleep(10L);
                }
            }
            catch (InterruptedException e) {
                // empty catch block
            }
            if (!this.buff.hasRemaining()) {
                this.buff.position(0);
                this.fbuff.put(0, (float)((double)this.recCount / this.recsPerSecond));
                for (int i = 1; i <= this.nitems; ++i) {
                    float f = (float)Math.random();
                    this.fbuff.put(i, f);
                }
                ++this.recCount;
            }
            if (this.recCount > this.nRecs) {
                return -1;
            }
            int result = this.buff.get() & 0xFF;
            ++this.byteCount;
            return result;
        }
    }
}

