/*
 * Decompiled with CFR 0.152.
 */
package org.das2.client;

import java.io.IOException;
import java.io.InputStream;
import org.das2.datum.Datum;
import org.das2.datum.Units;
import org.das2.system.DasLogger;

public class InputStreamMeter {
    long totalBytesRead = 0L;
    long millisElapsed = 0L;
    double speedLimit = 0.0;
    long meterCount;
    long startTime = -1L;

    public InputStream meterInputStream(InputStream in) {
        ++this.meterCount;
        if (this.meterCount == 1L) {
            this.startTime = System.currentTimeMillis();
            this.totalBytesRead = 0L;
            this.millisElapsed = 0L;
        }
        return new MeteredInputStream(in, this);
    }

    private void governSpeed(MeteredInputStream mis) {
        if (this.speedLimit > 0.0 && this.calcTransmitSpeed() > this.speedLimit) {
            long targetMillis = (long)((double)this.totalBytesRead / (this.speedLimit / 1000.0));
            long waitMs = Math.min(1000L, targetMillis - this.calcMillisElapsed());
            DasLogger.getLogger(DasLogger.DATA_TRANSFER_LOG).fine("limiting speed by waiting " + waitMs + " ms");
            try {
                Thread.sleep(waitMs);
            }
            catch (InterruptedException ex) {
                // empty catch block
            }
        }
    }

    private void addBytes(long bytes, MeteredInputStream mis) {
        this.totalBytesRead += bytes;
    }

    private void closing(MeteredInputStream mis) {
        --this.meterCount;
        if (this.meterCount == 0L) {
            this.millisElapsed += System.currentTimeMillis() - this.startTime;
            this.startTime = -1L;
        }
    }

    private void exception(MeteredInputStream mis) {
        --this.meterCount;
        if (this.meterCount == 0L) {
            this.millisElapsed += System.currentTimeMillis() - this.startTime;
            this.startTime = -1L;
        }
    }

    private long calcMillisElapsed() {
        long millis = this.millisElapsed;
        if (this.startTime != -1L) {
            millis += System.currentTimeMillis() - this.startTime;
        }
        return millis;
    }

    private double calcTransmitSpeed() {
        long millis = this.calcMillisElapsed();
        if (millis == 0L) {
            return Units.bytesPerSecond.getFillDouble();
        }
        return 1000.0 * (double)this.totalBytesRead / (double)millis;
    }

    public Datum getTransmitSpeed() {
        return Units.bytesPerSecond.createDatum(this.calcTransmitSpeed(), 10.0);
    }

    public long getBytesTransmitted() {
        return this.totalBytesRead;
    }

    public Datum getSpeedLimit() {
        return Units.bytesPerSecond.createDatum(this.speedLimit);
    }

    public void setSpeedLimit(Datum speedLimit) {
        this.speedLimit = speedLimit.doubleValue(Units.bytesPerSecond);
    }

    private class MeteredInputStream
    extends InputStream {
        InputStream in;
        InputStreamMeter meter;

        private MeteredInputStream(InputStream in, InputStreamMeter meter) {
            this.meter = meter;
            this.in = in;
        }

        public int read(byte[] b, int off, int len) throws IOException {
            try {
                int bytesRead = this.in.read(b, off, len);
                this.meter.addBytes(bytesRead, this);
                this.meter.governSpeed(this);
                return bytesRead;
            }
            catch (IOException e) {
                this.meter.exception(this);
                throw e;
            }
        }

        public int read() throws IOException {
            try {
                int byteRead = this.in.read();
                this.meter.addBytes(1L, this);
                this.meter.governSpeed(this);
                return byteRead;
            }
            catch (IOException e) {
                this.meter.exception(this);
                throw e;
            }
        }

        public void close() throws IOException {
            this.meter.closing(this);
            this.in.close();
        }
    }
}

