/*
 * Decompiled with CFR 0.152.
 */
package org.das2.components;

import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.OutputStream;
import java.text.DecimalFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.swing.event.EventListenerList;
import org.das2.datum.Datum;
import org.das2.datum.DatumRange;
import org.das2.datum.DatumRangeUtil;
import org.das2.event.DataRangeSelectionEvent;
import org.das2.event.DataRangeSelectionListener;
import org.das2.graph.DasCanvas;
import org.das2.system.DasLogger;
import org.das2.util.DasExceptionHandler;
import org.das2.util.DasPNGEncoder;

public class BatchMaster {
    List taskList;
    int itask;
    DasCanvas canvas;
    TaskOutputDescriptor tod;
    boolean exit = true;
    public static Timer timer = new Timer();
    private EventListenerList listenerList = null;

    public TaskOutputDescriptor createPngsTaskOutputDescriptor(final String pngFilenameTemplate) {
        return new TaskOutputDescriptor(){

            private String insertRange(String filenameTemplate, DatumRange range) {
                String rangeString = range.toString().replaceAll(":", "-").replaceAll(" ", "_");
                String s = filenameTemplate.replaceAll("BEGIN", range.min().toString().replaceAll(":", "-")).replaceAll("END", range.max().toString().replaceAll(":", "-")).replaceAll("RANGE", rangeString);
                return s;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void completeTask(DatumRange range) {
                Image image = BatchMaster.this.canvas.getImage(BatchMaster.this.canvas.getWidth(), BatchMaster.this.canvas.getHeight());
                String s = this.insertRange(pngFilenameTemplate, range);
                try {
                    FileOutputStream out = new FileOutputStream(s);
                    try {
                        DasPNGEncoder encoder = new DasPNGEncoder();
                        encoder.addText("Creation Time", new Date().toString());
                        encoder.write((BufferedImage)image, (OutputStream)out);
                    }
                    finally {
                        ((OutputStream)out).close();
                    }
                }
                catch (IOException e) {
                    DasExceptionHandler.handle((Throwable)e);
                }
            }
        };
    }

    private void readStartEndSpecFile(File specFile) throws ParseException, IOException {
        BufferedReader r = new BufferedReader(new FileReader(specFile));
        String s = r.readLine();
        while (s != null) {
            if (!(s = s.trim()).equals("") && !s.startsWith("#")) {
                DatumRange dr = DatumRangeUtil.parseTimeRange((String)s);
                Datum begin = dr.min();
                Datum end = dr.max();
                this.addTask(begin, end);
            }
            s = r.readLine();
        }
    }

    public static BatchMaster createPngs(DasCanvas canvas, File specFile, String pngFilenameTemplate) throws ParseException, IOException {
        ArrayList taskList = new ArrayList();
        BatchMaster result = new BatchMaster(canvas);
        result.setTaskOutputDescriptor(result.createPngsTaskOutputDescriptor(pngFilenameTemplate));
        result.readStartEndSpecFile(specFile);
        return result;
    }

    public BatchMaster(DasCanvas canvas) {
        this.canvas = canvas;
        this.taskList = new ArrayList();
        this.itask = 0;
    }

    public void start() {
        this.submitNextTask();
    }

    void addTask(Datum begin, Datum end) {
        this.taskList.add(new DataRangeSelectionEvent(this, begin, end));
    }

    void addTask(DatumRange range) {
        this.taskList.add(new DataRangeSelectionEvent(this, range.min(), range.max()));
    }

    void setTaskOutputDescriptor(TaskOutputDescriptor tod) {
        this.tod = tod;
    }

    void setExitAfterCompletion(boolean val) {
        this.exit = val;
    }

    void submitNextTask() {
        Thread thread = new Thread(new Runnable(){

            public void run() {
                if (BatchMaster.this.itask >= BatchMaster.this.taskList.size()) {
                    if (BatchMaster.this.exit) {
                        System.exit(0);
                    }
                } else {
                    DasLogger.getLogger(DasLogger.SYSTEM_LOG).info("itask=" + BatchMaster.this.taskList.get(BatchMaster.this.itask));
                    DataRangeSelectionEvent ev = (DataRangeSelectionEvent)BatchMaster.this.taskList.get(BatchMaster.this.itask++);
                    BatchMaster.this.fireDataRangeSelectionListenerDataRangeSelected(ev);
                    try {
                        BatchMaster.this.canvas.waitUntilIdle();
                    }
                    catch (InterruptedException ex) {
                        ex.printStackTrace();
                    }
                    BatchMaster.this.tod.completeTask(ev.getDatumRange());
                    BatchMaster.this.submitNextTask();
                }
            }
        });
        thread.start();
    }

    public synchronized void addDataRangeSelectionListener(DataRangeSelectionListener listener) {
        if (this.listenerList == null) {
            this.listenerList = new EventListenerList();
        }
        this.listenerList.add(DataRangeSelectionListener.class, listener);
    }

    public synchronized void removeDataRangeSelectionListener(DataRangeSelectionListener listener) {
        this.listenerList.remove(DataRangeSelectionListener.class, listener);
    }

    private void fireDataRangeSelectionListenerDataRangeSelected(DataRangeSelectionEvent event) {
        if (this.listenerList == null) {
            return;
        }
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != DataRangeSelectionListener.class) continue;
            ((DataRangeSelectionListener)listeners[i + 1]).dataRangeSelected(event);
        }
    }

    private static interface TaskOutputDescriptor {
        public void completeTask(DatumRange var1);
    }

    public static class Timer {
        long t0 = System.currentTimeMillis();
        DecimalFormat df = new DecimalFormat("00000.000");

        public void reportTime(String msg) {
            Thread thread = Thread.currentThread();
            long elapsed = System.currentTimeMillis() - this.t0;
            System.out.println(this.df.format((double)elapsed / 1000.0) + " " + msg + "(" + thread + ")");
        }
    }
}

