/*
 * Decompiled with CFR 0.152.
 */
package org.das2.components;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Point;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowStateListener;
import java.util.ArrayList;
import java.util.EventListener;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.Icon;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JTabbedPane;
import javax.swing.SwingUtilities;

public class TearoffTabbedPane
extends JTabbedPane {
    int selectedTab;
    Point dragStart;
    Point dragOffset;
    JFrame draggingFrame;
    JPopupMenu tearOffMenu = new JPopupMenu();
    JPopupMenu dockMenu = new JPopupMenu();
    private TearoffTabbedPane parentPane;
    private TearoffTabbedPane rightPane = null;
    private JFrame rightFrame = null;
    private ComponentListener rightFrameListener;
    private int rightOffset = 0;
    private static final Logger logger = Logger.getLogger(TearoffTabbedPane.class.getCanonicalName());
    HashMap<Component, TabDesc> tabs = new HashMap();
    int lastSelected;
    private static final Object STICK_RIGHT = "right";

    private static void copyInputMap(JFrame parent, JFrame babySitter) {
        Container c = parent.getContentPane();
        if (!(c instanceof JComponent)) {
            return;
        }
        JComponent parentc = (JComponent)c;
        c = babySitter.getContentPane();
        if (!(c instanceof JComponent)) {
            return;
        }
        JComponent babySitterC = (JComponent)c;
        InputMap m = parentc.getInputMap(2);
        if (m == null) {
            return;
        }
        babySitterC.setInputMap(2, m);
        ActionMap am = parentc.getActionMap();
        if (am == null) {
            return;
        }
        babySitterC.setActionMap(am);
    }

    public TearoffTabbedPane() {
        this(null);
    }

    private TearoffTabbedPane(TearoffTabbedPane parent) {
        if (parent == null) {
            MouseAdapter ma = this.getParentMouseAdapter();
            this.addMouseListener(ma);
            this.addMouseMotionListener(this.getMouseMotionListener());
        } else {
            this.parentPane = parent;
            this.addMouseListener(this.getChildMouseAdapter());
        }
    }

    public void hideMouseAdapter() {
        EventListener ml;
        MouseListener[] mls = this.getMouseListeners();
        if (mls.length > 0) {
            ml = mls[mls.length - 1];
            this.removeMouseListener((MouseListener)ml);
        }
        if (this.getMouseMotionListeners().length > 0) {
            ml = this.getMouseMotionListeners()[0];
            this.removeMouseMotionListener((MouseMotionListener)ml);
        }
    }

    private MouseMotionListener getMouseMotionListener() {
        return new MouseMotionListener(){

            public void mouseDragged(MouseEvent e) {
                if (TearoffTabbedPane.this.selectedTab == -1) {
                    return;
                }
                if (TearoffTabbedPane.this.dragStart == null) {
                    TearoffTabbedPane.this.dragStart = e.getPoint();
                } else if (TearoffTabbedPane.this.dragStart.distance(e.getPoint()) > 10.0) {
                    if (TearoffTabbedPane.this.draggingFrame == null) {
                        TearoffTabbedPane.this.setSelectedIndex(TearoffTabbedPane.this.selectedTab);
                        TearoffTabbedPane.this.getComponentAt(TearoffTabbedPane.this.selectedTab).setVisible(true);
                        TearoffTabbedPane.this.dragOffset = TearoffTabbedPane.this.getComponentAt(TearoffTabbedPane.this.selectedTab).getLocationOnScreen();
                        Point ds = new Point(TearoffTabbedPane.this.dragStart);
                        SwingUtilities.convertPointToScreen(ds, e.getComponent());
                        int tabAndWindowHeight = 40;
                        TearoffTabbedPane.this.dragOffset.translate(-ds.x, -ds.y - tabAndWindowHeight);
                        TearoffTabbedPane.this.draggingFrame = TearoffTabbedPane.this.tearOffIntoFrame(TearoffTabbedPane.this.selectedTab);
                        if (TearoffTabbedPane.this.draggingFrame == null) {
                            return;
                        }
                        TearoffTabbedPane.this.setCursor(new Cursor(13));
                        if (TearoffTabbedPane.this.draggingFrame.getWidth() < -1 * TearoffTabbedPane.this.dragOffset.x) {
                            int borderWidth = 5;
                            TearoffTabbedPane.this.dragOffset.x = -1 * (TearoffTabbedPane.this.draggingFrame.getWidth() - borderWidth);
                        }
                    }
                    Point p = e.getPoint();
                    SwingUtilities.convertPointToScreen(p, (Component)e.getSource());
                    p.translate(TearoffTabbedPane.this.dragOffset.x, TearoffTabbedPane.this.dragOffset.y);
                    TearoffTabbedPane.this.draggingFrame.setLocation(p);
                }
            }

            public void mouseMoved(MouseEvent e) {
            }
        };
    }

    private void showPopupMenu(MouseEvent event) {
        this.selectedTab = this.indexAtLocation(event.getX(), event.getY());
        if (this.selectedTab != -1) {
            Component selectedComponent = this.getComponentAt(this.selectedTab);
            if (this.parentPane == null && this.tabs.get(selectedComponent) != null) {
                this.tearOffMenu.show(this, event.getX(), event.getY());
            } else {
                this.dockMenu.show(this, event.getX(), event.getY());
            }
        }
    }

    private MouseAdapter getChildMouseAdapter() {
        return new MouseAdapter(){
            Component selectedComponent;
            {
                TearoffTabbedPane.this.dockMenu.add(new JMenuItem(new AbstractAction("dock"){

                    public void actionPerformed(ActionEvent event) {
                        if (TearoffTabbedPane.this.parentPane != null) {
                            selectedComponent = TearoffTabbedPane.this.getComponent(TearoffTabbedPane.this.selectedTab);
                            TearoffTabbedPane.this.remove(selectedComponent);
                            TearoffTabbedPane.this.parentPane.dock(selectedComponent);
                            if (TearoffTabbedPane.this.getTabCount() == 0) {
                                SwingUtilities.getWindowAncestor(TearoffTabbedPane.this).dispose();
                            }
                        } else {
                            throw new IllegalArgumentException("parentPane must not be null");
                        }
                    }
                }));
            }

            public void mousePressed(MouseEvent event) {
                TearoffTabbedPane.this.selectedTab = TearoffTabbedPane.this.indexAtLocation(event.getX(), event.getY());
                if (event.isPopupTrigger()) {
                    TearoffTabbedPane.this.showPopupMenu(event);
                }
            }

            public void mouseReleased(MouseEvent e) {
                if (TearoffTabbedPane.this.dragStart != null && TearoffTabbedPane.this.selectedTab != -1) {
                    TearoffTabbedPane.this.setCursor(null);
                    TearoffTabbedPane.this.draggingFrame = null;
                }
                TearoffTabbedPane.this.dragStart = null;
                if (e.isPopupTrigger()) {
                    TearoffTabbedPane.this.showPopupMenu(e);
                }
            }
        };
    }

    private static void raiseApplicationWindow(Window window) {
        window.setVisible(true);
        if (window instanceof Frame) {
            Frame frame = (Frame)window;
            int state = frame.getExtendedState();
            frame.setExtendedState(state &= 0xFFFFFFFE);
        }
        window.setAlwaysOnTop(true);
        window.toFront();
        window.requestFocus();
        window.setAlwaysOnTop(false);
        window.setVisible(false);
        window.setVisible(true);
    }

    private MouseAdapter getParentMouseAdapter() {
        return new MouseAdapter(){
            Component selectedComponent;
            {
                TearoffTabbedPane.this.tearOffMenu.add(new JMenuItem(new AbstractAction("undock"){

                    public void actionPerformed(ActionEvent event) {
                        TearoffTabbedPane.this.tearOffIntoFrame(TearoffTabbedPane.this.selectedTab);
                    }
                }));
                TearoffTabbedPane.this.tearOffMenu.add(new JMenuItem(new AbstractAction("slide right"){

                    public void actionPerformed(ActionEvent event) {
                        TearoffTabbedPane.this.slideRight(TearoffTabbedPane.this.selectedTab);
                    }
                }));
                TearoffTabbedPane.this.dockMenu.add(new JMenuItem(new AbstractAction("show"){

                    public void actionPerformed(ActionEvent event) {
                        TabDesc desc = null;
                        Component babyComponent = null;
                        for (Component key : TearoffTabbedPane.this.tabs.keySet()) {
                            TabDesc d = TearoffTabbedPane.this.tabs.get(key);
                            if (d.index != TearoffTabbedPane.this.selectedTab) continue;
                            desc = d;
                            babyComponent = key;
                            break;
                        }
                        if (desc == null) {
                            return;
                        }
                        if (desc.babysitter instanceof Window) {
                            Window babySitter = (Window)desc.babysitter;
                            TearoffTabbedPane.raiseApplicationWindow(babySitter);
                        } else if (desc.babysitter instanceof TearoffTabbedPane) {
                            Window parent = SwingUtilities.getWindowAncestor(babyComponent);
                            TearoffTabbedPane.raiseApplicationWindow(parent);
                        }
                    }
                }));
                TearoffTabbedPane.this.dockMenu.add(new JMenuItem(new AbstractAction("dock"){

                    public void actionPerformed(ActionEvent event) {
                        TearoffTabbedPane bb;
                        TabDesc desc = null;
                        Component babyComponent = null;
                        for (Component key : TearoffTabbedPane.this.tabs.keySet()) {
                            TabDesc d = TearoffTabbedPane.this.tabs.get(key);
                            if (d.index != TearoffTabbedPane.this.selectedTab) continue;
                            desc = d;
                            babyComponent = key;
                            break;
                        }
                        if (desc == null) {
                            return;
                        }
                        if (desc.babysitter instanceof Window) {
                            ((Window)desc.babysitter).dispose();
                        } else if (desc.babysitter instanceof TearoffTabbedPane && (bb = (TearoffTabbedPane)desc.babysitter).getTabCount() == 1) {
                            SwingUtilities.getWindowAncestor(bb).dispose();
                        }
                        TearoffTabbedPane.this.dock(babyComponent);
                    }
                }));
            }

            public void mousePressed(MouseEvent event) {
                TearoffTabbedPane.this.selectedTab = TearoffTabbedPane.this.indexAtLocation(event.getX(), event.getY());
                if (event.isPopupTrigger()) {
                    TearoffTabbedPane.this.showPopupMenu(event);
                }
            }

            public void mouseReleased(MouseEvent e) {
                if (TearoffTabbedPane.this.dragStart != null && TearoffTabbedPane.this.selectedTab != -1) {
                    TearoffTabbedPane.this.setCursor(null);
                    TearoffTabbedPane.this.draggingFrame = null;
                }
                TearoffTabbedPane.this.dragStart = null;
                if (e.isPopupTrigger()) {
                    TearoffTabbedPane.this.showPopupMenu(e);
                }
            }
        };
    }

    static Component getTornOffComponent() {
        JPanel tornOffComponent = new JPanel();
        tornOffComponent.setLayout(new BorderLayout());
        tornOffComponent.add((Component)new JLabel("<html><i>This tab is undocked.  Right-click on the tab name and select dock.</i></html>"), "North");
        return tornOffComponent;
    }

    public void tearOff(int tabIndex, Container newContainer) {
        int lastSelected1 = this.lastSelected;
        Component c = this.getComponentAt(tabIndex);
        String title = super.getTitleAt(tabIndex);
        super.removeTabAt(tabIndex);
        super.insertTab("(" + title + ")", null, TearoffTabbedPane.getTornOffComponent(), null, tabIndex);
        super.setEnabledAt(tabIndex, false);
        TabDesc td = this.tabs.get(c);
        td.babysitter = newContainer;
        if (newContainer instanceof TearoffTabbedPane) {
            TearoffTabbedPane tt = (TearoffTabbedPane)newContainer;
            Window ttp = SwingUtilities.getWindowAncestor(tt);
            int dx = ttp.getWidth() - (tt.getWidth() - 20);
            int dy = ttp.getHeight() - (tt.getHeight() - 40);
            if (tt.getTabCount() == 0) {
                ttp.setSize(c.getPreferredSize().width + dx, c.getPreferredSize().height + dy);
            }
        }
        this.setSelectedIndex(lastSelected1);
    }

    public ComponentListener getFrameComponentListener(final Component panel1, final Component frame1, final Component panel2, final Component frame2, final Object direction) {
        return new ComponentListener(){
            Component activeComponent;
            long activeComponentTime = 0L;

            public void componentResized(ComponentEvent e) {
                long t = System.currentTimeMillis();
                if (t - this.activeComponentTime > 100L) {
                    this.activeComponent = e.getComponent();
                }
                if (e.getComponent() == this.activeComponent) {
                    this.activeComponentTime = t;
                    TearoffTabbedPane.this.updateAttached(this.activeComponent, panel1, frame1, panel2, frame2, direction, true);
                }
            }

            public void componentMoved(ComponentEvent e) {
                long t = System.currentTimeMillis();
                if (t - this.activeComponentTime > 100L) {
                    this.activeComponent = e.getComponent();
                }
                if (e.getComponent() == this.activeComponent) {
                    this.activeComponentTime = t;
                    TearoffTabbedPane.this.updateAttached(this.activeComponent, panel1, frame1, panel2, frame2, direction, false);
                }
            }

            public void componentShown(ComponentEvent e) {
            }

            public void componentHidden(ComponentEvent e) {
            }
        };
    }

    private void updateAttached(Component active, Component panel1, Component frame1, Component panel2, Component frame2, Object direction, boolean updateSize) {
        Point p = SwingUtilities.convertPoint(panel1, 0, 0, frame1);
        Point p2 = SwingUtilities.convertPoint(panel2, 0, 0, frame2);
        Dimension s1 = panel1.getSize();
        Dimension frameSize1 = frame1.getSize();
        Dimension s2 = panel2.getSize();
        if (direction == STICK_RIGHT) {
            if (active == frame1) {
                int delta = frame2.getWidth() - (int)s2.getWidth();
                if (updateSize) {
                    frame2.setSize(new Dimension(s2.width + delta, s1.height + p2.y));
                }
                frame2.setLocation(frame1.getX() + frame1.getWidth() - p2.x + this.rightOffset, frame1.getY() + p.y - p2.y);
            } else {
                int x = Math.max(frame1.getX(), frame2.getX() - frameSize1.width + p2.x);
                this.rightOffset = frame2.getX() - s1.width - frame1.getX();
                if (this.rightOffset > 0) {
                    this.rightOffset = 0;
                }
                if (this.rightOffset < -1 * s1.width) {
                    x += s1.width + this.rightOffset;
                    this.rightOffset = -1 * s1.width;
                }
                frame1.setLocation(x, frame2.getY() - p.y + p2.y);
            }
        }
    }

    private synchronized TearoffTabbedPane getRightTabbedPane() {
        if (this.rightPane == null) {
            final JFrame parent = (JFrame)SwingUtilities.getWindowAncestor(this);
            this.rightPane = new TearoffTabbedPane(this);
            this.rightFrame = new JFrame();
            this.rightFrame.add(this.rightPane);
            this.rightFrame.setIconImage(parent.getIconImage());
            this.rightFrame.setTitle(parent.getTitle().toLowerCase());
            final WindowStateListener listener = new WindowStateListener(){

                public void windowStateChanged(WindowEvent e) {
                    TearoffTabbedPane.this.rightFrame.setExtendedState(parent.getExtendedState());
                }
            };
            parent.addWindowStateListener(listener);
            this.rightFrame.addWindowListener(new WindowAdapter(){

                public void windowClosing(WindowEvent e) {
                    parent.removeWindowStateListener(listener);
                    parent.removeComponentListener(TearoffTabbedPane.this.rightFrameListener);
                    for (Component c : new ArrayList<Component>(((TearoffTabbedPane)TearoffTabbedPane.this).rightPane.tabs.keySet())) {
                        TearoffTabbedPane.this.dock(c);
                    }
                    TearoffTabbedPane.this.rightFrame = null;
                    TearoffTabbedPane.this.rightPane = null;
                }
            });
            TearoffTabbedPane.copyInputMap(parent, this.rightFrame);
            this.rightFrameListener = this.getFrameComponentListener(this, parent, this.rightPane, this.rightFrame, STICK_RIGHT);
            parent.addComponentListener(this.rightFrameListener);
            this.rightFrame.addComponentListener(this.rightFrameListener);
            this.rightPane.setPreferredSize(this.getSize());
            this.rightFrame.pack();
            this.updateAttached(parent, this, parent, this.rightPane, this.rightFrame, STICK_RIGHT, true);
            this.rightFrame.setVisible(true);
            parent.toFront();
        }
        return this.rightPane;
    }

    protected void slideRight(int tabIndex) {
        Component c = this.getComponentAt(tabIndex);
        logger.log(Level.FINEST, "slideRight {0}", c);
        this.setSelectedIndex(tabIndex);
        c.setVisible(true);
        TabDesc td = this.tabs.get(c);
        if (td == null) {
            return;
        }
        TearoffTabbedPane right = this.getRightTabbedPane();
        this.tearOff(tabIndex, right);
        right.add(td.title, c);
        right.setSelectedIndex(right.getTabCount() - 1);
        if (!right.isShowing()) {
            Window w = SwingUtilities.getWindowAncestor(right);
            w.setVisible(false);
            w.setVisible(true);
        }
    }

    protected JFrame tearOffIntoFrame(int tabIndex) {
        final Component c = this.getComponentAt(tabIndex);
        logger.log(Level.FINEST, "tearOffInfoFrame {0}", c);
        this.setSelectedIndex(tabIndex);
        c.setVisible(true);
        Point p = c.getLocationOnScreen();
        TabDesc td = this.tabs.get(c);
        if (td == null) {
            return null;
        }
        final JFrame parent = (JFrame)SwingUtilities.getWindowAncestor(this);
        final JFrame babySitter = new JFrame(td.title);
        babySitter.setIconImage(parent.getIconImage());
        final WindowStateListener listener = new WindowStateListener(){

            public void windowStateChanged(WindowEvent e) {
                babySitter.setExtendedState(parent.getExtendedState());
            }
        };
        parent.addWindowStateListener(listener);
        p.translate(20, 20);
        babySitter.setLocation(p);
        babySitter.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                parent.removeWindowStateListener(listener);
                TearoffTabbedPane.this.dock(c);
            }
        });
        TearoffTabbedPane.copyInputMap(parent, babySitter);
        TearoffTabbedPane pane = new TearoffTabbedPane(this);
        babySitter.getContentPane().add(pane);
        this.tearOff(tabIndex, babySitter);
        pane.add(td.title, c);
        babySitter.pack();
        babySitter.setVisible(true);
        return babySitter;
    }

    public void dock(Component c) {
        logger.log(Level.FINEST, "dock {0}", c);
        int selectedIndex = this.getSelectedIndex();
        TabDesc td = this.tabs.get(c);
        int index = td.index;
        super.removeTabAt(index);
        super.insertTab(td.title, td.icon, c, td.tip, index);
        super.setEnabledAt(index, true);
        this.setSelectedIndex(selectedIndex);
    }

    public void addTab(String title, Icon icon, Component component) {
        super.addTab(title, icon, component);
        TabDesc td = new TabDesc(title, icon, null, this.indexOfComponent(component));
        this.tabs.put(component, td);
    }

    public void addTab(String title, Component component) {
        super.addTab(title, component);
        TabDesc td = new TabDesc(title, null, null, this.indexOfComponent(component));
        this.tabs.put(component, td);
    }

    public void insertTab(String title, Icon icon, Component component, String tip, int index) {
        super.insertTab(title, icon, component, tip, index);
        TabDesc td = new TabDesc(title, icon, tip, index);
        this.tabs.put(component, td);
    }

    public void addTab(String title, Icon icon, Component component, String tip) {
        super.addTab(title, icon, component, tip);
        TabDesc td = new TabDesc(title, icon, tip, this.indexOfComponent(component));
        this.tabs.put(component, td);
    }

    private Component getTabComponentByIndex(int index) {
        for (Component key : this.tabs.keySet()) {
            TabDesc td = this.tabs.get(key);
            if (td.index != index) continue;
            return key;
        }
        return null;
    }

    public void removeTabAt(int index) {
        Component c = this.getTabComponentByIndex(index);
        super.removeTabAt(index);
        TabDesc tab = this.tabs.get(c);
        if (tab != null) {
            if (tab.babysitter != null && tab.babysitter instanceof Window) {
                ((Window)tab.babysitter).dispose();
            }
            this.tabs.remove(c);
        } else {
            logger.fine("tabs didn't contain c, someone else removed it.");
        }
    }

    public void setSelectedIndex(int index) {
        if (index != this.getSelectedIndex()) {
            this.lastSelected = this.getSelectedIndex();
        }
        super.setSelectedIndex(index);
        logger.log(Level.FINEST, "setSelectedIndex {0}", this.getSelectedComponent());
    }

    private static class TabDesc {
        Icon icon;
        String title;
        String tip;
        int index;
        Container babysitter;

        TabDesc(String title, Icon icon, String tip, int index) {
            this.title = title;
            this.icon = icon;
            this.tip = tip;
            this.index = index;
            this.babysitter = null;
        }
    }
}

