/*
 * Decompiled with CFR 0.152.
 */
package org.das2.components.propertyeditor;

import java.beans.PropertyDescriptor;
import java.util.Enumeration;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import org.das2.components.propertyeditor.PropertyEditor;
import org.das2.components.propertyeditor.PropertyTreeNode;
import org.das2.components.propertyeditor.PropertyTreeNodeInterface;

public class PeerPropertyTreeNode
implements PropertyTreeNodeInterface {
    PeerPropertyTreeNode parent;
    PeerPropertyTreeNode[] children = null;
    PropertyTreeNode leader;
    PropertyTreeNode[] peers;
    private DefaultTreeModel treeModel;

    public PeerPropertyTreeNode(PeerPropertyTreeNode parent, PropertyTreeNode leader, PropertyTreeNode[] peers) {
        this.parent = parent;
        this.leader = leader;
        this.peers = peers;
    }

    public Enumeration children() {
        return new Enumeration(){
            int index = 0;

            public boolean hasMoreElements() {
                return this.index < PeerPropertyTreeNode.this.getChildCount();
            }

            public Object nextElement() {
                return PeerPropertyTreeNode.this.getChildAt(this.index++);
            }
        };
    }

    public boolean getAllowsChildren() {
        return this.leader.getAllowsChildren();
    }

    private synchronized void maybeCreateChildren() {
        if (this.children == null) {
            this.children = new PeerPropertyTreeNode[this.leader.getChildCount()];
            for (int childIndex = 0; childIndex < this.children.length; ++childIndex) {
                PropertyTreeNode[] peerChildren = new PropertyTreeNode[this.peers.length];
                for (int i = 0; i < this.peers.length; ++i) {
                    peerChildren[i] = (PropertyTreeNode)this.peers[i].getChildAt(childIndex);
                }
                PeerPropertyTreeNode child = new PeerPropertyTreeNode(this, (PropertyTreeNode)this.leader.getChildAt(childIndex), peerChildren);
                child.treeModel = this.treeModel;
                this.children[childIndex] = child;
            }
        }
    }

    public TreeNode getChildAt(int childIndex) {
        this.maybeCreateChildren();
        return this.children[childIndex];
    }

    public int getChildCount() {
        return this.leader.getChildCount();
    }

    public Class getColumnClass(int columnIndex) {
        return this.leader.getColumnClass(columnIndex);
    }

    public int getColumnCount() {
        return 2 + this.peers.length;
    }

    public String getColumnName(int columnIndex) {
        if (columnIndex > 1) {
            return String.valueOf(this.peers[columnIndex - 2].getDisplayValue());
        }
        return this.leader.getColumnName(columnIndex);
    }

    public int getIndex(TreeNode node) {
        this.maybeCreateChildren();
        for (int i = 0; i < this.getChildCount(); ++i) {
            if (node != this.children[i]) continue;
            return i;
        }
        return -1;
    }

    public TreeNode getParent() {
        return this.parent;
    }

    public Object getValueAt(int column) {
        if (column > 1) {
            return this.peers[column - 2].getValueAt(1);
        }
        switch (column) {
            case 0: {
                return this.leader.getDisplayName();
            }
            case 1: {
                return this.getDisplayValue();
            }
        }
        throw new IllegalArgumentException("No such column: " + column);
    }

    public boolean isCellEditable(int column) {
        return column > 0;
    }

    public boolean isDirty() {
        return this.leader.isDirty();
    }

    public boolean isLeaf() {
        return this.leader.isLeaf();
    }

    public void refresh() {
        this.leader.refresh();
        for (int i = 0; i < this.peers.length; ++i) {
            this.peers[i].refresh();
        }
    }

    public void setValueAt(Object value, int column) {
        if (column > 1) {
            this.peers[column - 2].setValueAt(value, 1);
        } else {
            switch (column) {
                case 0: {
                    throw new IllegalArgumentException("Cell is not editable");
                }
                case 1: {
                    if (value == PropertyEditor.MULTIPLE) break;
                    this.setValue(value);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("No such column: " + column);
                }
            }
        }
        this.treeModel.nodeChanged(this);
    }

    public void setTreeModel(DefaultTreeModel treeModel) {
        this.treeModel = treeModel;
        for (int i = 0; i < this.peers.length; ++i) {
            this.peers[i].setTreeModel(treeModel);
        }
        this.leader.setTreeModel(treeModel);
    }

    public Object getValue() {
        return this.leader.getValue();
    }

    public Object getDisplayValue() {
        Object value = this.leader.getDisplayValue();
        boolean warn = false;
        for (int i = 0; i < this.peers.length; ++i) {
            Object peerValue = this.peers[i].getDisplayValue();
            if (peerValue != null) {
                if (this.peers[i].getDisplayValue().equals(value)) continue;
                warn = true;
                continue;
            }
            if (value == null) continue;
            warn = true;
        }
        return warn ? PropertyEditor.MULTIPLE : value;
    }

    public void flush() {
        for (int i = 0; i < this.peers.length; ++i) {
            this.peers[i].flush();
        }
        this.leader.flush();
    }

    public PropertyDescriptor getPropertyDescriptor() {
        return this.leader.getPropertyDescriptor();
    }

    public String toString() {
        return this.leader.getDisplayName() + "";
    }

    public void setValue(Object value) {
        for (int i = 0; i < this.peers.length; ++i) {
            this.peers[i].setValue(value);
        }
        this.leader.setValue(value);
        this.treeModel.nodeChanged(this);
    }
}

