/*
 * Decompiled with CFR 0.152.
 */
package org.das2.dasml;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.das2.util.DasDie;
import org.xml.sax.Attributes;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public class DasMLValidator
extends DefaultHandler {
    public static Pattern INTEGER_PATTERN = Pattern.compile("(0|[1-9][0-9]*)");
    public static Pattern WINDOW_POSITION_PATTERN = Pattern.compile("\\((0|[1-9][0-9]*),(0|[1-9][0-9]*)\\)");
    public static Pattern FLOAT_PATTERN = Pattern.compile("-?[0-9]*(\\.[0-9]*)?([eE]-?[0-9]+)?");
    private static SAXParserFactory factory = SAXParserFactory.newInstance();
    private SAXParser parser = factory.newSAXParser();
    private ErrorHandler errorHandler;
    private SAXException lastError;
    private Locator locator;
    private Map typeMap = new HashMap();
    private List typeCheckList = new LinkedList();
    private boolean hasXAxis = false;
    private boolean hasYAxis = false;
    private boolean hasZAxis = false;
    private boolean insideSpectrogram = false;

    public boolean validate(InputSource source, ErrorHandler errorHandler) throws IOException {
        this.errorHandler = errorHandler;
        if (this == errorHandler) {
            throw new IllegalArgumentException("cannot pass an instance of DasMLValidator to its own validate() method");
        }
        this.lastError = null;
        try {
            this.typeMap.clear();
            this.typeCheckList.clear();
            this.parser.parse(source, (DefaultHandler)this);
        }
        catch (SAXException se) {
            this.lastError = se;
        }
        return this.lastError == null;
    }

    public SAXException getLastError() {
        return this.lastError;
    }

    public void fatalError(SAXParseException e) throws SAXException {
        if (this.errorHandler != null) {
            this.errorHandler.fatalError(e);
        }
        throw e;
    }

    public void setDocumentLocator(Locator locator) {
        this.locator = locator;
    }

    public void error(SAXParseException e) throws SAXException {
        if (this.errorHandler != null) {
            this.errorHandler.error(e);
        }
        this.lastError = e;
    }

    public void warning(SAXParseException e) throws SAXException {
        if (this.errorHandler != null) {
            this.errorHandler.warning(e);
        }
        this.lastError = e;
    }

    public void startDocument() throws SAXException {
    }

    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        String name = attributes.getValue("name");
        if (name != null) {
            if (this.typeMap.containsKey(name)) {
                this.errorInternal("An element with the name " + name + " already exists.  " + "The values of name attributes must be unique.");
            }
            this.typeMap.put(name, qName);
        }
        if (qName.equals("window")) {
            this.checkWindow(attributes);
        } else if (qName.equals("form")) {
            this.checkForm(attributes);
        } else if (qName.equals("textfield")) {
            this.checkTextfield(attributes);
        } else if (qName.equals("checkbox")) {
            this.checkCheckbox(attributes);
        } else if (!qName.equals("if") && !qName.equals("elseif")) {
            if (qName.equals("update")) {
                this.typeCheckList.add(new TypeCheck("update", "target", "spectrogram", attributes.getValue("target"), this.locator));
            } else if (qName.equals("radiobutton")) {
                this.checkRadiobutton(attributes);
            } else if (qName.equals("panel")) {
                this.checkPanel(attributes);
            } else if (qName.equals("glue")) {
                this.checkGlue(attributes);
            } else if (qName.equals("canvas")) {
                this.checkCanvas(attributes);
            } else if (qName.equals("row")) {
                this.checkRowColumn("row", attributes);
            } else if (qName.equals("column")) {
                this.checkRowColumn("column", attributes);
            } else if (qName.equals("spectrogram")) {
                this.checkSpectrogram(attributes);
            } else if (qName.equals("xAxis")) {
                this.checkXAxis(attributes);
            } else if (qName.equals("yAxis")) {
                this.checkYAxis(attributes);
            } else if (qName.equals("zAxis")) {
                this.checkZAxis(attributes);
            } else if (qName.equals("axis")) {
                this.checkAxis(attributes);
            } else if (qName.equals("timeaxis")) {
                this.checkTimeaxis(attributes);
            } else if (qName.equals("attachedaxis")) {
                this.checkAttachedaxis(attributes);
            } else if (qName.equals("colorbar")) {
                this.checkColorbar(attributes);
            }
        }
    }

    private void checkColorbar(Attributes attributes) throws SAXException {
        String row;
        String maximum;
        String minimum = attributes.getValue("minimum");
        if (!FLOAT_PATTERN.matcher(minimum).matches() || minimum.charAt(0) == '-') {
            this.errorInternal("The minimum attribute of a colorbar element must be a positive number");
        }
        if (!FLOAT_PATTERN.matcher(maximum = attributes.getValue("maximum")).matches() || maximum.charAt(0) == '-') {
            this.errorInternal("The maximum attribute of a colorbar element must be a positive number");
        }
        if ((row = attributes.getValue("row")) != null) {
            this.typeCheckList.add(new TypeCheck("colorbar", "row", "row", row, this.locator));
        } else if (!this.insideSpectrogram) {
            this.errorInternal("The \"row\" attribute of a \"colorbar\" element must be specified if the element is not nested in a \"spectrogram\" element");
        }
        String column = attributes.getValue("column");
        if (column != null) {
            this.typeCheckList.add(new TypeCheck("colorbar", "column", "column", column, this.locator));
        } else if (!this.insideSpectrogram) {
            this.errorInternal("The \"column\" attribute of a \"colorbar\" element must be specified if the element is not nested in a \"spectrogram\" element");
        }
        String log = attributes.getValue("log");
        if (!log.equals("true") && !log.equals("false")) {
            this.errorInternal("The log attribute of a colorbar must be either 'true' or 'false'");
        }
    }

    private void checkSpectrogram(Attributes attributes) throws SAXParseException {
        String colorbar;
        String yAxis;
        String row = attributes.getValue("row");
        this.typeCheckList.add(new TypeCheck("spectrogram", "row", "row", row, this.locator));
        String column = attributes.getValue("column");
        this.typeCheckList.add(new TypeCheck("spectrogram", "column", "column", column, this.locator));
        String xAxis = attributes.getValue("xAxis");
        if (xAxis != null) {
            this.typeCheckList.add(new TypeCheck("spectrogram", "xAxis", "axis|timeaxis|attachedaxis", xAxis, this.locator));
            this.hasXAxis = true;
        }
        if ((yAxis = attributes.getValue("yAxis")) != null) {
            this.typeCheckList.add(new TypeCheck("spectrogram", "yAxis", "axis|timeaxis|attachedaxis", yAxis, this.locator));
            this.hasYAxis = true;
        }
        if ((colorbar = attributes.getValue("colorbar")) != null) {
            this.typeCheckList.add(new TypeCheck("spectrogram", "colorbar", "colorbar", colorbar, this.locator));
            this.hasZAxis = true;
        }
        this.insideSpectrogram = true;
    }

    private void endCheckSpectrogram() throws SAXException {
        if (!this.hasXAxis) {
            this.errorInternal("No xAxis specified.  Spectrograms require an xAxis to be specified");
        }
        if (!this.hasYAxis) {
            this.errorInternal("No yAxis specified.  Spectrograms required a yAxis to be specified");
        }
        if (!this.hasZAxis) {
            this.errorInternal("No zAxis specified.  Spectrograms required a zAxis to be specified");
        }
        this.hasXAxis = false;
        this.hasYAxis = false;
        this.hasZAxis = false;
        this.insideSpectrogram = false;
    }

    private void checkXAxis(Attributes attributes) throws SAXException {
        this.hasXAxis = true;
    }

    private void checkYAxis(Attributes attributes) throws SAXException {
        this.hasYAxis = true;
    }

    private void checkZAxis(Attributes attributes) throws SAXException {
        this.hasZAxis = true;
    }

    private void checkAttachedaxis(Attributes attributes) throws SAXException {
        String ref = attributes.getValue("ref");
        this.typeCheckList.add(new TypeCheck("attachedaxis", "ref", "axis|timeaxis", ref, this.locator));
        String row = attributes.getValue("row");
        if (row != null) {
            this.typeCheckList.add(new TypeCheck("attachedaxis", "row", "row", row, this.locator));
        } else if (!this.insideSpectrogram) {
            this.errorInternal("The \"row\" attribute of an \"attachedaxis\" element must be specified if the element is not nested in a \"spectrogram\" element");
        }
        String column = attributes.getValue("column");
        if (column != null) {
            this.typeCheckList.add(new TypeCheck("attachedaxis", "column", "column", column, this.locator));
        } else if (!this.insideSpectrogram) {
            this.errorInternal("The \"column\" attribute of an \"attachedaxis\" element must be specified if the element is not nested in a \"spectrogram\" element");
        }
        String orientation = attributes.getValue("orientation");
        if (!orientation.equals("horizontal") && !orientation.equals("vertical")) {
            this.errorInternal("The orientation attibute of an attachedaxis element must be either 'horizontal' or 'vertical'");
        }
    }

    private void checkTimeaxis(Attributes attributes) throws SAXException {
        String row;
        String showTca = attributes.getValue("showTca");
        if (!showTca.equals("true") && !showTca.equals("false")) {
            this.errorInternal("The showTca attribute of a timeaxis element must be either 'true' or 'false'");
        }
        if ((row = attributes.getValue("row")) != null) {
            this.typeCheckList.add(new TypeCheck("timeaxis", "row", "row", row, this.locator));
        } else if (!this.insideSpectrogram) {
            this.errorInternal("The \"row\" attribute of a \"timeaxis\" element must be specified if the element is not nested in a \"spectrogram\" element");
        }
        String column = attributes.getValue("column");
        if (column != null) {
            this.typeCheckList.add(new TypeCheck("timeaxis", "column", "column", column, this.locator));
        } else if (!this.insideSpectrogram) {
            this.errorInternal("The \"column\" attribute of a \"timeaxis\" element must be specified if the element is not nested in a \"spectrogram\" element");
        }
        String orientation = attributes.getValue("orientation");
        if (!orientation.equals("horizontal") && !orientation.equals("vertical")) {
            this.errorInternal("The orientation attibute of an axis element must be either 'horizontal' or 'vertical'");
        }
        if (showTca.equals("true") && orientation.equals("vertical")) {
            this.errorInternal("Vertical axes cannot diplay time correlated annotations");
        }
    }

    private void checkAxis(Attributes attributes) throws SAXException {
        String row;
        String dataMinimum;
        String log = attributes.getValue("log");
        if (!log.equals("true") && !log.equals("false")) {
            this.errorInternal("The log attribute of an axis element must be either 'true' or 'false'");
        }
        if (!FLOAT_PATTERN.matcher(dataMinimum = attributes.getValue("dataMinimum")).matches()) {
            this.errorInternal("The dataMinimum attribute of an axis element must be a valid number'");
        }
        String dataMaximum = attributes.getValue("dataMaximum");
        if (!FLOAT_PATTERN.matcher(dataMinimum).matches()) {
            this.errorInternal("The dataMaximum attribute of an axis element must be a valid number'");
        }
        if ((row = attributes.getValue("row")) != null) {
            this.typeCheckList.add(new TypeCheck("axis", "row", "row", row, this.locator));
        } else if (!this.insideSpectrogram) {
            this.errorInternal("The \"row\" attribute of an \"axis\" element must be specified if the element is not nested in a \"spectrogram\" element");
        }
        String column = attributes.getValue("column");
        if (column != null) {
            this.typeCheckList.add(new TypeCheck("axis", "column", "column", column, this.locator));
        } else if (!this.insideSpectrogram) {
            this.errorInternal("The \"column\" attribute of an \"axis\" element must be specified if the element is not nested in a \"spectrogram\" element");
        }
        String orientation = attributes.getValue("orientation");
        if (!orientation.equals("horizontal") && !orientation.equals("vertical")) {
            this.errorInternal("The orientation attibute of an axis element must be either 'horizontal' or 'vertical'");
        }
    }

    private void checkRowColumn(String tagName, Attributes attributes) throws SAXException {
        String maximum;
        String minimum = attributes.getValue("minimum");
        if (!FLOAT_PATTERN.matcher(minimum).matches() || minimum.charAt(0) == '-') {
            this.errorInternal("The minimum attribute of a " + tagName + " element must be a positive number");
        }
        if (!FLOAT_PATTERN.matcher(maximum = attributes.getValue("maximum")).matches() || maximum.charAt(0) == '-') {
            this.errorInternal("The maximum attribute of a " + tagName + " element must be a positive number");
        }
    }

    private void checkCanvas(Attributes attributes) throws SAXException {
        String height;
        String width = attributes.getValue("width");
        if (!INTEGER_PATTERN.matcher(width).matches()) {
            this.errorInternal("The width attribute of a canvas element must be a positive integer");
        }
        if (!INTEGER_PATTERN.matcher(height = attributes.getValue("height")).matches()) {
            this.errorInternal("The height attribute of a canvas element must be a positive integer");
        }
    }

    private void checkGlue(Attributes attributes) throws SAXException {
        String direction = attributes.getValue("direction");
        if (!direction.equals("horizontal") && !direction.equals("vertical")) {
            this.errorInternal("The direction attribute of a glue element must be either 'horizontal' or 'vertical'");
        }
    }

    private void checkPanel(Attributes attributes) throws SAXException {
        String border;
        String direction = attributes.getValue("direction");
        if (!direction.equals("horizontal") && !direction.equals("vertical")) {
            this.errorInternal("The direction attribute of a panel element must be either 'horizontal' or 'vertical'");
        }
        if (!(border = attributes.getValue("border")).equals("true") && !border.equals("false")) {
            this.errorInternal("The border attribute of a panel element must be either 'true' or 'false'");
        }
    }

    private void checkRadiobutton(Attributes attributes) throws SAXException {
        String group = attributes.getValue("group");
        this.typeCheckList.add(new TypeCheck("radiobutton", "group", "buttongroup", group, this.locator));
        String selected = attributes.getValue("selected");
        if (!selected.equals("true") && !selected.equals("false")) {
            this.errorInternal("The selected attribute of a radiobutton element must be either 'true' or 'false'");
        }
    }

    private void checkCheckbox(Attributes attributes) throws SAXException {
        String selected = attributes.getValue("selected");
        if (!selected.equals("true") && !selected.equals("false")) {
            this.errorInternal("The selected attribute of a checkbox element must be either 'true' or 'false'");
        }
    }

    private void checkTextfield(Attributes attributes) throws SAXException {
        String length = attributes.getValue("length");
        if (!INTEGER_PATTERN.matcher(length).matches()) {
            this.errorInternal("The length attribute of textfield elements must be a positive integer");
        }
    }

    private void checkForm(Attributes attributes) throws SAXException {
        String alignment = attributes.getValue("alignment");
        if (!(alignment.equals("left") || alignment.equals("center") || alignment.equals("right"))) {
            this.errorInternal("The alignment attribute of a form element must be 'left', 'center', or 'right'");
        }
    }

    private void checkWindow(Attributes attributes) throws SAXException {
        String visible;
        String location;
        String height;
        String width = attributes.getValue("width");
        if (!INTEGER_PATTERN.matcher(width).matches()) {
            this.errorInternal("The width attribute of a window element must be a positve integer.");
        }
        if (!INTEGER_PATTERN.matcher(height = attributes.getValue("height")).matches()) {
            this.errorInternal("The height attribute of a window element must be a positive integer.");
        }
        if (!WINDOW_POSITION_PATTERN.matcher(location = attributes.getValue("location")).matches()) {
            this.errorInternal("The location attribute of a window element must be a pair of the form (x,y)");
        }
        if (!(visible = attributes.getValue("visible")).equals("true") && !visible.equals("false")) {
            this.errorInternal("The visible attribute of a window element must be either 'true' or 'false'");
        }
    }

    public void endDocument() throws SAXException {
        Iterator iterator = this.typeCheckList.iterator();
        SAXParseException exception = null;
        while (iterator.hasNext()) {
            TypeCheck check = (TypeCheck)iterator.next();
            String type = (String)this.typeMap.get(check.value);
            if (type == null) {
                exception = new SAXParseException("No element of type \"" + check.type + "\" with attribute " + "name=\"" + check.value + "\" exists.", check);
                this.error(exception);
            }
            if (Pattern.matches(check.type, type)) continue;
            exception = new SAXParseException("Element '" + check.elementName + "', " + "attribute '" + check.attributeName + "' : " + type + " expected, but found " + type + " (" + check.value + ")", check);
            this.error(exception);
        }
        if (exception != null) {
            throw exception;
        }
    }

    private void errorInternal(String message) throws SAXException {
        this.lastError = new SAXParseException(message, this.locator);
        this.error((SAXParseException)this.lastError);
    }

    public static void main(String[] args) {
        if (args.length < 1) {
            System.err.println("usage: java org.das2.dasml.DasMLValidator <filename>");
            return;
        }
        ErrorHandler errorHandler = new ErrorHandler(){

            public void warning(SAXParseException spe) throws SAXException {
                DasDie.println((String)("Line " + spe.getLineNumber() + ", " + spe.getMessage()));
            }

            public void error(SAXParseException spe) throws SAXException {
                DasDie.println((String)("Line " + spe.getLineNumber() + ", " + spe.getMessage()));
            }

            public void fatalError(SAXParseException spe) throws SAXException {
                DasDie.println((String)("Line " + spe.getLineNumber() + ", " + spe.getMessage()));
            }
        };
        try {
            String path = new File(args[0]).getCanonicalPath();
            DasMLValidator validator = new DasMLValidator();
            if (validator.validate(new InputSource("file://" + path), errorHandler)) {
                DasDie.println((String)"No errors");
            }
        }
        catch (ParserConfigurationException pce) {
            DasDie.println((String)pce.getMessage());
        }
        catch (SAXException se) {
            DasDie.println((String)se.getMessage());
        }
        catch (IOException ioe) {
            DasDie.println((String)ioe.getMessage());
        }
    }

    public void endElement(String uri, String localName, String qName) throws SAXException {
        if (qName.equals("spectrogram")) {
            this.endCheckSpectrogram();
        }
    }

    static {
        factory.setValidating(true);
    }

    private static class TypeCheck
    implements Locator {
        public String elementName;
        public String attributeName;
        public String type;
        public String value;
        private int lineNumber;
        private int columnNumber;
        private String publicId;
        private String systemId;

        public TypeCheck(String elementName, String attributeName, String type, String value, Locator locator) {
            this.elementName = elementName;
            this.attributeName = attributeName;
            this.type = type;
            this.value = value;
            this.lineNumber = locator.getLineNumber();
            this.columnNumber = locator.getColumnNumber();
            this.publicId = locator.getPublicId();
            this.systemId = locator.getSystemId();
        }

        public int getColumnNumber() {
            return this.columnNumber;
        }

        public int getLineNumber() {
            return this.lineNumber;
        }

        public String getPublicId() {
            return this.publicId;
        }

        public String getSystemId() {
            return this.systemId;
        }
    }
}

