/*
 * Decompiled with CFR 0.152.
 */
package org.das2.dasml;

import java.awt.Container;
import java.awt.event.MouseEvent;
import java.lang.reflect.InvocationTargetException;
import javax.swing.JButton;
import org.das2.DasApplication;
import org.das2.DasException;
import org.das2.DasNameException;
import org.das2.DasPropertyException;
import org.das2.NameContext;
import org.das2.components.propertyeditor.Editable;
import org.das2.dasml.CommandAction;
import org.das2.dasml.CommandBlock;
import org.das2.dasml.DefaultComponentDnDSupport;
import org.das2.dasml.FormBase;
import org.das2.dasml.FormComponent;
import org.das2.dasml.ParsedExpressionException;
import org.das2.util.DasExceptionHandler;
import org.das2.util.DnDSupport;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class FormButton
extends JButton
implements Editable,
FormComponent {
    CommandAction commandAction;
    CommandBlock commandBlock;
    private boolean editable;
    private String dasName;
    protected DnDSupport dndSupport;

    public FormButton(String name, String label) {
        super(label);
        if (name == null) {
            name = "button_" + Integer.toHexString(System.identityHashCode(this));
        }
        try {
            this.setDasName(name);
        }
        catch (DasNameException dne) {
            DasExceptionHandler.handle((Throwable)dne);
        }
    }

    FormButton(Element element, FormBase form) throws DasPropertyException, ParsedExpressionException {
        String name = element.getAttribute("name");
        String label = element.getAttribute("label");
        boolean enabled = element.getAttribute("enabled").equals("true");
        this.setText(label);
        this.setEnabled(enabled);
        if (!name.equals("")) {
            try {
                this.setDasName(name);
            }
            catch (DasNameException dne) {
                DasExceptionHandler.handle((Throwable)dne);
            }
        }
        NodeList children = element.getChildNodes();
        int childCount = children.getLength();
        for (int index = 0; index < childCount; ++index) {
            Node node = children.item(index);
            if (!(node instanceof Element) || !node.getNodeName().equals("action")) continue;
            Element actionElement = (Element)node;
            this.commandBlock = new CommandBlock(actionElement, form);
            this.commandAction = new CommandAction(this.commandBlock);
            this.addActionListener(this.commandAction);
        }
    }

    public CommandBlock getFormAction() {
        return this.commandBlock;
    }

    public void setFormAction(CommandBlock cb) {
        if (cb == this.commandBlock) {
            return;
        }
        if (this.commandBlock != null) {
            this.removeActionListener(this.commandAction);
        }
        if (cb == null) {
            this.commandAction = null;
            this.commandBlock = null;
        } else {
            this.commandBlock = cb;
            this.commandAction = new CommandAction(this.commandBlock);
            this.addActionListener(this.commandAction);
        }
    }

    public Element getDOMElement(Document document) {
        Element element = document.createElement("button");
        element.setAttribute("name", this.getDasName());
        element.setAttribute("label", this.getText());
        element.setAttribute("enabled", String.valueOf(this.isEnabled()));
        if (this.commandBlock != null) {
            Element actionElement = document.createElement("action");
            this.commandBlock.appendDOMElements(actionElement);
            element.appendChild(actionElement);
        }
        return element;
    }

    public String getDasName() {
        return this.dasName;
    }

    public void setDasName(String name) throws DasNameException {
        if (name.equals(this.dasName)) {
            return;
        }
        String oldName = this.dasName;
        this.dasName = name;
        DasApplication app = this.getDasApplication();
        if (app != null) {
            app.getNameContext().put(name, this);
            if (oldName != null) {
                app.getNameContext().remove(oldName);
            }
        }
        this.firePropertyChange("name", oldName, name);
    }

    public FormBase getForm() {
        FormComponent parent = (FormComponent)((Object)this.getParent());
        if (parent == null) {
            return null;
        }
        return parent.getForm();
    }

    public boolean getEditingMode() {
        return this.editable;
    }

    public void setEditingMode(boolean b) {
        this.editable = b;
    }

    public DnDSupport getDnDSupport() {
        if (this.dndSupport == null) {
            this.dndSupport = new DefaultComponentDnDSupport(this);
        }
        return this.dndSupport;
    }

    public boolean startDrag(int x, int y, int action, MouseEvent evt) {
        return false;
    }

    public void deregisterComponent() {
        DasApplication app = this.getDasApplication();
        if (app != null) {
            NameContext nc = app.getNameContext();
            try {
                if (nc.get(this.getDasName()) == this) {
                    nc.remove(this.getDasName());
                }
            }
            catch (DasPropertyException dpe) {
                IllegalStateException se = new IllegalStateException(dpe.toString());
                se.initCause(dpe);
                throw se;
            }
            catch (InvocationTargetException ite) {
                IllegalStateException se = new IllegalStateException(ite.toString());
                se.initCause(ite);
                throw se;
            }
        }
    }

    public DasApplication getDasApplication() {
        Container p = this.getParent();
        if (p instanceof FormComponent) {
            return ((FormComponent)((Object)p)).getDasApplication();
        }
        return null;
    }

    public void registerComponent() throws DasException {
        DasApplication app = this.getDasApplication();
        if (app != null) {
            NameContext nc = app.getNameContext();
            nc.put(this.getDasName(), this);
        }
    }
}

