/*
 * Decompiled with CFR 0.152.
 */
package org.das2.dataset;

import org.das2.datum.Datum;
import org.das2.datum.DatumRange;
import org.das2.datum.DatumUtil;

public class CacheTag {
    public static final String INTRINSIC = "intrinsic";
    DatumRange range;
    Datum resolution;

    public static CacheTag append(CacheTag tag1, CacheTag tag2) {
        Datum max;
        Datum min;
        Datum res;
        if (tag1.resolution == null && tag2.resolution == null) {
            res = null;
        } else if (tag1.resolution != null && tag2.resolution != null) {
            res = tag1.resolution.gt(tag2.resolution) ? tag1.resolution : tag2.resolution;
        } else {
            Datum datum = res = tag1.resolution == null ? tag2.resolution : tag1.resolution;
        }
        if (!tag1.range.intersects(tag2.range)) {
            if (tag2.range.min().lt(tag1.range.min())) {
                CacheTag temp = tag1;
                tag1 = tag2;
                tag2 = temp;
            }
            if (tag1.range.max().lt(tag2.range.min())) {
                throw new IllegalArgumentException("cache tags cannot be appended, they are not adjacent");
            }
            min = tag1.range.min();
            max = tag2.range.max();
        } else {
            min = tag1.range.min().lt(tag2.range.min()) ? tag1.range.min() : tag2.range.min();
            max = tag1.range.max().gt(tag2.range.max()) ? tag1.range.max() : tag2.range.max();
        }
        DatumRange range = new DatumRange(min, max);
        return new CacheTag(range, res);
    }

    public CacheTag(Datum start, Datum end, Datum resolution) {
        this(new DatumRange(start, end), resolution);
    }

    public CacheTag(DatumRange range, Datum resolution) {
        this.range = range;
        this.resolution = resolution;
    }

    public String toString() {
        return this.range + " @ " + (this.resolution == null ? INTRINSIC : "" + DatumUtil.asOrderOneUnits((Datum)this.resolution));
    }

    public boolean contains(CacheTag tag) {
        return this.range.contains(tag.range) && (this.resolution == null || tag.resolution != null && this.resolution.le(tag.resolution));
    }

    public DatumRange getRange() {
        return this.range;
    }

    public Datum getResolution() {
        return this.resolution;
    }
}

