/*
 * Decompiled with CFR 0.152.
 */
package org.das2.dataset;

import java.util.Map;
import org.das2.dataset.DataSet;
import org.das2.dataset.DataSetUtil;
import org.das2.dataset.VectorDataSet;
import org.das2.datum.Datum;
import org.das2.datum.DatumRange;
import org.das2.datum.Units;

public class ClippedVectorDataSet
implements VectorDataSet {
    int xoffset;
    int xlength;
    VectorDataSet source;

    public ClippedVectorDataSet(VectorDataSet source, DatumRange xclip) {
        this.xoffset = DataSetUtil.getPreviousColumn(source, xclip.min());
        this.xlength = DataSetUtil.getNextColumn(source, xclip.max()) - this.xoffset;
        this.source = source;
    }

    public ClippedVectorDataSet(VectorDataSet source, int xoffset, int xlength) {
        this.xoffset = xoffset;
        this.xlength = xlength;
        this.source = source;
    }

    public Datum getDatum(int i) {
        return this.source.getDatum(i + this.xoffset);
    }

    public double getDouble(int i, Units units) {
        return this.source.getDouble(i + this.xoffset, units);
    }

    public int getInt(int i, Units units) {
        return this.source.getInt(i + this.xoffset, units);
    }

    public DataSet getPlanarView(String planeID) {
        return new ClippedVectorDataSet((VectorDataSet)this.source.getPlanarView(planeID), this.xoffset, this.xlength);
    }

    public String[] getPlaneIds() {
        return this.source.getPlaneIds();
    }

    public Map getProperties() {
        return this.source.getProperties();
    }

    public Object getProperty(String name) {
        return this.source.getProperty(name);
    }

    public int getXLength() {
        return this.xlength;
    }

    public Datum getXTagDatum(int i) {
        return this.source.getXTagDatum(i + this.xoffset);
    }

    public double getXTagDouble(int i, Units units) {
        return this.source.getXTagDouble(i + this.xoffset, units);
    }

    public int getXTagInt(int i, Units units) {
        return this.source.getXTagInt(i + this.xoffset, units);
    }

    public Units getXUnits() {
        return this.source.getXUnits();
    }

    public Units getYUnits() {
        return this.source.getYUnits();
    }
}

