/*
 * Decompiled with CFR 0.152.
 */
package org.das2.dataset;

import java.util.Arrays;
import org.das2.dataset.CacheTag;
import org.das2.dataset.DataSet;
import org.das2.dataset.TableDataSet;
import org.das2.dataset.TableDataSetBuilder;
import org.das2.dataset.VectorDataSet;
import org.das2.dataset.VectorDataSetBuilder;
import org.das2.dataset.VectorUtil;
import org.das2.dataset.WeightsTableDataSet;
import org.das2.dataset.WeightsVectorDataSet;
import org.das2.datum.Datum;
import org.das2.datum.DatumRange;
import org.das2.datum.DatumVector;
import org.das2.datum.Units;

public class DataSetUtil {
    public static CacheTag guessCacheTag(DataSet ds) {
        if (ds.getProperty("cacheTag") != null) {
            return (CacheTag)ds.getProperty("cacheTag");
        }
        Datum start = ds.getXTagDatum(0);
        Datum end = ds.getXTagDatum(ds.getXLength() - 1);
        Datum resolution = ds.getXTagDatum(1).subtract(start);
        return new CacheTag(start, end, resolution);
    }

    public static DatumRange xRange(DataSet ds) {
        int n = ds.getXLength();
        return new DatumRange(ds.getXTagDatum(0), ds.getXTagDatum(n - 1));
    }

    private static DatumRange yRangeTDS(TableDataSet ds) {
        DatumRange result = null;
        if (ds.tableCount() == 0) {
            return new DatumRange(0.0, 10.0, ds.getYUnits());
        }
        for (int i = 0; i < ds.tableCount(); ++i) {
            int n = ds.getYLength(i);
            DatumRange d = ds.getYTagDatum(i, 0).le(ds.getYTagDatum(i, n - 1)) ? new DatumRange(ds.getYTagDatum(i, 0), ds.getYTagDatum(i, n - 1)) : new DatumRange(ds.getYTagDatum(i, n - 1), ds.getYTagDatum(i, 0));
            result = result == null ? d : result.include(d.min()).include(d.max());
        }
        return result;
    }

    public static DatumRange yRange(DataSet ds) {
        if (ds.getProperty("yRange") != null) {
            return (DatumRange)ds.getProperty("yRange");
        }
        if (ds instanceof VectorDataSet) {
            VectorDataSet vds = (VectorDataSet)ds;
            Datum min = null;
            Datum max = null;
            for (int i = 0; i < ds.getXLength(); ++i) {
                Datum d = vds.getDatum(i);
                if (d.isFill()) continue;
                if (min == null) {
                    max = min = d;
                    continue;
                }
                if (d.lt(min)) {
                    min = d;
                }
                if (!d.gt(max)) continue;
                max = d;
            }
            DatumRange result = min == null ? new DatumRange(0.0, 10.0, ds.getYUnits()) : new DatumRange(min, max);
            return result;
        }
        if (ds instanceof TableDataSet) {
            return DataSetUtil.yRangeTDS((TableDataSet)ds);
        }
        throw new IllegalArgumentException("unsupported: " + ds);
    }

    public static Datum guessXTagWidth(DataSet table) {
        if (table.getProperty("xTagWidth") != null) {
            return (Datum)table.getProperty("xTagWidth");
        }
        if (table.getXLength() > 1) {
            Units units = table.getXUnits();
            double min = Math.abs(table.getXTagDouble(1, units) - table.getXTagDouble(0, units));
            for (int i = 2; i < table.getXLength(); ++i) {
                double min0 = Math.abs(table.getXTagDouble(i, units) - table.getXTagDouble(i - 1, units));
                if (!(min0 < min)) continue;
                min = min0;
            }
            return units.getOffsetUnits().createDatum(min);
        }
        return table.getXUnits().getOffsetUnits().createDatum(0);
    }

    protected static int closest(double[] xx, double x) {
        if (xx[xx.length - 1] < xx[0]) {
            double[] minusxx = new double[xx.length];
            for (int i = 0; i < xx.length; ++i) {
                minusxx[i] = -1.0 * xx[i];
            }
            xx = minusxx;
            x = -1.0 * x;
        }
        if (xx.length == 0) {
            throw new IllegalArgumentException("array has no elements");
        }
        int result = Arrays.binarySearch(xx, x);
        if (result == -1) {
            result = 0;
        } else if (result < 0) {
            result = (result ^= 0xFFFFFFFF) == xx.length ? xx.length - 1 : ((x - xx[result - 1]) / (xx[result] - xx[result - 1]) < 0.5 ? result - 1 : result);
        }
        return result;
    }

    public static int xTagBinarySearch(DataSet ds, Datum datum, int low, int high) {
        Units units = datum.getUnits();
        double key = datum.doubleValue(units);
        while (low <= high) {
            int cmp;
            int mid = low + high >> 1;
            double midVal = ds.getXTagDouble(mid, units);
            if (midVal < key) {
                cmp = -1;
            } else if (midVal > key) {
                cmp = 1;
            } else {
                long keyBits;
                long midBits = Double.doubleToLongBits(midVal);
                int n = midBits == (keyBits = Double.doubleToLongBits(key)) ? 0 : (cmp = midBits < keyBits ? -1 : 1);
            }
            if (cmp < 0) {
                low = mid + 1;
                continue;
            }
            if (cmp > 0) {
                high = mid - 1;
                continue;
            }
            return mid;
        }
        return -(low + 1);
    }

    public static int closestColumn(DataSet table, Datum datum) {
        int result = DataSetUtil.xTagBinarySearch(table, datum, 0, table.getXLength() - 1);
        if (result == -1) {
            result = 0;
        } else if (result < 0) {
            double x1;
            double x0;
            double x;
            result = (result ^= 0xFFFFFFFF) >= table.getXLength() - 1 ? table.getXLength() - 1 : (((x = datum.doubleValue(datum.getUnits())) - (x0 = table.getXTagDouble(result - 1, datum.getUnits()))) / ((x1 = table.getXTagDouble(result, datum.getUnits())) - x0) < 0.5 ? result - 1 : result);
        }
        return result;
    }

    public static int closestColumn(DataSet table, double x, Units units) {
        return DataSetUtil.closestColumn(table, units.createDatum(x));
    }

    public static int closestColumn(DataSet table, Datum xdatum, int guessIndex) {
        Units units;
        int monotonicDir = 1;
        int result = guessIndex;
        int len = table.getXLength();
        if (len == 1) {
            return 0;
        }
        if (result >= len - 1) {
            result = len - 2;
        }
        if (result < 0) {
            result = 0;
        }
        if (table.getXTagDouble(result, units = xdatum.getUnits()) > table.getXTagDouble(result + 1, units)) {
            monotonicDir = -1;
        }
        double x = xdatum.doubleValue(units);
        if (monotonicDir == 1) {
            while (result < len - 1 && table.getXTagDouble(result, units) < x) {
                ++result;
            }
            while (result > 0 && table.getXTagDouble(result, units) > x) {
                --result;
            }
        } else {
            while (result < len - 1 && table.getXTagDouble(result, units) > x) {
                ++result;
            }
            while (result > 0 && table.getXTagDouble(result, units) < x) {
                --result;
            }
        }
        if (result < len - 1) {
            double alpha = (x - table.getXTagDouble(result, units)) / (table.getXTagDouble(result + 1, units) - table.getXTagDouble(result, units));
            result = alpha < 0.5 ? result : result + 1;
        }
        return result;
    }

    public static int getPreviousColumn(DataSet ds, Datum datum) {
        int i = DataSetUtil.closestColumn(ds, datum);
        if (i > 0 && ds.getXTagDatum(i).ge(datum)) {
            return i - 1;
        }
        return i;
    }

    public static int getNextColumn(DataSet ds, Datum datum) {
        int i = DataSetUtil.closestColumn(ds, datum);
        if (i < ds.getXLength() - 1 && ds.getXTagDatum(i).le(datum)) {
            return i + 1;
        }
        return i;
    }

    public static double[] getXTagArrayDouble(DataSet vds, Units units) {
        int ixmax = vds.getXLength();
        double[] xx = new double[ixmax];
        for (int i = 0; i < ixmax; ++i) {
            xx[i] = vds.getXTagDouble(i, units);
        }
        return xx;
    }

    public static DatumVector getXTags(DataSet ds) {
        double[] data = VectorUtil.getXTagArrayDouble(ds, ds.getXUnits());
        return DatumVector.newDatumVector((double[])data, (Units)ds.getXUnits());
    }

    public static DatumRange zRange(DataSet ds) {
        if (!(ds instanceof TableDataSet)) {
            throw new UnsupportedOperationException("only TableDataSets supported");
        }
        if (ds.getProperty("zRange") != null) {
            return (DatumRange)ds.getProperty("zRange");
        }
        TableDataSet tds = (TableDataSet)ds;
        double max = Double.NEGATIVE_INFINITY;
        double min = Double.POSITIVE_INFINITY;
        double fill = tds.getZUnits().getFillDouble();
        Units zunits = tds.getZUnits();
        for (int itable = 0; itable < tds.tableCount(); ++itable) {
            int ny = tds.getYLength(itable);
            for (int i = tds.tableStart(itable); i < tds.tableEnd(itable); ++i) {
                for (int j = 0; j < ny; ++j) {
                    double d = tds.getDouble(i, j, zunits);
                    if (!zunits.isValid(d)) continue;
                    max = Math.max(d, max);
                    min = Math.min(d, min);
                }
            }
        }
        if (max == Double.NEGATIVE_INFINITY) {
            max = fill;
            min = fill;
        }
        return DatumRange.newDatumRange((double)min, (double)max, (Units)zunits);
    }

    public static long guessSizeBytes(DataSet ds) {
        Long o = (Long)ds.getProperty("sizeBytes");
        if (o != null) {
            return o;
        }
        long planeCount = ds.getPlaneIds().length;
        int datumBytes = 8;
        long sizeXTags = ds.getXLength() * datumBytes;
        if (ds instanceof TableDataSet) {
            TableDataSet tds = (TableDataSet)ds;
            long sizeBytes = 0L;
            for (int i = 0; i < tds.tableCount(); ++i) {
                sizeBytes += (long)((tds.tableEnd(i) - tds.tableStart(i)) * tds.getYLength(i)) * planeCount * (long)datumBytes;
            }
            return sizeBytes + sizeXTags;
        }
        return (long)ds.getXLength() * planeCount * (long)datumBytes + sizeXTags;
    }

    public static DataSet append(DataSet ds1, DataSet ds2, CacheTag ct) {
        CacheTag resultTag = null;
        if (ct != null) {
            resultTag = ct;
        } else if (ds2 != null) {
            resultTag = DataSetUtil.guessCacheTag(ds2);
        }
        if (ds1 != null) {
            resultTag = resultTag == null ? DataSetUtil.guessCacheTag(ds1) : CacheTag.append(DataSetUtil.guessCacheTag(ds1), resultTag);
        }
        if (ds2 == null) {
            return ds1;
        }
        if (ds2 instanceof TableDataSet) {
            TableDataSetBuilder builder = new TableDataSetBuilder(ds2.getXUnits(), ds2.getYUnits(), ((TableDataSet)ds2).getZUnits());
            if (ds1 != null) {
                builder.append((TableDataSet)ds1);
            }
            builder.append((TableDataSet)ds2);
            builder.setProperty("cacheTag", resultTag);
            return builder.toTableDataSet();
        }
        VectorDataSetBuilder builder = new VectorDataSetBuilder(ds2.getXUnits(), ds2.getYUnits());
        if (ds1 != null) {
            builder.append((VectorDataSet)ds1);
        }
        builder.append((VectorDataSet)ds2);
        builder.setProperty("cacheTag", resultTag);
        return builder.toVectorDataSet();
    }

    public static DataSet append(DataSet ds1, DataSet ds2) {
        return DataSetUtil.append(ds1, ds2, null);
    }

    public static VectorDataSet log10(VectorDataSet ds) {
        VectorDataSetBuilder builder = new VectorDataSetBuilder(ds.getXUnits(), Units.dimensionless);
        Units yunits = ds.getYUnits();
        Units xunits = ds.getXUnits();
        for (int i = 0; i < ds.getXLength(); ++i) {
            builder.insertY(ds.getXTagDouble(i, xunits), Math.log10(ds.getDouble(i, yunits)));
        }
        return builder.toVectorDataSet();
    }

    public static String[] getAllPlaneIds(DataSet ds) {
        String[] planes = ds.getPlaneIds();
        boolean haveDefault = false;
        for (int i = 0; i < planes.length; ++i) {
            if (!planes[i].equals("")) continue;
            haveDefault = true;
        }
        if (haveDefault) {
            return planes;
        }
        String[] newPlanes = new String[planes.length + 1];
        newPlanes[0] = "";
        for (int i = 0; i < planes.length; ++i) {
            newPlanes[i + 1] = planes[i];
        }
        return newPlanes;
    }

    public static DataSet getWeightsDataSet(DataSet ds) {
        DataSet wds = ds.getPlanarView("weights");
        if (wds != null) {
            return wds;
        }
        if (ds instanceof TableDataSet) {
            return WeightsTableDataSet.create((TableDataSet)ds);
        }
        return WeightsVectorDataSet.create((VectorDataSet)ds);
    }
}

