/*
 * Decompiled with CFR 0.152.
 */
package org.das2.dataset;

import java.util.Arrays;
import java.util.Collections;
import org.das2.dataset.DataSet;
import org.das2.dataset.DefaultTableDataSet;
import org.das2.dataset.RebinDescriptor;
import org.das2.dataset.TableDataSet;
import org.das2.datum.Units;

public class PeakTableRebinner {
    public DataSet rebin(DataSet ds, RebinDescriptor ddX, RebinDescriptor ddY) throws IllegalArgumentException {
        Object yTags;
        double[] xTags;
        if (!(ds instanceof TableDataSet)) {
            throw new IllegalArgumentException();
        }
        TableDataSet tds = (TableDataSet)ds;
        long timer = System.currentTimeMillis();
        int nx = ddX == null ? tds.getXLength() : ddX.numberOfBins();
        int ny = ddY == null ? tds.getYLength(0) : ddY.numberOfBins();
        double[][] rebinData = new double[nx][ny];
        double[][] rebinWeights = new double[nx][ny];
        PeakTableRebinner.peaks(tds, rebinData, ddX, ddY);
        if (ddX != null) {
            xTags = ddX.binCenters();
        } else {
            xTags = new double[tds.getXLength()];
            for (int i = 0; i < xTags.length; ++i) {
                xTags[i] = tds.getXTagDouble(i, tds.getXUnits());
            }
        }
        if (ddY != null) {
            yTags = new double[][]{ddY.binCenters()};
        } else {
            yTags = new double[0][tds.getYLength(0)];
            for (int j = 0; j < yTags[0].length; ++j) {
                yTags[0][j] = tds.getYTagDouble(0, j, tds.getYUnits());
            }
        }
        double[][][] zValues = new double[][][]{rebinData};
        int[] tableOffsets = new int[]{0};
        Units[] zUnits = new Units[]{tds.getZUnits()};
        String[] planeIDs = new String[]{""};
        return new DefaultTableDataSet(xTags, tds.getXUnits(), (double[][])yTags, tds.getYUnits(), (double[][][])zValues, zUnits, planeIDs, tableOffsets, Collections.EMPTY_MAP);
    }

    static void peaks(TableDataSet tds, double[][] rebinData, RebinDescriptor ddX, RebinDescriptor ddY) {
        double[] ycoordinate;
        if (ddY != null) {
            ycoordinate = ddY.binCenters();
        } else {
            ycoordinate = new double[tds.getYLength(0)];
            for (int j = 0; j < ycoordinate.length; ++j) {
                ycoordinate[j] = tds.getDouble(0, j, tds.getYUnits());
            }
        }
        int nx = ddX == null ? tds.getXLength() : ddX.numberOfBins();
        int ny = ddY == null ? tds.getYLength(0) : ddY.numberOfBins();
        for (int i = 0; i < rebinData.length; ++i) {
            Arrays.fill(rebinData[i], Double.NaN);
        }
        int[] ibiny = new int[tds.getYLength(0)];
        for (int j = 0; j < ibiny.length; ++j) {
            ibiny[j] = ddY != null ? ddY.whichBin(tds.getYTagDouble(0, j, tds.getYUnits()), tds.getYUnits()) : j;
        }
        for (int i = 0; i < tds.getXLength(); ++i) {
            int ibinx = ddX != null ? ddX.whichBin(tds.getXTagDouble(i, tds.getXUnits()), tds.getXUnits()) : i;
            if (ibinx < 0 || ibinx >= nx) continue;
            for (int j = 0; j < ibiny.length; ++j) {
                if (ibiny[j] < 0 || ibiny[j] >= ny) continue;
                double value = tds.getDouble(i, j, tds.getZUnits());
                rebinData[ibinx][ibiny[j]] = Double.isNaN(rebinData[ibinx][ibiny[j]]) ? value : Math.max(value, rebinData[ibinx][ibiny[j]]);
            }
        }
    }
}

