/*
 * Decompiled with CFR 0.152.
 */
package org.das2.dataset;

import java.util.HashMap;
import java.util.Map;
import org.das2.dataset.AbstractDataSetCache;
import org.das2.dataset.CacheTag;
import org.das2.dataset.DataSet;
import org.das2.dataset.DataSetDescriptor;

public class SimpleDataSetCache
extends AbstractDataSetCache {
    protected Map buffer = new HashMap();

    public void store(DataSetDescriptor dsd, CacheTag cacheTag, DataSet data) {
        AbstractDataSetCache.Entry entry = new AbstractDataSetCache.Entry(dsd, cacheTag, data);
        this.buffer.put(dsd, entry);
    }

    public boolean haveStoredImpl(DataSetDescriptor dsd, CacheTag cacheTag) {
        AbstractDataSetCache.Entry haveEntry = (AbstractDataSetCache.Entry)this.buffer.get(dsd);
        if (haveEntry == null) {
            return false;
        }
        AbstractDataSetCache.Entry entry = new AbstractDataSetCache.Entry(dsd, cacheTag, null);
        return haveEntry.satifies(entry);
    }

    public DataSet retrieveImpl(DataSetDescriptor dsd, CacheTag cacheTag) {
        AbstractDataSetCache.Entry haveEntry = (AbstractDataSetCache.Entry)this.buffer.get(dsd);
        if (haveEntry == null) {
            throw new IllegalArgumentException("Data not found in cache");
        }
        AbstractDataSetCache.Entry entry = new AbstractDataSetCache.Entry(dsd, cacheTag, null);
        if (haveEntry.satifies(entry)) {
            return haveEntry.getData();
        }
        throw new IllegalArgumentException("Data not found in cache");
    }

    public void reset() {
        this.buffer = new HashMap();
    }

    public String toString() {
        StringBuffer result = new StringBuffer("\n---SimpleDataSetCache---\n");
        for (Object key : this.buffer.keySet()) {
            result.append(" ");
            result.append(this.buffer.get(key).toString());
            result.append("\n");
        }
        result.append("------------------------\n");
        return result.toString();
    }
}

