/*
 * Decompiled with CFR 0.152.
 */
package org.das2.dataset.model;

import java.util.Random;
import org.das2.datum.Datum;
import org.das2.datum.Units;
import org.das2.math.PoissonDistribution;
import org.das2.util.DasMath;
import org.virbo.dataset.DDataSet;
import org.virbo.dataset.DataSetUtil;
import org.virbo.dataset.QDataSet;
import org.virbo.dataset.QubeDataSetIterator;
import org.virbo.dataset.SemanticOps;
import org.virbo.dataset.WritableDataSet;

public class PlasmaModel {
    public double nc = 1.2;
    public double wcperp = 8.0E8;
    public double wcparl = 8.0E8;
    public double mass = 9.11E-28;
    boolean isotropic = true;
    double geomFactor = 1.0E-37;

    public void setDensity(Datum density) {
        this.nc = density.doubleValue(Units.pcm3);
    }

    public Datum getDensity() {
        return Units.pcm3.createDatum(this.nc);
    }

    public double f(double energy, Units units) {
        if (units != Units.eV) {
            throw new IllegalArgumentException("units must be in eV");
        }
        if (!this.isotropic) {
            throw new IllegalArgumentException("distribution is not isotropic, need theta,phi");
        }
        double v = Math.sqrt(2.0 * energy * 1.6E-19 * 1.0E7 / this.mass);
        double logfc = DasMath.log10((double)(this.nc / (Math.pow(Math.PI, 1.5) * this.wcparl * this.wcparl))) - 3.0 * Math.pow(v / this.wcparl, 2.0);
        return DasMath.exp10((double)logfc);
    }

    public double fcounts(double energy, Units units, Random random) {
        if (units != Units.eV) {
            throw new IllegalArgumentException("units must be in eV");
        }
        double fcount = 2.0 * (energy / this.mass) * (energy / this.mass) * this.geomFactor * this.f(energy, units);
        return fcount;
    }

    public QDataSet fcounts(QDataSet energy, Random random) {
        DDataSet result = DDataSet.create((int[])DataSetUtil.qubeDims((QDataSet)energy));
        Units u = SemanticOps.getUnits((QDataSet)energy);
        QubeDataSetIterator it = new QubeDataSetIterator(energy);
        while (it.hasNext()) {
            it.next();
            it.putValue((WritableDataSet)result, this.fcounts(it.getValue(energy), u, random));
        }
        return result;
    }

    public int counts(double energy, Units units, Random random) {
        if (units != Units.eV) {
            throw new IllegalArgumentException("units must be in eV");
        }
        double fcount = 2.0 * (energy / this.mass) * (energy / this.mass) * this.geomFactor * this.f(energy, units);
        return PoissonDistribution.poisson(fcount, random);
    }

    public QDataSet counts(QDataSet energy, Random random) {
        DDataSet result = DDataSet.create((int[])DataSetUtil.qubeDims((QDataSet)energy));
        Units u = SemanticOps.getUnits((QDataSet)energy);
        QubeDataSetIterator it = new QubeDataSetIterator(energy);
        while (it.hasNext()) {
            it.next();
            it.putValue((WritableDataSet)result, (double)this.counts(it.getValue(energy), u, random));
        }
        return result;
    }
}

