/*
 * Decompiled with CFR 0.152.
 */
package org.das2.dataset.parser;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.das2.dataset.VectorDataSet;
import org.das2.dataset.VectorDataSetBuilder;
import org.das2.datum.Units;

public class VectorDataSetParser {
    Pattern propertyPattern;
    String commentRegex;
    Pattern recordPattern;
    String[] fieldNames;
    static final String numberPart = "[\\d\\.eE\\+\\-]+";
    static final String decimalRegex = "[\\d\\.eE\\+\\-]+";
    int skipLines;
    int recordCountLimit;
    int fieldCount;
    public static final Pattern NAME_COLON_VALUE_PATTERN = Pattern.compile("\\s*(.+?)\\s*\\:\\s*(.+)\\s*");
    public static final Pattern NAME_EQUAL_VALUE_PATTERN = Pattern.compile("\\s*(.+?)\\s*\\=\\s*(.+)\\s*");

    private VectorDataSetParser(String[] fieldNames) {
        this.fieldCount = fieldNames.length;
        this.fieldNames = fieldNames;
        StringBuffer regexBuf = new StringBuffer();
        regexBuf.append("\\s*");
        for (int i = 0; i < this.fieldCount - 1; ++i) {
            regexBuf.append("([\\d\\.eE\\+\\-]+)[\\s+,+]\\s*");
        }
        regexBuf.append("([\\d\\.eE\\+\\-]+)\\s*");
        this.recordPattern = this.recordPattern = Pattern.compile(regexBuf.toString());
    }

    public static int guessFieldCount(String filename) throws FileNotFoundException, IOException {
        String line;
        int maxFieldCount = 8;
        int[] recCount = new int[8];
        StringBuffer regexBuf = new StringBuffer();
        regexBuf.append("\\s*([\\d\\.eE\\+\\-]+)");
        for (int i = 1; i < 8; ++i) {
            regexBuf.append("([\\s+,+]\\s*([\\d\\.eE\\+\\-]+))?");
        }
        regexBuf.append("\\s*");
        Pattern pat = Pattern.compile(regexBuf.toString());
        LineNumberReader reader = new LineNumberReader(new FileReader(filename));
        block1: while ((line = ((BufferedReader)reader).readLine()) != null) {
            Matcher m = pat.matcher(line);
            if (!m.matches()) continue;
            for (int j = 1; j < m.groupCount(); j += 2) {
                if (m.group(j) != null) continue;
                int n = (j - 1) / 2;
                recCount[n] = recCount[n] + 1;
                continue block1;
            }
        }
        int max = 0;
        int imax = 0;
        for (int j = 1; j < 8; ++j) {
            if (recCount[j] <= max) continue;
            imax = j;
            max = recCount[j];
        }
        return imax;
    }

    public static VectorDataSetParser newParser(int fieldCount) {
        String[] fieldNames = new String[fieldCount];
        for (int i = 0; i < fieldCount; ++i) {
            fieldNames[i] = "field" + i;
        }
        return new VectorDataSetParser(fieldNames);
    }

    public static VectorDataSetParser newParser(String[] fieldNames) {
        return new VectorDataSetParser(fieldNames);
    }

    public void setSkipLines(int skipLines) {
        this.skipLines = skipLines;
    }

    public void setRecordCountLimit(int recordCountLimit) {
        this.recordCountLimit = recordCountLimit;
    }

    public void setPropertyPattern(Pattern propertyPattern) {
        this.propertyPattern = propertyPattern;
    }

    public VectorDataSet readStream(InputStream in) throws IOException {
        String line;
        BufferedReader reader = new BufferedReader(new InputStreamReader(in));
        int iline = 0;
        int irec = 0;
        VectorDataSetBuilder builder = new VectorDataSetBuilder(Units.dimensionless, Units.dimensionless);
        for (int i = 0; i < this.fieldCount; ++i) {
            builder.addPlane(this.fieldNames[i], Units.dimensionless);
        }
        while ((line = reader.readLine()) != null) {
            try {
                if (iline < this.skipLines) break;
                Matcher m = this.recordPattern.matcher(line);
                if (m.matches()) {
                    int i;
                    boolean allInvalid = true;
                    for (i = 0; i < this.fieldCount; ++i) {
                        try {
                            double d = Double.parseDouble(m.group(i + 1));
                            allInvalid = false;
                            continue;
                        }
                        catch (NumberFormatException e) {
                            // empty catch block
                        }
                    }
                    if (allInvalid) continue;
                    for (i = 0; i < this.fieldCount; ++i) {
                        builder.insertY(irec, Double.parseDouble(m.group(i + 1)), this.fieldNames[i]);
                    }
                    ++irec;
                    continue;
                }
                if (this.propertyPattern == null || !(m = this.propertyPattern.matcher(line)).matches()) continue;
                builder.setProperty(m.group(1).trim(), m.group(2).trim());
            }
            catch (NumberFormatException e) {
                e.printStackTrace();
            }
        }
        return builder.toVectorDataSet();
    }

    public VectorDataSet readFile(String filename) throws IOException {
        return this.readStream(new FileInputStream(filename));
    }

    public static void main(String[] args) throws Exception {
        String file = "L:/ct/virbo/autoplot/data/2490lintest90005.dat";
        System.err.println(VectorDataSetParser.guessFieldCount(file));
        VectorDataSetParser parser = VectorDataSetParser.newParser(5);
        parser.setPropertyPattern(Pattern.compile("\\s*(.+)\\s*\\:\\s*(.+)\\s*"));
        long t0 = System.currentTimeMillis();
        VectorDataSet ds = parser.readFile("j:/ct/ncvs/sarahFFT/lintest10/2490lintest100002.raw");
        System.out.println("" + (System.currentTimeMillis() - t0));
        System.out.println(ds.getProperty("Frequency"));
        System.out.flush();
    }
}

