/*
 * Decompiled with CFR 0.152.
 */
package org.das2.event;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import org.das2.event.BoxRenderer;
import org.das2.event.DragRenderer;
import org.das2.event.GesturesRenderer;
import org.das2.event.HorizontalRangeGesturesRenderer;
import org.das2.event.MouseDragEvent;
import org.das2.event.VerticalRangeGesturesRenderer;
import org.das2.graph.DasCanvasComponent;

public class BoxZoomGesturesRenderer
extends BoxRenderer {
    GesturesRenderer gr;
    DragRenderer hr;
    DragRenderer vr;

    public BoxZoomGesturesRenderer(DasCanvasComponent parent) {
        super(parent);
        this.gr = new GesturesRenderer(parent);
        this.hr = new HorizontalRangeGesturesRenderer(parent);
        this.vr = new VerticalRangeGesturesRenderer(parent);
    }

    public void clear(Graphics g) {
        this.parent.paintImmediately(this.dirtyBounds);
    }

    private Type idType(Point p1, Point p2) {
        boolean edgeX;
        int ymax = Math.max(p1.y, p2.y);
        int ymin = Math.min(p1.y, p2.y);
        int xmax = Math.max(p1.x, p2.x);
        int xmin = Math.min(p1.x, p2.x);
        double boxAspect = (float)(ymax - ymin) / (float)(xmax - xmin);
        boolean edgeY = ymax > this.parent.getRow().getDMaximum() || ymin < this.parent.getRow().getDMinimum();
        boolean bl = edgeX = xmax > this.parent.getColumn().getDMaximum() || xmin < this.parent.getColumn().getDMinimum();
        if (ymax - ymin < 5 || boxAspect < 0.1 && edgeY) {
            return Type.XAXIS;
        }
        if (xmax - xmin < 5 || boxAspect > 10.0 && edgeX) {
            return Type.YAXIS;
        }
        if (edgeY && boxAspect < 0.2) {
            return Type.XAXIS;
        }
        if (edgeX && boxAspect > 5.0) {
            return Type.YAXIS;
        }
        return Type.BOX;
    }

    public Rectangle[] renderDrag(Graphics g1, Point p1, Point p2) {
        Graphics2D g = (Graphics2D)g1;
        if (this.gr.isGesture(p1, p2)) {
            Rectangle[] rr = this.gr.renderDrag(g, p1, p2);
            this.dirtyBounds = rr[0];
        } else {
            Type t = this.idType(p1, p2);
            if (t == Type.XAXIS) {
                Rectangle[] rr = this.hr.renderDrag(g1, p1, p2);
                this.dirtyBounds = rr[0];
            } else if (t == Type.YAXIS) {
                Rectangle[] rr = this.vr.renderDrag(g1, p1, p2);
                this.dirtyBounds = rr[0];
            } else {
                Rectangle r = new Rectangle(p1);
                r.add(p2);
                Color color0 = g.getColor();
                g.setColor(new Color(255, 255, 255, 100));
                g.setStroke(new BasicStroke(3.0f, 1, 1));
                g.drawRect(r.x, r.y, r.width, r.height);
                g.setStroke(new BasicStroke());
                g.setColor(color0);
                g.drawRect(r.x, r.y, r.width, r.height);
                this.dirtyBounds.setLocation(r.x - 2, r.y - 3);
                this.dirtyBounds.add(r.x + r.width + 2, r.y + r.height + 3);
            }
        }
        return new Rectangle[]{this.dirtyBounds};
    }

    public MouseDragEvent getMouseDragEvent(Object source, Point p1, Point p2, boolean isModified) {
        if (this.gr.isGesture(p1, p2)) {
            return this.gr.getMouseDragEvent(source, p1, p2, isModified);
        }
        return super.getMouseDragEvent(source, p1, p2, isModified);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum Type {
        BOX,
        XAXIS,
        YAXIS;

    }
}

