/*
 * Decompiled with CFR 0.152.
 */
package org.das2.event;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.channels.FileChannel;
import javax.swing.JFileChooser;
import javax.swing.filechooser.FileFilter;
import org.das2.dataset.ClippedTableDataSet;
import org.das2.dataset.DataSet;
import org.das2.dataset.DataSetAdapter;
import org.das2.dataset.DataSetConsumer;
import org.das2.dataset.TableDataSet;
import org.das2.dataset.TableUtil;
import org.das2.dataset.VectorDataSet;
import org.das2.dataset.VectorUtil;
import org.das2.datum.DatumRange;
import org.das2.event.BoxRenderer;
import org.das2.event.MouseBoxEvent;
import org.das2.event.MouseDragEvent;
import org.das2.event.MouseModule;
import org.das2.graph.DasAxis;
import org.das2.graph.DasCanvasComponent;
import org.das2.graph.DasPlot;
import org.das2.system.UserMessageCenter;
import org.das2.util.DasExceptionHandler;
import org.virbo.dataset.QDataSet;
import org.virbo.dataset.SemanticOps;
import org.virbo.dsutil.DataSetBuilder;

public class DumpToFileMouseModule
extends MouseModule {
    DasAxis xAxis;
    DasAxis yAxis;
    DataSetConsumer dsConsumer;

    public DumpToFileMouseModule(DasCanvasComponent parent, DataSetConsumer dsConsumer, DasAxis xAxis, DasAxis yAxis) {
        super(parent, new BoxRenderer(parent), "Dump to File");
        if (!xAxis.isHorizontal()) {
            throw new IllegalArgumentException("X Axis orientation is not horizontal");
        }
        if (yAxis.isHorizontal()) {
            throw new IllegalArgumentException("Y Axis orientation is not vertical");
        }
        this.xAxis = xAxis;
        this.yAxis = yAxis;
        this.dsConsumer = dsConsumer;
    }

    public static DumpToFileMouseModule create(DasPlot parent, DataSetConsumer dsConsumer) {
        DumpToFileMouseModule result = new DumpToFileMouseModule(parent, dsConsumer, parent.getXAxis(), parent.getYAxis());
        return result;
    }

    public void mouseRangeSelected(MouseDragEvent e0) {
        ClippedTableDataSet outds;
        MouseBoxEvent e = (MouseBoxEvent)e0;
        DatumRange xrange = new DatumRange(this.xAxis.invTransform(e.getXMinimum()), this.xAxis.invTransform(e.getXMaximum()));
        DatumRange yrange = new DatumRange(this.yAxis.invTransform(e.getYMaximum()), this.yAxis.invTransform(e.getYMinimum()));
        QDataSet ds = this.dsConsumer.getConsumedDataSet();
        if (ds == null) {
            UserMessageCenter.getDefault().notifyUser((Object)this, "This renderer doesn't have a dataset loaded");
            return;
        }
        if (SemanticOps.isTableDataSet((QDataSet)ds)) {
            QDataSet tds = ds;
            outds = new ClippedTableDataSet(tds, xrange, yrange);
        } else {
            QDataSet vds = ds;
            DataSetBuilder builder = new DataSetBuilder(2, 100, 2);
            QDataSet xds = SemanticOps.xtagsDataSet((QDataSet)vds);
            for (int i = 0; i < vds.length(); ++i) {
                if (!(yrange.contains(SemanticOps.getDatum((QDataSet)vds, (double)vds.value(i))) & xrange.contains(SemanticOps.getDatum((QDataSet)xds, (double)xds.value(i))))) continue;
                builder.putValue(-1, 0, xds.value(i));
                builder.putValue(-1, 1, vds.value(i));
            }
            outds = builder.getDataSet();
        }
        JFileChooser chooser = new JFileChooser();
        chooser.setFileFilter(new FileFilter(){

            public boolean accept(File f) {
                if (f.toString() == null) {
                    return false;
                }
                return f.toString().matches(".*\\.das2Stream");
            }

            public String getDescription() {
                return "*.das2Stream";
            }
        });
        int result = chooser.showSaveDialog(this.parent);
        if (result == 0) {
            File selected = chooser.getSelectedFile();
            try {
                FileChannel out = new FileOutputStream(selected).getChannel();
                DataSet outds2 = DataSetAdapter.createLegacyDataSet((QDataSet)outds);
                if (outds2 instanceof TableDataSet) {
                    TableUtil.dumpToAsciiStream((TableDataSet)outds2, out);
                } else if (outds instanceof VectorDataSet) {
                    VectorUtil.dumpToAsciiStream((VectorDataSet)outds2, out);
                }
            }
            catch (IOException ioe) {
                DasExceptionHandler.handle((Throwable)ioe);
            }
        }
    }

    public DumpToFileMouseModule() {
    }
}

