/*
 * Decompiled with CFR 0.152.
 */
package org.das2.event;

import javax.swing.event.EventListenerList;
import org.das2.datum.Datum;
import org.das2.datum.DatumRange;
import org.das2.event.DataRangeSelectionEvent;
import org.das2.event.DataRangeSelectionListener;
import org.das2.event.Gesture;
import org.das2.event.HorizontalRangeGesturesRenderer;
import org.das2.event.MouseDragEvent;
import org.das2.event.MouseModule;
import org.das2.event.MouseRangeSelectionEvent;
import org.das2.graph.DasAxis;
import org.das2.graph.DasCanvasComponent;
import org.das2.graph.DasPlot;

public class HorizontalRangeSelectorMouseModule
extends MouseModule {
    DasAxis axis;
    private EventListenerList listenerList = null;

    public HorizontalRangeSelectorMouseModule(DasCanvasComponent parent, DasAxis axis) {
        super(parent, new HorizontalRangeGesturesRenderer(parent), "Zoom X");
        if (!axis.isHorizontal()) {
            throw new IllegalArgumentException("Axis orientation is not horizontal");
        }
        this.axis = axis;
    }

    public static HorizontalRangeSelectorMouseModule create(DasPlot parent) {
        HorizontalRangeSelectorMouseModule result = new HorizontalRangeSelectorMouseModule(parent, parent.getXAxis());
        return result;
    }

    public void mouseRangeSelected(MouseDragEvent e0) {
        if (!e0.isGesture()) {
            MouseRangeSelectionEvent e = (MouseRangeSelectionEvent)e0;
            Datum min = this.axis.invTransform(e.getMinimum());
            Datum max = this.axis.invTransform(e.getMaximum());
            DatumRange dr = new DatumRange(min, max);
            DatumRange nndr = this.axis.getTickV().enclosingRange(dr, true);
            DataRangeSelectionEvent te = new DataRangeSelectionEvent(e0.getSource(), nndr.min(), nndr.max());
            this.fireDataRangeSelectionListenerDataRangeSelected(te);
        } else if (e0.getGesture() == Gesture.BACK) {
            this.axis.setDataRangePrev();
        } else if (e0.getGesture() == Gesture.ZOOMOUT) {
            this.axis.setDataRangeZoomOut();
        } else if (e0.getGesture() == Gesture.FORWARD) {
            this.axis.setDataRangeForward();
        } else if (e0.getGesture() == Gesture.SCANPREV) {
            this.axis.scanPrevious();
        } else if (e0.getGesture() == Gesture.SCANNEXT) {
            this.axis.scanNext();
        }
    }

    public synchronized void addDataRangeSelectionListener(DataRangeSelectionListener listener) {
        if (this.listenerList == null) {
            this.listenerList = new EventListenerList();
        }
        this.listenerList.add(DataRangeSelectionListener.class, listener);
    }

    public synchronized void removeDataRangeSelectionListener(DataRangeSelectionListener listener) {
        this.listenerList.remove(DataRangeSelectionListener.class, listener);
    }

    private void fireDataRangeSelectionListenerDataRangeSelected(DataRangeSelectionEvent event) {
        if (this.listenerList == null) {
            return;
        }
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != DataRangeSelectionListener.class) continue;
            ((DataRangeSelectionListener)listeners[i + 1]).dataRangeSelected(event);
        }
    }
}

