/*
 * Decompiled with CFR 0.152.
 */
package org.das2.graph;

import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.geom.GeneralPath;
import org.das2.DasException;
import org.das2.dataset.DataSetDescriptor;
import org.das2.datum.Units;
import org.das2.graph.DasAxis;
import org.das2.graph.GraphUtil;
import org.das2.graph.Psym;
import org.das2.graph.PsymConnector;
import org.das2.graph.Renderer;
import org.das2.graph.SymColor;
import org.das2.util.monitor.ProgressMonitor;
import org.virbo.dataset.DataSetOps;
import org.virbo.dataset.QDataSet;
import org.virbo.dataset.SemanticOps;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class CurveRenderer
extends Renderer {
    private String xplane;
    private String yplane;
    private boolean antiAliased = true;
    private SymColor color = SymColor.black;
    private PsymConnector psymConnector = PsymConnector.SOLID;
    private Psym psym = Psym.NONE;
    private double symSize = 1.0;
    private float lineWidth = 1.5f;
    private GeneralPath path;

    public CurveRenderer(DataSetDescriptor dsd, String xplane, String yplane) {
        super(dsd);
        this.setLineWidth(1.0);
        this.xplane = xplane;
        this.yplane = yplane;
    }

    public void render(Graphics g1, DasAxis xAxis, DasAxis yAxis, ProgressMonitor mon) {
        double ymin;
        double ymax;
        double xmin;
        double xmax;
        long timer0 = System.currentTimeMillis();
        QDataSet dataSet = this.getDataSet();
        if (dataSet == null || dataSet.length() == 0) {
            return;
        }
        QDataSet xds = DataSetOps.unbundle((QDataSet)dataSet, (String)this.xplane);
        QDataSet yds = DataSetOps.unbundle((QDataSet)dataSet, (String)this.yplane);
        QDataSet wds = SemanticOps.weightsDataSet((QDataSet)xds);
        Graphics2D graphics = (Graphics2D)g1.create();
        RenderingHints hints0 = graphics.getRenderingHints();
        if (this.antiAliased) {
            graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        } else {
            graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
        }
        graphics.setColor(this.color.toColor());
        if (this.path != null) {
            this.psymConnector.draw(graphics, this.path, this.lineWidth);
        }
        Units xUnits = xAxis.getUnits();
        Units yUnits = yAxis.getUnits();
        Rectangle r = g1.getClipBounds();
        if (r == null) {
            xmax = xAxis.getDataMaximum().doubleValue(xUnits);
            xmin = xAxis.getDataMinimum().doubleValue(xUnits);
            ymax = yAxis.getDataMaximum().doubleValue(yUnits);
            ymin = yAxis.getDataMinimum().doubleValue(yUnits);
        } else {
            xmin = xAxis.invTransform((int)r.getX()).doubleValue(xUnits);
            xmax = xAxis.invTransform((int)(r.getX() + r.getWidth())).doubleValue(xUnits);
            ymin = yAxis.invTransform((int)r.getY()).doubleValue(yUnits);
            ymax = yAxis.invTransform((int)(r.getY() + r.getHeight())).doubleValue(yUnits);
        }
        for (int index = 0; index < xds.length(); ++index) {
            if (!(wds.value() > 0.0)) continue;
            double i = xAxis.transform(xds.value(index), xUnits);
            double j = yAxis.transform(yds.value(index), yUnits);
            this.psym.draw(g1, i, j, (float)this.symSize);
        }
        graphics.setRenderingHints(hints0);
    }

    public void updatePlotImage(DasAxis xAxis, DasAxis yAxis, ProgressMonitor monitor) throws DasException {
        super.updatePlotImage(xAxis, yAxis, monitor);
        QDataSet dataSet = this.getDataSet();
        if (dataSet == null || dataSet.length() == 0) {
            return;
        }
        QDataSet xds = DataSetOps.unbundle((QDataSet)dataSet, (String)this.xplane);
        QDataSet yds = DataSetOps.unbundle((QDataSet)dataSet, (String)this.yplane);
        this.path = GraphUtil.getPath(xAxis, yAxis, xds, yds, false, false);
    }

    public double getLineWidth() {
        return this.lineWidth;
    }

    public void setLineWidth(double lineWidth) {
        this.lineWidth = (float)lineWidth;
        this.refreshImage();
    }

    protected Element getDOMElement(Document document) {
        throw new UnsupportedOperationException();
    }

    public PsymConnector getPsymConnector() {
        return this.psymConnector;
    }

    public void setPsymConnector(PsymConnector p) {
        this.psymConnector = p;
        this.refreshImage();
    }

    public Psym getPsym() {
        return this.psym;
    }

    public void setPsym(Psym psym) {
        if (psym == null) {
            throw new NullPointerException("psym cannot be null");
        }
        Psym oldValue = this.psym;
        this.psym = psym;
        this.refreshImage();
    }
}

