/*
 * Decompiled with CFR 0.152.
 */
package org.das2.graph;

import java.text.ParseException;
import org.das2.graph.DasCanvas;
import org.das2.graph.DasDevicePosition;

public class DasColumn
extends DasDevicePosition {
    public static final DasColumn NULL = new DasColumn(null, null, 0.0, 0.0, 0.0, 0.0, 0, 0);

    public DasColumn(DasCanvas parent, double left, double right) {
        super(parent, left, right, true);
    }

    public DasColumn(DasCanvas canvas, DasColumn parent, double nMin, double nMax, double emMin, double emMax, int ptMin, int ptMax) {
        super(canvas, true, parent, nMin, nMax, emMin, emMax, ptMin, ptMax);
    }

    public static DasColumn create(DasCanvas canvas, DasColumn parent, String minStr, String maxStr) {
        double[] max;
        double[] min;
        try {
            min = DasColumn.parseFormatStr(minStr);
        }
        catch (ParseException e) {
            throw new IllegalArgumentException("unable to parse min: \"" + minStr + "\"");
        }
        try {
            max = DasColumn.parseFormatStr(maxStr);
        }
        catch (ParseException e) {
            throw new IllegalArgumentException("unable to parse max: \"" + maxStr + "\"");
        }
        return new DasColumn(canvas, parent, min[0], max[0], min[1], max[1], (int)min[2], (int)max[2]);
    }

    public DasColumn createSubColumn(double pleft, double pright) {
        double left = this.getMinimum();
        double right = this.getMaximum();
        double delta = right - left;
        return new DasColumn(this.getCanvas(), left + pleft * delta, left + pright * delta);
    }

    public int getWidth() {
        return this.getDMaximum() - this.getDMinimum();
    }

    public static DasColumn create(DasCanvas parent) {
        return new DasColumn(parent, null, 0.0, 1.0, 5.0, -3.0, 0, 0);
    }

    public static DasColumn create(DasCanvas parent, int iplot, int nplot) {
        double min = 0.1 + (double)iplot * 0.7 / (double)nplot;
        double max = 0.099 + (double)(iplot + 1) * 0.7 / (double)nplot;
        return new DasColumn(parent, min, max);
    }

    public DasColumn createAttachedColumn(double pleft, double pright) {
        return new DasColumn(null, this, pleft, pright, 0.0, 0.0, 0, 0);
    }

    public int left() {
        return this.getDMinimum();
    }

    public int right() {
        return this.getDMaximum();
    }
}

