/*
 * Decompiled with CFR 0.152.
 */
package org.das2.graph;

import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.GeneralPath;
import java.util.IllegalFormatConversionException;
import org.das2.DasException;
import org.das2.datum.Datum;
import org.das2.datum.DatumRange;
import org.das2.datum.Units;
import org.das2.datum.format.DatumFormatter;
import org.das2.datum.format.DefaultDatumFormatter;
import org.das2.graph.DasAxis;
import org.das2.graph.Renderer;
import org.das2.util.GrannyTextRenderer;
import org.das2.util.monitor.ProgressMonitor;
import org.virbo.dataset.DDataSet;
import org.virbo.dataset.DataSetOps;
import org.virbo.dataset.DataSetUtil;
import org.virbo.dataset.JoinDataSet;
import org.virbo.dataset.QDataSet;
import org.virbo.dataset.SemanticOps;
import org.virbo.dsops.Ops;

public class DigitalRenderer
extends Renderer {
    protected Color color = Color.BLACK;
    public static final String PROP_COLOR = "color";
    protected Align align = Align.CENTER;
    public static final String PROP_ALIGN = "align";
    public static final String PROP_FORMAT = "format";
    private String format = "";
    public static final String PROP_SIZE = "size";
    double size = 0.0;
    Shape selectionArea;
    protected int dataSetSizeLimit = 10000;
    public static final String PROP_DATASETSIZELIMIT = "dataSetSizeLimit";
    private int firstIndex = -1;
    private int lastIndex = -1;
    private boolean dataSetClipped = false;

    public static QDataSet doAutorange(QDataSet ds) {
        QDataSet xds = SemanticOps.xtagsDataSet((QDataSet)ds);
        QDataSet yds = SemanticOps.ytagsDataSet((QDataSet)ds);
        QDataSet xrange = DigitalRenderer.doRange(xds);
        QDataSet yrange = DigitalRenderer.doRange(yds);
        JoinDataSet bds = new JoinDataSet(2);
        bds.join(xrange);
        bds.join(yrange);
        return bds;
    }

    private static QDataSet doRange(QDataSet xds) {
        QDataSet xrange = Ops.extent((QDataSet)xds);
        if (xrange.value(1) == xrange.value(0)) {
            xrange = !"log".equals(xrange.property("SCALE_TYPE")) ? DDataSet.wrap((double[])new double[]{xrange.value(0) - 1.0, xrange.value(1) + 1.0}).setUnits(SemanticOps.getUnits((QDataSet)xrange)) : DDataSet.wrap((double[])new double[]{xrange.value(0) / 10.0, xrange.value(1) * 10.0}).setUnits(SemanticOps.getUnits((QDataSet)xrange));
        }
        xrange = Ops.rescaleRange((QDataSet)xrange, (double)-0.1, (double)1.1);
        xrange = Ops.rescaleRange((QDataSet)xrange, (double)-0.1, (double)1.1);
        return xrange;
    }

    public Color getColor() {
        return this.color;
    }

    public void setColor(Color color) {
        Color oldColor = this.color;
        this.color = color;
        this.refresh();
        this.propertyChangeSupport.firePropertyChange(PROP_COLOR, oldColor, color);
    }

    public Align getAlign() {
        return this.align;
    }

    public void setAlign(Align align) {
        Align oldAlign = this.align;
        this.align = align;
        this.refresh();
        this.propertyChangeSupport.firePropertyChange(PROP_ALIGN, (Object)oldAlign, (Object)align);
    }

    public String getFormat() {
        return this.format;
    }

    public void setFormat(String value) {
        String oldValue = this.format;
        this.format = value;
        this.refresh();
        this.propertyChangeSupport.firePropertyChange(PROP_FORMAT, oldValue, value);
    }

    public double getSize() {
        return this.size;
    }

    public void setSize(double size) {
        double oldValue = this.size;
        this.size = size;
        this.refresh();
        this.propertyChangeSupport.firePropertyChange(PROP_FORMAT, oldValue, size);
    }

    public Shape selectionArea() {
        return this.selectionArea;
    }

    public int getDataSetSizeLimit() {
        return this.dataSetSizeLimit;
    }

    public void setDataSetSizeLimit(int dataSetSizeLimit) {
        int oldDataSetSizeLimit = this.dataSetSizeLimit;
        this.dataSetSizeLimit = dataSetSizeLimit;
        this.propertyChangeSupport.firePropertyChange(PROP_DATASETSIZELIMIT, oldDataSetSizeLimit, dataSetSizeLimit);
    }

    private synchronized void updateFirstLast(DasAxis xAxis, DasAxis yAxis, QDataSet dataSet) {
        int index;
        int ixmax;
        int ixmin;
        QDataSet wds;
        Units xUnits = xAxis.getUnits();
        if (dataSet == null) {
            return;
        }
        if (dataSet.rank() == 0) {
            wds = SemanticOps.weightsDataSet((QDataSet)dataSet);
        } else if (dataSet.rank() == 1) {
            wds = SemanticOps.weightsDataSet((QDataSet)dataSet);
        } else if (SemanticOps.isSimpleTableDataSet((QDataSet)dataSet)) {
            wds = SemanticOps.weightsDataSet((QDataSet)DataSetOps.slice1((QDataSet)dataSet, (int)0));
        } else {
            this.firstIndex = 0;
            this.lastIndex = Math.min(dataSet.length(), this.dataSetSizeLimit);
            return;
        }
        QDataSet xds = SemanticOps.xtagsDataSet((QDataSet)dataSet);
        Boolean xMono = SemanticOps.isMonotonic((QDataSet)xds);
        if (SemanticOps.isBins((QDataSet)dataSet)) {
            ixmin = 0;
            ixmax = dataSet.length();
        } else if (xMono != null && xMono.booleanValue()) {
            Rectangle plotBounds;
            DatumRange visibleRange = xAxis.getDatumRange();
            if (this.parent.isOverSize() && (plotBounds = this.parent.getUpdateImageBounds()) != null) {
                visibleRange = new DatumRange(xAxis.invTransform(plotBounds.x), xAxis.invTransform(plotBounds.x + plotBounds.width));
            }
            ixmin = DataSetUtil.getPreviousIndex((QDataSet)xds, (Datum)visibleRange.min());
            ixmax = DataSetUtil.getNextIndex((QDataSet)xds, (Datum)visibleRange.max()) + 1;
        } else {
            ixmin = 0;
            ixmax = dataSet.length();
        }
        double x = Double.NaN;
        for (index = ixmin; index < ixmax; ++index) {
            boolean isValid;
            x = xds.value(index);
            boolean bl = isValid = wds.value(index) > 0.0 && xUnits.isValid(x);
            if (!isValid) continue;
            this.firstIndex = index++;
            break;
        }
        if (this.firstIndex == -1) {
            this.lastIndex = ixmax;
            this.firstIndex = ixmax;
        }
        int pointsPlotted = 0;
        for (index = this.firstIndex; index < ixmax && pointsPlotted < this.dataSetSizeLimit; ++index) {
            boolean isValid;
            boolean bl = isValid = wds.value(index) > 0.0 && xUnits.isValid(x);
            if (!isValid) continue;
            ++pointsPlotted;
        }
        this.dataSetClipped = index < ixmax && pointsPlotted == this.dataSetSizeLimit;
        this.lastIndex = index;
    }

    public void render(Graphics g, DasAxis xAxis, DasAxis yAxis, ProgressMonitor mon) {
        g.setColor(this.color);
        if (this.ds == null) {
            if (this.getLastException() != null) {
                this.renderException(g, xAxis, yAxis, this.lastException);
            } else {
                this.parent.postMessage(this, "no data set", 0, null, null);
            }
            return;
        }
        if (this.ds.rank() == 0 || this.ds.rank() == 1 && SemanticOps.isRank1Bundle((QDataSet)this.ds)) {
            this.renderRank0(this.ds, g, xAxis, yAxis, mon);
        } else if (SemanticOps.isBins((QDataSet)this.ds)) {
            this.renderRank0(this.ds, g, xAxis, yAxis, mon);
        } else if (!SemanticOps.isTableDataSet((QDataSet)this.ds)) {
            this.renderRank1(this.ds, g, xAxis, yAxis, mon);
        } else {
            this.renderRank2(this.ds, g, xAxis, yAxis, mon);
        }
    }

    private void renderRank0(QDataSet ds, Graphics g, DasAxis xAxis, DasAxis yAxis, ProgressMonitor mon) {
        StringBuilder sb = new StringBuilder();
        if (ds.rank() == 0) {
            String label = (String)ds.property("LABEL");
            if (label == null) {
                label = (String)ds.property("NAME");
            }
            if (label != null) {
                sb.append(label).append("=");
            }
            sb.append(DataSetUtil.asDatum((QDataSet)ds).toString());
        } else if (SemanticOps.isBins((QDataSet)ds)) {
            String label = (String)ds.property("LABEL");
            if (label == null) {
                label = (String)ds.property("NAME");
            }
            if (label != null) {
                sb.append(label).append("=");
            }
            sb.append(DataSetUtil.toString((QDataSet)ds));
        } else {
            for (int i = 0; i < Math.min(4, ds.length()); ++i) {
                QDataSet ds1;
                String label;
                if (i > 0) {
                    sb.append(", ");
                }
                if ((label = (String)(ds1 = DataSetOps.unbundle((QDataSet)ds, (int)i)).property("LABEL")) == null) {
                    label = (String)ds1.property("NAME");
                }
                if (label != null) {
                    sb.append(label).append("=");
                }
                sb.append(DataSetUtil.asDatum((QDataSet)ds1).toString());
            }
        }
        this.parent.postMessage(this, sb.toString(), 0, null, null);
    }

    private void renderRank1(QDataSet ds, Graphics g, DasAxis xAxis, DasAxis yAxis, ProgressMonitor mon) {
        Font f0;
        Font f = f0 = g.getFont();
        if (this.size > 0.0) {
            f = f0.deriveFont((float)this.size);
        }
        g.setFont(f);
        FontMetrics fm = g.getFontMetrics();
        int ha = 0;
        if (this.align == Align.NE || this.align == Align.NW) {
            ha = fm.getAscent();
        }
        if (this.align == Align.CENTER) {
            ha = fm.getAscent() / 2;
        }
        float wa = 0.0f;
        if (this.align == Align.NE || this.align == Align.SE) {
            wa = 1.0f;
        }
        if (this.align == Align.CENTER) {
            wa = 0.5f;
        }
        GeneralPath shape = new GeneralPath();
        GrannyTextRenderer gtr = new GrannyTextRenderer();
        Units u = SemanticOps.getUnits((QDataSet)ds);
        QDataSet xds = SemanticOps.xtagsDataSet((QDataSet)ds);
        QDataSet yds = SemanticOps.ytagsDataSet((QDataSet)ds);
        Units xunits = SemanticOps.getUnits((QDataSet)xds);
        String form = this.format;
        String dsformat = (String)ds.property("FORMAT");
        if (form.length() == 0 && dsformat != null) {
            form = dsformat;
        }
        if (form.length() == 0) {
            form = "%.2f";
        }
        boolean count = false;
        if (!xunits.isConvertableTo(xAxis.getUnits())) {
            this.parent.postMessage(this, "inconvertible xaxis units", 0, null, null);
            return;
        }
        if (!u.isConvertableTo(yAxis.getUnits())) {
            this.parent.postMessage(this, "inconvertible yaxis units", 0, null, null);
            return;
        }
        QDataSet wds = SemanticOps.weightsDataSet((QDataSet)yds);
        for (int i = this.firstIndex; i < this.lastIndex; ++i) {
            int iy;
            String s;
            int ix = (int)xAxis.transform(xds.value(i), xunits);
            if (wds.value(i) > 0.0) {
                Datum d = u.createDatum(yds.value(i));
                DatumFormatter df = d.getFormatter();
                if (df instanceof DefaultDatumFormatter) {
                    try {
                        s = String.format(form, yds.value(i));
                    }
                    catch (IllegalFormatConversionException ex) {
                        char c = ex.getConversion();
                        if (c == 'X' || c == 'x' || c == 'd' || c == 'o' || c == 'c' || c == 'C') {
                            s = String.format(form, (long)yds.value(i));
                        }
                        throw ex;
                    }
                } else {
                    s = d.getFormatter().format(d, u);
                }
                iy = (int)yAxis.transform(d) + ha;
            } else {
                s = "fill";
                iy = yAxis.getRow().getDMaximum();
            }
            if ((double)wa > 0.0) {
                ix -= (int)((float)fm.stringWidth(s) * wa);
            }
            gtr.setString(g, s);
            gtr.draw(g, (float)ix, (float)iy);
            Rectangle r = gtr.getBounds();
            r.translate(ix, iy);
            shape.append(r, false);
            if (!this.dataSetClipped) continue;
            if (this.getParent() != null) {
                this.getParent().postMessage(this, "" + this.dataSetSizeLimit + " data point limit reached", 1, null, null);
            }
            return;
        }
        this.selectionArea = shape;
        g.setFont(f0);
    }

    private void renderRank2(QDataSet ds, Graphics g, DasAxis xAxis, DasAxis yAxis, ProgressMonitor mon) {
        QDataSet zds;
        Font f0;
        Font f = f0 = g.getFont();
        if (this.size > 0.0) {
            f = f0.deriveFont((float)this.size);
        }
        g.setFont(f);
        FontMetrics fm = g.getFontMetrics();
        int ha = 0;
        if (this.align == Align.NE || this.align == Align.NW) {
            ha = fm.getAscent();
        }
        if (this.align == Align.CENTER) {
            ha = fm.getAscent() / 2;
        }
        float wa = 0.0f;
        if (this.align == Align.NE || this.align == Align.SE) {
            wa = 1.0f;
        }
        if (this.align == Align.CENTER) {
            wa = 0.5f;
        }
        GeneralPath shape = new GeneralPath();
        GrannyTextRenderer gtr = new GrannyTextRenderer();
        QDataSet xds = SemanticOps.xtagsDataSet((QDataSet)ds);
        QDataSet yds = SemanticOps.ytagsDataSet((QDataSet)ds);
        QDataSet fds = DataSetOps.flattenRank2((QDataSet)ds);
        Units u = SemanticOps.getUnits((QDataSet)ds);
        if (fds.length(0) > 1) {
            xds = DataSetOps.unbundle((QDataSet)fds, (int)0);
            yds = DataSetOps.unbundle((QDataSet)fds, (int)1);
            zds = DataSetOps.unbundle((QDataSet)fds, (int)(fds.length(0) - 1));
        } else {
            xds = Ops.div((QDataSet)Ops.dindgen((int)fds.length()), (QDataSet)DataSetUtil.asDataSet((double)ds.length(0)));
            yds = Ops.mod((QDataSet)Ops.dindgen((int)fds.length()), (QDataSet)DataSetUtil.asDataSet((double)ds.length(0)));
            zds = fds;
        }
        String form = this.format;
        String dsformat = (String)ds.property("FORMAT");
        if (form.length() == 0 && dsformat != null) {
            form = dsformat;
        }
        if (form.length() == 0) {
            form = "%.2f";
        }
        Units xunits = SemanticOps.getUnits((QDataSet)xds);
        Units yunits = SemanticOps.getUnits((QDataSet)yds);
        if (!SemanticOps.getUnits((QDataSet)xds).isConvertableTo(xAxis.getUnits())) {
            this.parent.postMessage(this, "inconvertible xaxis units", 0, null, null);
            return;
        }
        if (!SemanticOps.getUnits((QDataSet)yds).isConvertableTo(yAxis.getUnits())) {
            this.parent.postMessage(this, "inconvertible yaxis units", 0, null, null);
            return;
        }
        int n = fds.length();
        QDataSet wds = SemanticOps.weightsDataSet((QDataSet)zds);
        int count = 0;
        for (int i = 0; i < n; ++i) {
            String s;
            int ix = (int)xAxis.transform(xds.value(i), xunits);
            int iy = (int)yAxis.transform(yds.value(i), yunits) + ha;
            if (wds.value(i) > 0.0) {
                Datum d = u.createDatum(zds.value(i));
                DatumFormatter df = d.getFormatter();
                s = df instanceof DefaultDatumFormatter ? String.format(form, zds.value(i)) : d.getFormatter().format(d, u);
                if ((double)wa > 0.0) {
                    ix -= (int)((float)fm.stringWidth(s) * wa);
                }
            } else {
                s = "fill";
            }
            gtr.setString(g, s);
            gtr.draw(g, (float)ix, (float)iy);
            Rectangle r = gtr.getBounds();
            r.translate(ix, iy);
            shape.append(r, false);
            if (count++ <= 10000) continue;
            if (this.getParent() != null) {
                this.getParent().postMessage(this, "10000 data point limit reached", 1, null, null);
            }
            return;
        }
        this.selectionArea = shape;
        g.setFont(f0);
    }

    public boolean acceptContext(int x, int y) {
        if (this.selectionArea != null) {
            return this.selectionArea.contains(x, y);
        }
        return true;
    }

    public void updatePlotImage(DasAxis xAxis, DasAxis yAxis, ProgressMonitor monitor) throws DasException {
        QDataSet ds = this.getDataSet();
        if (ds == null) {
            return;
        }
        if (!(ds.rank() == 0 || this.getDataSet().rank() == 1 && SemanticOps.isRank1Bundle((QDataSet)ds))) {
            this.updateFirstLast(xAxis, yAxis, ds);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Align {
        SW,
        NW,
        NE,
        SE,
        CENTER;

    }
}

