/*
 * Decompiled with CFR 0.152.
 */
package org.das2.graph;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.GeneralPath;
import org.das2.datum.Datum;
import org.das2.datum.DatumRange;
import org.das2.datum.DatumUtil;
import org.das2.datum.Units;
import org.das2.event.LabelDragRenderer;
import org.das2.event.MouseModule;
import org.das2.graph.DasAxis;
import org.das2.graph.DasColumn;
import org.das2.graph.DasPlot;
import org.das2.graph.DasRow;
import org.das2.graph.Renderer;
import org.das2.system.DasLogger;
import org.das2.util.monitor.ProgressMonitor;
import org.virbo.dataset.DDataSet;
import org.virbo.dataset.DataSetOps;
import org.virbo.dataset.JoinDataSet;
import org.virbo.dataset.QDataSet;
import org.virbo.dataset.SemanticOps;
import org.virbo.dataset.WritableDataSet;
import org.virbo.dsops.Ops;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class EventsRenderer
extends Renderer {
    public static final String PROP_COLOR = "color";
    int[] eventMap;
    private ColorSpecifier colorSpecifier = null;
    private Shape selectionArea;
    public static final TextSpecifier DEFAULT_TEXT_SPECIFIER = new TextSpecifier(){

        public String getText(DatumRange dr, Datum d) {
            Datum sy = DatumUtil.asOrderOneUnits((Datum)dr.width());
            if (sy.doubleValue(Units.seconds) == 0.0) {
                return "" + dr.min() + "!c" + d;
            }
            return "" + dr + " (" + sy + ")!c" + d;
        }
    };
    private Color color = new Color(100, 100, 100, 180);
    private TextSpecifier textSpecifier = DEFAULT_TEXT_SPECIFIER;

    public static QDataSet doAutorange(QDataSet ds) {
        DDataSet yrange = DDataSet.createRank1((int)2);
        yrange.putValue(0, 0.0);
        yrange.putValue(1, 10.0);
        QDataSet xmins = SemanticOps.xtagsDataSet((QDataSet)ds);
        QDataSet xmaxs = DataSetOps.unbundle((QDataSet)ds, (int)1);
        Units u0 = SemanticOps.getUnits((QDataSet)xmins);
        Units u1 = SemanticOps.getUnits((QDataSet)xmaxs);
        if (!u1.isConvertableTo(u0) && u1.isConvertableTo(u0.getOffsetUnits())) {
            xmaxs = Ops.add((QDataSet)xmins, (QDataSet)xmaxs);
        }
        QDataSet xrange = Ops.extent((QDataSet)xmins);
        xrange = Ops.extent((QDataSet)xmaxs, (QDataSet)xrange);
        xrange = Ops.rescaleRange((QDataSet)xrange, (double)-0.1, (double)1.1);
        JoinDataSet bds = new JoinDataSet(2);
        bds.join(xrange);
        bds.join((QDataSet)yrange);
        return bds;
    }

    Shape selectionArea() {
        return this.selectionArea;
    }

    public boolean acceptContext(int x, int y) {
        if (this.selectionArea != null) {
            return this.selectionArea.contains(x, y);
        }
        return true;
    }

    public void setColorSpecifier(ColorSpecifier spec) {
        this.colorSpecifier = spec;
    }

    public ColorSpecifier getColorSpecifier() {
        return this.colorSpecifier;
    }

    protected Element getDOMElement(Document document) {
        return null;
    }

    protected void installRenderer() {
        MouseModule mm = this.getMouseModule();
        this.parent.getDasMouseInputAdapter().addMouseModule(mm);
        this.parent.getDasMouseInputAdapter().setPrimaryModule(mm);
    }

    private MouseModule getMouseModule() {
        return new MouseModule(this.parent, new DragRenderer(this.parent), "event lookup");
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    private QDataSet makeCanonical(QDataSet vds) {
        void var4_11;
        QDataSet msgs;
        QDataSet xmaxs;
        QDataSet xmins;
        if (vds.rank() == 2) {
            xmins = DataSetOps.unbundle((QDataSet)vds, (int)0);
            xmaxs = DataSetOps.unbundle((QDataSet)vds, (int)1);
            Units u0 = SemanticOps.getUnits((QDataSet)xmins);
            Units u1 = SemanticOps.getUnits((QDataSet)xmaxs);
            if (!u1.isConvertableTo(u0) && u1.isConvertableTo(u0.getOffsetUnits())) {
                xmaxs = Ops.add((QDataSet)xmins, (QDataSet)xmaxs);
            }
            if (vds.length(0) > 3) {
                QDataSet qDataSet = DataSetOps.unbundle((QDataSet)vds, (int)2);
            } else {
                WritableDataSet writableDataSet = Ops.replicate((long)0x808080L, (int)xmins.length());
            }
            msgs = DataSetOps.unbundle((QDataSet)vds, (int)(vds.length(0) - 1));
            return Ops.bundle((QDataSet)Ops.bundle((QDataSet)Ops.bundle((QDataSet)xmins, (QDataSet)xmaxs), (QDataSet)var4_11), (QDataSet)msgs);
        } else {
            if (vds.rank() != 1) {
                this.parent.postMessage(this, "dataset must be rank 1 or rank 2", 1, null, null);
                return null;
            }
            QDataSet dep0 = (QDataSet)vds.property("DEPEND_0");
            if (dep0 == null) {
                xmins = vds;
                xmaxs = vds;
                msgs = vds;
            } else if (dep0.rank() == 2) {
                if (!SemanticOps.isBins((QDataSet)dep0)) {
                    this.parent.postMessage(this, "DEPEND_0 is rank 2 but not bins", 1, null, null);
                    return null;
                }
                xmins = DataSetOps.slice1((QDataSet)dep0, (int)0);
                xmaxs = DataSetOps.slice1((QDataSet)dep0, (int)1);
                Units u0 = SemanticOps.getUnits((QDataSet)xmins);
                Units u1 = SemanticOps.getUnits((QDataSet)xmaxs);
                if (!u1.isConvertableTo(u0) && u1.isConvertableTo(u0.getOffsetUnits())) {
                    xmaxs = Ops.add((QDataSet)xmins, (QDataSet)xmaxs);
                }
                msgs = vds;
            } else {
                if (dep0.rank() != 1) {
                    this.parent.postMessage(this, "dataset is not correct form", 1, null, null);
                    return null;
                }
                xmaxs = xmins = dep0;
                msgs = vds;
            }
            Color c0 = this.getColor();
            Color c1 = new Color(c0.getRed(), c0.getGreen(), c0.getBlue(), 128);
            int irgb = c1.getRGB();
            WritableDataSet writableDataSet = Ops.replicate((long)irgb, (int)xmins.length());
        }
        return Ops.bundle((QDataSet)Ops.bundle((QDataSet)Ops.bundle((QDataSet)xmins, (QDataSet)xmaxs), (QDataSet)var4_11), (QDataSet)msgs);
    }

    public void render(Graphics g1, DasAxis xAxis, DasAxis yAxis, ProgressMonitor mon) {
        QDataSet color;
        GeneralPath sa = new GeneralPath();
        QDataSet vds = this.getDataSet();
        if (vds == null || vds.length() == 0) {
            DasLogger.getLogger(DasLogger.GRAPHICS_LOG).fine("null data set");
            return;
        }
        Graphics2D g = (Graphics2D)g1.create();
        g.setColor(this.color);
        QDataSet ds = this.makeCanonical(vds);
        if (ds == null) {
            return;
        }
        QDataSet xmins = DataSetOps.unbundle((QDataSet)ds, (int)0);
        QDataSet xmaxs = DataSetOps.unbundle((QDataSet)ds, (int)1);
        QDataSet qDataSet = color = ds.length(0) > 3 ? DataSetOps.unbundle((QDataSet)ds, (int)2) : null;
        if (this.lastException != null) {
            this.renderException(g, xAxis, yAxis, this.lastException);
        } else {
            DasColumn column = xAxis.getColumn();
            DasRow row = this.parent.getRow();
            this.eventMap = new int[column.getWidth()];
            for (int k = 0; k < this.eventMap.length; ++k) {
                this.eventMap[k] = -1;
            }
            QDataSet xds = xmins;
            Units xunits = SemanticOps.getUnits((QDataSet)xds);
            if (vds.length() > 0) {
                int ivds0 = 0;
                int ivds1 = xmins.length();
                for (int i = ivds0; i < ivds1; ++i) {
                    int ixmin = (int)xAxis.transform(xmins.value(i), xunits);
                    int ixmax = (int)xAxis.transform(xmaxs.value(i), xunits);
                    int iwidth = Math.max(ixmax - ixmin, 1);
                    if (color != null) {
                        int irgb = (int)color.value(i);
                        int rr = (irgb & 0xFF0000) >> 16;
                        int gg = (irgb & 0xFF00) >> 8;
                        int bb = (irgb & 0xFF) >> 0;
                        int aa = 128;
                        g.setColor(new Color(rr, gg, bb, aa));
                    }
                    if (column.getDMinimum() >= ixmax && column.getDMaximum() <= ixmin) continue;
                    if (iwidth == 0) {
                        iwidth = 1;
                    }
                    sa.append(new Rectangle(ixmin - 2, row.getDMinimum(), iwidth + 4, row.getHeight()), false);
                    g.fill(new Rectangle(ixmin, row.getDMinimum(), iwidth, row.getHeight()));
                    int im = ixmin - column.getDMinimum();
                    int em0 = im - 1;
                    int em1 = im + iwidth + 1;
                    for (int k = em0; k < em1; ++k) {
                        if (k < 0 || k >= this.eventMap.length) continue;
                        this.eventMap[k] = i;
                    }
                }
                for (int k1 = 1; k1 <= 2; ++k1) {
                    for (int k2 = -1; k2 <= 1; k2 += 2) {
                        int em0 = k2 == 1 ? 0 : this.eventMap.length - 1;
                        int em1 = k2 == 1 ? this.eventMap.length - k1 : k1;
                        for (int k = em0; k != em1; k += k2) {
                            if (this.eventMap[k] != -1) continue;
                            this.eventMap[k] = this.eventMap[k + k2];
                        }
                    }
                }
            }
        }
        g.dispose();
        this.selectionArea = sa;
    }

    protected void uninstallRenderer() {
    }

    public Color getColor() {
        return this.color;
    }

    public void setColor(Color color) {
        Color old = this.color;
        this.color = new Color(color.getRed(), color.getGreen(), color.getBlue(), 180);
        this.propertyChangeSupport.firePropertyChange(PROP_COLOR, old, color);
        super.invalidateParentCacheImage();
    }

    public TextSpecifier getTextSpecifier() {
        return this.textSpecifier;
    }

    public void setTextSpecifier(TextSpecifier textSpecifier) {
        TextSpecifier oldTextSpecifier = this.textSpecifier;
        this.textSpecifier = textSpecifier;
        this.propertyChangeSupport.firePropertyChange("textSpecifier", oldTextSpecifier, textSpecifier);
    }

    private class DragRenderer
    extends LabelDragRenderer {
        DasPlot parent;

        DragRenderer(DasPlot parent) {
            super(parent);
            this.parent = parent;
            this.setTooltip(true);
        }

        public Rectangle[] renderDrag(Graphics g, Point p1, Point p2) {
            QDataSet vds = EventsRenderer.this.getDataSet();
            if (vds == null) {
                return new Rectangle[0];
            }
            if (vds.length() == 0) {
                return new Rectangle[0];
            }
            QDataSet ds = EventsRenderer.this.makeCanonical(vds);
            QDataSet xmins = DataSetOps.unbundle((QDataSet)ds, (int)0);
            QDataSet xmaxs = DataSetOps.unbundle((QDataSet)ds, (int)1);
            QDataSet msgs = DataSetOps.unbundle((QDataSet)ds, (int)(ds.length(0) - 1));
            int ix = (int)p2.getX() - this.parent.getColumn().getDMinimum();
            if (ix < 0 || ix >= EventsRenderer.this.eventMap.length) {
                this.setLabel(null);
            } else {
                int i = EventsRenderer.this.eventMap[ix];
                if (i >= 0) {
                    double sxmin = xmins.value(i);
                    double sxmax = xmaxs.value(i);
                    Units sxunits = SemanticOps.getUnits((QDataSet)xmins);
                    Units zunits = SemanticOps.getUnits((QDataSet)msgs);
                    Units sxmaxunits = SemanticOps.getUnits((QDataSet)xmaxs);
                    sxmax = !sxmaxunits.isConvertableTo(sxunits) ? (sxmaxunits.isConvertableTo(sxunits.getOffsetUnits()) ? sxmin + sxmaxunits.convertDoubleTo(sxunits.getOffsetUnits(), sxmax) : sxmin) : sxmaxunits.convertDoubleTo(sxunits, sxmax);
                    Datum sz = zunits.createDatum(msgs.value(i));
                    DatumRange dr = new DatumRange(sxmin, sxmax, sxunits);
                    this.setLabel(EventsRenderer.this.textSpecifier.getText(dr, sz));
                } else {
                    this.setLabel(null);
                }
            }
            return super.renderDrag(g, p1, p2);
        }
    }

    public static interface TextSpecifier {
        public String getText(DatumRange var1, Datum var2);
    }

    public static interface ColorSpecifier {
        public Color getColor(Datum var1);
    }
}

