/*
 * Decompiled with CFR 0.152.
 */
package org.das2.graph;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.text.DecimalFormat;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import org.das2.datum.Datum;
import org.das2.datum.DatumRange;
import org.das2.datum.Units;
import org.das2.datum.UnitsUtil;
import org.das2.graph.DasAxis;
import org.das2.graph.DasCanvas;
import org.das2.graph.DasColorBar;
import org.das2.graph.DasColumn;
import org.das2.graph.DasDevicePosition;
import org.das2.graph.DasPlot;
import org.das2.graph.DasRow;
import org.das2.graph.DefaultPlotSymbol;
import org.das2.graph.ImageVectorDataSetRenderer;
import org.das2.graph.Renderer;
import org.das2.graph.SeriesRenderer;
import org.das2.graph.SpectrogramRenderer;
import org.virbo.dataset.DataSetOps;
import org.virbo.dataset.DataSetUtil;
import org.virbo.dataset.QDataSet;
import org.virbo.dataset.RankZeroDataSet;
import org.virbo.dataset.SemanticOps;
import org.virbo.dsops.Ops;

public class GraphUtil {
    public static DasPlot newDasPlot(DasCanvas canvas, DatumRange x, DatumRange y) {
        DasAxis xaxis = new DasAxis(x.min(), x.max(), 2);
        DasAxis yaxis = new DasAxis(y.min(), y.max(), 3);
        DasRow row = new DasRow(canvas, null, 0.0, 1.0, 2.0, -3.0, 0, 0);
        DasColumn col = new DasColumn(canvas, null, 0.0, 1.0, 5.0, -3.0, 0, 0);
        DasPlot result = new DasPlot(xaxis, yaxis);
        canvas.add(result, row, col);
        return result;
    }

    public static GeneralPath getPath(DasAxis xAxis, DasAxis yAxis, QDataSet ds, boolean histogram, boolean clip) {
        return GraphUtil.getPath(xAxis, yAxis, SemanticOps.xtagsDataSet((QDataSet)ds), ds, histogram, clip);
    }

    public static GeneralPath getPath(DasAxis xAxis, DasAxis yAxis, QDataSet xds, QDataSet yds, boolean histogram, boolean clip) {
        GeneralPath newPath = new GeneralPath();
        Units xUnits = SemanticOps.getUnits((QDataSet)xds);
        Units yUnits = SemanticOps.getUnits((QDataSet)yds);
        QDataSet tagds = SemanticOps.xtagsDataSet((QDataSet)xds);
        double xSampleWidth = Double.MAX_VALUE;
        if (tagds.property("CADENCE") != null) {
            // empty if block
        }
        double i0 = -1.7976931348623157E308;
        double j0 = -1.7976931348623157E308;
        boolean v0 = false;
        boolean skippedLast = true;
        int n = xds.length();
        QDataSet wds = SemanticOps.weightsDataSet((QDataSet)yds);
        Rectangle rclip = clip ? DasDevicePosition.toRectangle(yAxis.getRow(), xAxis.getColumn()) : null;
        for (int index = 0; index < n; ++index) {
            boolean v;
            double t = index;
            double x = xds.value(index);
            double y = yds.value(index);
            double i = xAxis.transform(x, xUnits);
            double j = yAxis.transform(y, yUnits);
            boolean bl = v = rclip == null || rclip.contains(i, j);
            if (wds.value(index) == 0.0 || Double.isNaN(y)) {
                skippedLast = true;
            } else if (skippedLast) {
                newPath.moveTo((float)i, (float)j);
                skippedLast = !v;
            } else {
                if (v || v0) {
                    if (histogram) {
                        double i1 = (i0 + i) / 2.0;
                        newPath.lineTo((float)i1, (float)j0);
                        newPath.lineTo((float)i1, (float)j);
                        newPath.lineTo((float)i, (float)j);
                    } else {
                        newPath.lineTo((float)i, (float)j);
                    }
                }
                skippedLast = false;
            }
            i0 = i;
            j0 = j;
            v0 = v;
        }
        return newPath;
    }

    public static AffineTransform calculateAT(DasAxis xaxis0, DasAxis yaxis0, DasAxis xaxis1, DasAxis yaxis1) {
        return GraphUtil.calculateAT(xaxis0.getDatumRange(), yaxis0.getDatumRange(), xaxis1, yaxis1);
    }

    public static AffineTransform calculateAT(DatumRange xaxis0, DatumRange yaxis0, DasAxis xaxis1, DasAxis yaxis1) {
        AffineTransform at = new AffineTransform();
        double dmin0 = xaxis1.transform(xaxis0.min());
        double dmax0 = xaxis1.transform(xaxis0.max());
        double dmin1 = xaxis1.transform(xaxis1.getDataMinimum());
        double dmax1 = xaxis1.transform(xaxis1.getDataMaximum());
        double scalex = (dmin0 - dmax0) / (dmin1 - dmax1);
        double transx = -1.0 * dmin1 * scalex + dmin0;
        at.translate(transx, 0.0);
        at.scale(scalex, 1.0);
        if (at.getDeterminant() == 0.0) {
            return null;
        }
        dmin0 = yaxis1.transform(yaxis0.min());
        dmax0 = yaxis1.transform(yaxis0.max());
        dmin1 = yaxis1.transform(yaxis1.getDataMinimum());
        dmax1 = yaxis1.transform(yaxis1.getDataMaximum());
        double scaley = (dmin0 - dmax0) / (dmin1 - dmax1);
        double transy = -1.0 * dmin1 * scaley + dmin0;
        at.translate(0.0, transy);
        at.scale(1.0, scaley);
        return at;
    }

    public static DasAxis guessYAxis(QDataSet dsz) {
        DasAxis result;
        boolean log = false;
        if (dsz.property("SCALE_TYPE") != null && dsz.property("SCALE_TYPE").equals("log")) {
            log = true;
        }
        if (SemanticOps.isSimpleTableDataSet((QDataSet)dsz)) {
            QDataSet ds = dsz;
            QDataSet yds = SemanticOps.ytagsDataSet((QDataSet)ds);
            DatumRange yrange = DataSetUtil.asDatumRange((QDataSet)Ops.extent((QDataSet)yds), (boolean)true);
            Datum dy = DataSetUtil.asDatum((RankZeroDataSet)DataSetUtil.guessCadenceNew((QDataSet)yds, null));
            if (UnitsUtil.isRatiometric((Units)dy.getUnits())) {
                log = true;
            }
            result = new DasAxis(yrange.min(), yrange.max(), 3, log);
        } else if (!SemanticOps.isTableDataSet((QDataSet)dsz)) {
            QDataSet yds = dsz;
            if (SemanticOps.isBundle((QDataSet)dsz)) {
                dsz = yds = DataSetOps.unbundleDefaultDataSet((QDataSet)dsz);
            }
            DatumRange yrange = DataSetUtil.asDatumRange((QDataSet)Ops.extent((QDataSet)yds), (boolean)true);
            result = new DasAxis(yrange.min(), yrange.max(), 3, log);
        } else {
            throw new IllegalArgumentException("not supported: " + dsz);
        }
        if (dsz.property("LABEL") != null) {
            result.setLabel((String)dsz.property("LABEL"));
        }
        return result;
    }

    public static DasAxis guessXAxis(QDataSet ds) {
        QDataSet xds = SemanticOps.xtagsDataSet((QDataSet)ds);
        DatumRange range = DataSetUtil.asDatumRange((QDataSet)Ops.extent((QDataSet)xds), (boolean)true);
        return new DasAxis(range.min(), range.max(), 2);
    }

    public static DasAxis guessZAxis(QDataSet dsz) {
        if (!SemanticOps.isTableDataSet((QDataSet)dsz)) {
            throw new IllegalArgumentException("only TableDataSet supported");
        }
        QDataSet ds = dsz;
        DatumRange range = DataSetUtil.asDatumRange((QDataSet)Ops.extent((QDataSet)ds), (boolean)true);
        boolean log = false;
        if ("log".equals(dsz.property("SCALE_TYPE"))) {
            log = true;
            if (range.min().doubleValue(range.getUnits()) <= 0.0) {
                double max = range.max().doubleValue(range.getUnits());
                range = new DatumRange(max / 1000.0, max, range.getUnits());
            }
        }
        DasAxis result = new DasAxis(range.min(), range.max(), 3, log);
        if (dsz.property("LABEL") != null) {
            result.setLabel((String)dsz.property("LABEL"));
        }
        return result;
    }

    public static Renderer guessRenderer(QDataSet ds) {
        Renderer rend = null;
        if (!SemanticOps.isTableDataSet((QDataSet)ds)) {
            if (ds.length() > 10000) {
                rend = new ImageVectorDataSetRenderer(null);
                rend.setDataSet(ds);
            } else {
                rend = new SeriesRenderer();
                rend.setDataSet(ds);
                ((SeriesRenderer)rend).setPsym(DefaultPlotSymbol.CIRCLES);
                ((SeriesRenderer)rend).setSymSize(2.0);
            }
        } else if (SemanticOps.isTableDataSet((QDataSet)ds)) {
            DasAxis zaxis = GraphUtil.guessZAxis(ds);
            DasColorBar colorbar = new DasColorBar(zaxis.getDataMinimum(), zaxis.getDataMaximum(), zaxis.isLog());
            colorbar.setLabel(zaxis.getLabel());
            rend = new SpectrogramRenderer(null, colorbar);
            rend.setDataSet(ds);
        }
        return rend;
    }

    public static DasPlot guessPlot(QDataSet ds) {
        DasAxis xaxis = GraphUtil.guessXAxis(ds);
        DasAxis yaxis = GraphUtil.guessYAxis(ds);
        DasPlot plot = new DasPlot(xaxis, yaxis);
        plot.addRenderer(GraphUtil.guessRenderer(ds));
        return plot;
    }

    public static DasPlot visualize(QDataSet ds) {
        JFrame jframe = new JFrame("DataSetUtil.visualize");
        DasCanvas canvas = new DasCanvas(400, 400);
        jframe.getContentPane().add(canvas);
        DasPlot result = GraphUtil.guessPlot(ds);
        canvas.add(result, DasRow.create(canvas), DasColumn.create(canvas, null, "5em", "100%-10em"));
        jframe.pack();
        jframe.setVisible(true);
        jframe.setDefaultCloseOperation(3);
        return result;
    }

    public static int reducePath(PathIterator it, GeneralPath result) {
        return GraphUtil.reducePath(it, result, 1);
    }

    public static int reducePath(PathIterator it, GeneralPath result, int res) {
        float[] p = new float[6];
        float x0 = Float.MAX_VALUE;
        float y0 = Float.MAX_VALUE;
        float sx0 = 0.0f;
        float sy0 = 0.0f;
        int nx0 = 0;
        int ny0 = 0;
        float ax0 = Float.NaN;
        float ay0 = Float.NaN;
        int type0 = -999;
        float xres = res;
        float yres = res;
        int points = 0;
        int inCount = 0;
        while (!it.isDone()) {
            ++inCount;
            int type = it.currentSegment(p);
            it.next();
            float dx = p[0] - x0;
            float dy = p[1] - y0;
            if ((type == 0 || type == type0) && Math.abs(dx) < xres && Math.abs(dy) < yres) {
                sx0 += p[0];
                sy0 += p[1];
                ++nx0;
                ++ny0;
                continue;
            }
            x0 = 0.5f + (float)((int)Math.floor(p[0]));
            y0 = 0.5f + (float)((int)Math.floor(p[1]));
            ax0 = nx0 > 0 ? sx0 / (float)nx0 : p[0];
            ay0 = ny0 > 0 ? sy0 / (float)ny0 : p[1];
            sx0 = p[0];
            sy0 = p[1];
            nx0 = 1;
            ny0 = 1;
            switch (type0) {
                case 1: {
                    result.lineTo(ax0, ay0);
                    ++points;
                    break;
                }
                case 0: {
                    result.moveTo(ax0, ay0);
                    break;
                }
                case -999: {
                    break;
                }
                default: {
                    throw new IllegalArgumentException("not supported");
                }
            }
            type0 = type;
        }
        ax0 = nx0 > 0 ? sx0 / (float)nx0 : p[0];
        ay0 = ny0 > 0 ? sy0 / (float)ny0 : p[1];
        switch (type0) {
            case 1: {
                result.lineTo(ax0, ay0);
                ++points;
                break;
            }
            case 0: {
                result.moveTo(ax0, ay0);
                break;
            }
            case -999: {
                break;
            }
            default: {
                throw new IllegalArgumentException("not supported");
            }
        }
        return points;
    }

    public static double pointsAlongCurve(PathIterator it, double[] pathlen, Point2D.Double[] result, double[] orientation, boolean stopAtMoveTo) {
        float[] point = new float[6];
        float fx0 = Float.NaN;
        float fy0 = Float.NaN;
        double slen = 0.0;
        int pathlenIndex = 0;
        if (pathlen == null) {
            pathlen = new double[]{};
        }
        while (!it.isDone()) {
            int type = it.currentSegment(point);
            it.next();
            if (!Float.isNaN(fx0) && type == 0 && stopAtMoveTo) break;
            if (3 == type) {
                throw new IllegalArgumentException("cubicto not supported");
            }
            if (2 == type) {
                throw new IllegalArgumentException("quadto not supported");
            }
            if (1 == type) {
                // empty if block
            }
            if (Float.isNaN(fx0)) {
                fx0 = point[0];
                fy0 = point[1];
                continue;
            }
            double thislen = (float)Point.distance(fx0, fy0, point[0], point[1]);
            if (thislen == 0.0) continue;
            slen += thislen;
            while (pathlenIndex < pathlen.length && slen >= pathlen[pathlenIndex]) {
                double alpha = 1.0 - (slen - pathlen[pathlenIndex]) / thislen;
                double dx = point[0] - fx0;
                double dy = point[1] - fy0;
                if (result != null) {
                    result[pathlenIndex] = new Point2D.Double((double)fx0 + dx * alpha, (double)fy0 + dy * alpha);
                }
                if (orientation != null) {
                    orientation[pathlenIndex] = Math.atan2(dy, dx);
                }
                ++pathlenIndex;
            }
            fx0 = point[0];
            fy0 = point[1];
        }
        double remaining = pathlenIndex > 0 ? slen - pathlen[pathlenIndex - 1] : slen;
        if (result != null) {
            while (pathlenIndex < result.length) {
                result[pathlenIndex] = null;
                ++pathlenIndex;
            }
        }
        return remaining;
    }

    public static String getATScaleTranslateString(AffineTransform at) {
        DecimalFormat nf = new DecimalFormat("0.00");
        if (at == null) {
            return "null";
        }
        if (!at.isIdentity()) {
            String atDesc = "scaleX:" + nf.format(at.getScaleX()) + " translateX:" + nf.format(at.getTranslateX());
            atDesc = atDesc + "!cscaleY:" + nf.format(at.getScaleY()) + " translateY:" + nf.format(at.getTranslateY());
            return atDesc;
        }
        return "identity";
    }

    public static double[] getSlopeIntercept(double x0, double y0, double x1, double y1) {
        double slope = (y1 - y0) / (x1 - x0);
        double intercept = y0 - slope * x0;
        return new double[]{slope, intercept};
    }

    public static Color getRicePaperColor() {
        return new Color(255, 255, 255, 128);
    }

    public static String describe(GeneralPath path, boolean enumeratePoints) {
        PathIterator it = path.getPathIterator(null);
        int count = 0;
        int lineToCount = 0;
        double[] coords = new double[6];
        while (!it.isDone()) {
            int type = it.currentSegment(coords);
            if (type == 1) {
                ++lineToCount;
            }
            if (enumeratePoints) {
                // empty if block
            }
            ++count;
            it.next();
        }
        return "count: " + count + "  lineToCount: " + lineToCount;
    }

    static String toString(Line2D line) {
        return "" + line.getX1() + "," + line.getY1() + " " + line.getX2() + "," + line.getY2();
    }

    public static Point2D lineIntersection(Line2D line1, Line2D line2, boolean noBoundsCheck) {
        Point2D.Double result = null;
        double a1 = line1.getY2() - line1.getY1();
        double b1 = line1.getX1() - line1.getX2();
        double c1 = line1.getX2() * line1.getY1() - line1.getX1() * line1.getY2();
        double a2 = line2.getY2() - line2.getY1();
        double b2 = line2.getX1() - line2.getX2();
        double c2 = line2.getX2() * line2.getY1() - line2.getX1() * line2.getY2();
        double denom = a1 * b2 - a2 * b1;
        if (denom != 0.0) {
            result = new Point2D.Double((b1 * c2 - b2 * c1) / denom, (a2 * c1 - a1 * c2) / denom);
            if (noBoundsCheck || (((Point2D)result).getX() - line1.getX1()) * (line1.getX2() - ((Point2D)result).getX()) >= 0.0 && (((Point2D)result).getY() - line1.getY1()) * (line1.getY2() - ((Point2D)result).getY()) >= 0.0 && (((Point2D)result).getX() - line2.getX1()) * (line2.getX2() - ((Point2D)result).getX()) >= 0.0 && (((Point2D)result).getY() - line2.getY1()) * (line2.getY2() - ((Point2D)result).getY()) >= 0.0) {
                return result;
            }
            return null;
        }
        return null;
    }

    public static Point2D lineRectangleIntersection(Point2D p0, Point2D p1, Rectangle2D r0) {
        PathIterator it = r0.getPathIterator(null);
        Line2D.Double line = new Line2D.Double(p0, p1);
        float[] c0 = new float[6];
        float[] c1 = new float[6];
        it.currentSegment(c0);
        it.next();
        while (!it.isDone()) {
            Line2D.Double seg;
            Point2D result;
            int type = it.currentSegment(c1);
            if (type == 1 && (result = GraphUtil.lineIntersection(line, seg = new Line2D.Double(c0[0], c0[1], c1[0], c1[1]), false)) != null) {
                return result;
            }
            it.next();
            c0[0] = c1[0];
            c0[1] = c1[1];
        }
        return null;
    }

    public static double[] transformRange(DasAxis axis, DatumRange range) {
        double x2;
        double x1 = axis.transform(range.min());
        if (x1 > (x2 = axis.transform(range.max()))) {
            double t = x2;
            x2 = x1;
            x1 = t;
        }
        return new double[]{x1, x2};
    }

    public static DatumRange invTransformRange(DasAxis axis, double x1, double x2) {
        Datum d2;
        Datum d1 = axis.invTransform(x1);
        if (d1.gt(d2 = axis.invTransform(x2))) {
            Datum t = d2;
            d2 = d1;
            d1 = t;
        }
        return new DatumRange(d1, d2);
    }

    public static Icon colorIcon(Color iconColor, int w, int h) {
        BufferedImage image = new BufferedImage(w, h, 2);
        Graphics g = image.getGraphics();
        if (iconColor.getAlpha() != 255) {
            for (int j = 0; j < 4; ++j) {
                for (int i = 0; i < 4; ++i) {
                    g.setColor((i - j) % 2 == 0 ? Color.GRAY : Color.WHITE);
                    g.fillRect(0 + i * 4, 0 + j * 4, 4, 4);
                }
            }
        }
        g.setColor(iconColor);
        g.fillRect(0, 0, w, h);
        return new ImageIcon(image);
    }
}

