/*
 * Decompiled with CFR 0.152.
 */
package org.das2.graph;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Stroke;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import javax.swing.Icon;
import org.das2.components.propertyeditor.Enumeration;
import org.das2.datum.Units;
import org.das2.graph.DasAxis;
import org.das2.graph.GrannyTickLabeller;
import org.das2.graph.GraphUtil;
import org.das2.graph.Renderer;
import org.das2.graph.TickLabeller;
import org.das2.graph.TickVDescriptor;
import org.das2.util.DasMath;
import org.das2.util.monitor.ProgressMonitor;
import org.virbo.dataset.DDataSet;
import org.virbo.dataset.DataSetOps;
import org.virbo.dataset.QDataSet;
import org.virbo.dataset.SemanticOps;
import org.virbo.dsops.Ops;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class TickCurveRenderer
extends Renderer {
    private Stroke stroke;
    TickVDescriptor tickv;
    private String xplane;
    private String yplane;
    private QDataSet xds;
    private QDataSet yds;
    private Units xunits;
    private Units yunits;
    private double[][] idata;
    TickLabeller tickLabeller;
    private TickStyle tickStyle;
    private double lineWidth;
    private float tickLength;

    public TickCurveRenderer(QDataSet ds, String xplane, String yplane, TickVDescriptor tickv) {
        super(ds);
        this.setTickStyle(TickStyle.outer);
        this.setLineWidth(1.0);
        this.setTickLength(8.0f);
        this.xplane = xplane;
        this.yplane = yplane;
        this.tickv = tickv;
    }

    protected void uninstallRenderer() {
    }

    protected void installRenderer() {
    }

    private static double length(Line2D line) {
        double dx = line.getX2() - line.getX1();
        double dy = line.getY2() - line.getY1();
        double dist = Math.sqrt(dx * dx + dy * dy);
        return dist;
    }

    private static Line2D normalize(Line2D line, double len) {
        Point2D p1 = line.getP1();
        double dx = line.getX2() - line.getX1();
        double dy = line.getY2() - line.getY1();
        double dist = Math.sqrt(dx * dx + dy * dy);
        Line2D result = (Line2D)line.clone();
        result.setLine(p1.getX(), p1.getY(), p1.getX() + dx / dist * len, p1.getY() + dy / dist * len);
        return result;
    }

    private double turnDir(double x1, double y1, double x2, double y2, double x3, double y3) {
        double dx1 = x2 - x1;
        double dx2 = x3 - x2;
        double dy1 = y2 - y1;
        double dy2 = y3 - y2;
        return dx1 * dy2 - dx2 * dy1;
    }

    private double turnDirAt(double findex) {
        int nvert = this.xds.length();
        int index0 = findex < 1.0 ? 0 : (findex > (double)(nvert - 2) ? nvert - 3 : (int)Math.floor(findex) - 1);
        int index1 = index0 + 1;
        int index2 = index1 + 1;
        return this.turnDir(this.xds.value(index0), this.yds.value(index0), this.xds.value(index1), this.yds.value(index1), this.xds.value(index2), this.yds.value(index2));
    }

    private Line2D outsideNormalAt(double findex) {
        double dxNorm;
        double dyNorm;
        double turnDirTick;
        int nvert = this.xds.length();
        int index0 = (int)Math.floor(findex);
        if (index0 == nvert - 1) {
            --index0;
        }
        double x1 = this.idata[0][index0];
        double x2 = this.idata[0][index0 + 1];
        double y1 = this.idata[1][index0];
        double y2 = this.idata[1][index0 + 1];
        double xinterp = DasMath.interpolate((double[])this.idata[0], (double)findex);
        double yinterp = DasMath.interpolate((double[])this.idata[1], (double)findex);
        double dx = x2 - x1;
        double dy = y2 - y1;
        double turnDir = this.turnDirAt(findex);
        if (turnDir * (turnDirTick = -1.0 * (dx * (dyNorm = -dx) - (dxNorm = dy) * dy)) > 0.0) {
            dxNorm = -dy;
            dyNorm = dx;
        }
        return TickCurveRenderer.normalize(new Line2D.Double(xinterp, yinterp, xinterp + dxNorm, yinterp + dyNorm), 1.0);
    }

    private void drawTick(Graphics2D g, double findex) {
        float tl = this.getTickLength() * 2.0f / 3.0f;
        Line2D tick = TickCurveRenderer.normalize(this.outsideNormalAt(findex), tl);
        if (this.tickStyle == TickStyle.both) {
            Line2D flipTick = TickCurveRenderer.normalize(tick, -tl);
            Line2D.Double bothTick = new Line2D.Double(flipTick.getP2(), tick.getP2());
            g.draw(bothTick);
        } else {
            g.draw(tick);
        }
    }

    private double slope(Line2D line) {
        return (line.getY2() - line.getY1()) / (line.getX2() - line.getX1());
    }

    private void drawLabelTick(Graphics2D g, double findex, int tickNumber) {
        float tl = this.getTickLength();
        Line2D tick = TickCurveRenderer.normalize(this.outsideNormalAt(findex), tl);
        if (this.tickStyle == TickStyle.both) {
            Line2D flipTick = TickCurveRenderer.normalize(tick, -tl);
            Line2D.Double bothTick = new Line2D.Double(flipTick.getP2(), tick.getP2());
            g.draw(bothTick);
        } else {
            g.draw(tick);
        }
        this.tickLabeller.labelMajorTick(g, tickNumber, tick);
    }

    public void render(Graphics g1, DasAxis xAxis, DasAxis yAxis, ProgressMonitor mon) {
        int i;
        int i2;
        if (this.ds == null) {
            return;
        }
        Graphics2D g = (Graphics2D)g1;
        g.setStroke(this.stroke);
        g.setColor(Color.black);
        QDataSet ds3 = this.getDataSet();
        this.xds = DataSetOps.unbundle((QDataSet)ds3, (String)this.xplane);
        this.yds = DataSetOps.unbundle((QDataSet)ds3, (String)this.yplane);
        this.xunits = SemanticOps.getUnits((QDataSet)this.xds);
        this.yunits = SemanticOps.getUnits((QDataSet)this.yds);
        this.idata = new double[2][this.xds.length()];
        for (i2 = 0; i2 < this.xds.length(); ++i2) {
            this.idata[0][i2] = xAxis.transform(this.xds.value(i2), this.xunits);
            this.idata[1][i2] = yAxis.transform(this.yds.value(i2), this.yunits);
        }
        for (i2 = 1; i2 < this.xds.length(); ++i2) {
            g.drawLine((int)this.idata[0][i2 - 1], (int)this.idata[1][i2 - 1], (int)this.idata[0][i2], (int)this.idata[1][i2]);
        }
        DDataSet xxds = DDataSet.wrap((double[])this.tickv.minorTickV.toDoubleArray(this.xunits), (Units)this.xunits);
        QDataSet findex = Ops.findex((QDataSet)this.xds, (QDataSet)xxds);
        this.tickLabeller = new GrannyTickLabeller();
        this.tickLabeller.init(this.tickv);
        for (i = 0; i < this.tickv.minorTickV.getLength(); ++i) {
            if (!(findex.value(i) >= 0.0) || !(findex.value(i) < (double)this.xds.length())) continue;
            this.drawTick(g, findex.value(i));
        }
        xxds = DDataSet.wrap((double[])this.tickv.tickV.toDoubleArray(this.xunits), (Units)this.xunits);
        findex = Ops.findex((QDataSet)this.xds, (QDataSet)xxds);
        for (i = 0; i < this.tickv.tickV.getLength(); ++i) {
            if (!(findex.value(i) >= 0.0) || !(findex.value(i) < (double)this.xds.length())) continue;
            this.drawLabelTick(g, findex.value(i), i);
        }
        this.tickLabeller.finished();
    }

    private static String lineToString(Line2D line) {
        return GraphUtil.toString(line);
    }

    public TickStyle getTickStyle() {
        return this.tickStyle;
    }

    public void setTickStyle(TickStyle tickStyle) {
        this.tickStyle = tickStyle;
        this.invalidateParentCacheImage();
    }

    public double getLineWidth() {
        return this.lineWidth;
    }

    public void setLineWidth(double lineWidth) {
        this.lineWidth = lineWidth;
        this.stroke = new BasicStroke((float)lineWidth);
        this.invalidateParentCacheImage();
    }

    public float getTickLength() {
        return this.tickLength;
    }

    public void setTickLength(float tickLength) {
        this.tickLength = tickLength;
        this.invalidateParentCacheImage();
    }

    protected Element getDOMElement(Document document) {
        throw new UnsupportedOperationException();
    }

    public void setTickVDescriptor(TickVDescriptor ticks) {
        this.tickv = ticks;
        this.invalidateParentCacheImage();
    }

    public static class TickStyle
    implements Enumeration {
        private String name;
        public static final TickStyle outer = new TickStyle("Outer");
        public static final TickStyle both = new TickStyle("Both");

        private TickStyle(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }

        public Icon getListIcon() {
            return null;
        }
    }
}

