/*
 * Decompiled with CFR 0.152.
 */
package org.das2.math;

import java.awt.Checkbox;
import java.awt.Event;
import java.awt.GridLayout;
import java.awt.Label;
import java.awt.Panel;
import java.awt.TextField;
import org.das2.math.TriangulationAlgorithm;

class AlgorithmUI
extends Panel {
    TextField nPointsTextField;
    Checkbox[] animateCheckBox;
    Checkbox runCheckBox;
    TextField pauseTextField;
    TriangulationAlgorithm algorithm;

    public AlgorithmUI(TriangulationAlgorithm algorithm, String label, int nPoints, int pause) {
        this.algorithm = algorithm;
        this.setLayout(new GridLayout(0, 7));
        this.add(new Label(label, 0));
        this.runCheckBox = new Checkbox(null, null, true);
        this.add(this.runCheckBox);
        this.nPointsTextField = new TextField(String.valueOf(nPoints), 5);
        this.add(this.nPointsTextField);
        this.animateCheckBox = new Checkbox[4];
        this.animateCheckBox[1] = new Checkbox(null, null, true);
        this.add(this.animateCheckBox[1]);
        this.animateCheckBox[3] = new Checkbox(null, null, true);
        this.add(this.animateCheckBox[3]);
        this.animateCheckBox[2] = new Checkbox(null, null, true);
        this.add(this.animateCheckBox[2]);
        this.pauseTextField = new TextField(String.valueOf(pause), 5);
        this.add(this.pauseTextField);
    }

    public void setAlgorithm(TriangulationAlgorithm algorithm) {
        this.algorithm = algorithm;
    }

    int getValue(TextField tF) {
        int i;
        try {
            i = Integer.valueOf(tF.getText());
        }
        catch (NumberFormatException e) {
            i = 0;
        }
        return i;
    }

    public boolean handleEvent(Event evt) {
        if (evt.id == 1001) {
            if (evt.target == this.runCheckBox) {
                this.algorithm.control().setRun((Boolean)evt.arg);
                return true;
            }
            if (evt.target == this.animateCheckBox[1]) {
                this.algorithm.control().setAnimate(1, (Boolean)evt.arg);
                return true;
            }
            if (evt.target == this.animateCheckBox[3]) {
                this.algorithm.control().setAnimate(3, (Boolean)evt.arg);
                return true;
            }
            if (evt.target == this.animateCheckBox[2]) {
                this.algorithm.control().setAnimate(2, (Boolean)evt.arg);
                return true;
            }
            if (evt.target == this.pauseTextField) {
                this.algorithm.control().setPause(this.getValue(this.pauseTextField));
                return true;
            }
            if (evt.target == this.nPointsTextField) {
                this.algorithm.control().nPoints = this.getValue(this.nPointsTextField);
                return true;
            }
        }
        return false;
    }
}

