/*
 * Decompiled with CFR 0.152.
 */
package org.das2.math;

public class Interpolate {
    public static DDoubleArray newDDoubleArray(final double[][] array) {
        return new DDoubleArray(){

            public double get(int i, int j) {
                return array[i][j];
            }

            public void put(int i, int j, double value) {
                array[i][j] = value;
            }

            public int rows() {
                return array.length;
            }

            public int columns() {
                return array[0].length;
            }
        };
    }

    public static DDoubleArray newDDoubleArray(int columns, int rows) {
        return new DDoubleArrayImpl(columns, rows);
    }

    public static DDoubleArray interpolate2(DDoubleArray source, float[] xFindex, float[] yFindex) {
        int i;
        DDoubleArray result = Interpolate.newDDoubleArray(xFindex.length, yFindex.length);
        double[] xfp0 = new double[xFindex.length];
        double[] xfp1 = new double[xFindex.length];
        int[] xip0 = new int[xFindex.length];
        int[] xip1 = new int[xFindex.length];
        for (int i2 = 0; i2 < xFindex.length; ++i2) {
            xip0[i2] = (int)xFindex[i2];
            if (xip0[i2] == source.rows() - 1) {
                int n = i2;
                xip0[n] = xip0[n] - 1;
            }
            xip1[i2] = 1 + xip0[i2];
            xfp0[i2] = xFindex[i2] - (float)xip0[i2];
            xfp1[i2] = 1.0 - xfp0[i2];
        }
        double[] yfp0 = new double[yFindex.length];
        double[] yfp1 = new double[yFindex.length];
        int[] yip0 = new int[yFindex.length];
        int[] yip1 = new int[yFindex.length];
        for (i = 0; i < yFindex.length; ++i) {
            yip0[i] = (int)yFindex[i];
            if (yip0[i] == source.columns() - 1) {
                int n = i;
                yip0[n] = yip0[n] - 1;
            }
            yip1[i] = 1 + yip0[i];
            yfp0[i] = yFindex[i] - (float)yip0[i];
            yfp1[i] = 1.0 - yfp0[i];
        }
        for (i = 0; i < xFindex.length; ++i) {
            for (int j = 0; j < yFindex.length; ++j) {
                double value = source.get(xip0[i], yip0[j]) * xfp1[i] * yfp1[j] + source.get(xip0[i], yip1[j]) * xfp1[i] * yfp0[j] + source.get(xip1[i], yip0[j]) * xfp0[i] * yfp1[j] + source.get(xip1[i], yip1[j]) * xfp0[i] * yfp0[j];
                result.put(i, j, value);
            }
        }
        return result;
    }

    public static DDoubleArray interpolate(DDoubleArray source, float[] xFindex, float[] yFindex) {
        int i;
        DDoubleArray result = Interpolate.newDDoubleArray(xFindex.length, yFindex.length);
        double[] xfp0 = new double[xFindex.length];
        double[] xfp1 = new double[xFindex.length];
        int[] xip0 = new int[xFindex.length];
        int[] xip1 = new int[xFindex.length];
        for (int i2 = 0; i2 < xFindex.length; ++i2) {
            xip0[i2] = (int)xFindex[i2];
            if (xip0[i2] == source.rows() - 1) {
                int n = i2;
                xip0[n] = xip0[n] - 1;
            }
            xip1[i2] = 1 + xip0[i2];
            xfp0[i2] = xFindex[i2] - (float)xip0[i2];
            xfp1[i2] = 1.0 - xfp0[i2];
        }
        double[] yfp0 = new double[yFindex.length];
        double[] yfp1 = new double[yFindex.length];
        int[] yip0 = new int[yFindex.length];
        int[] yip1 = new int[yFindex.length];
        for (i = 0; i < yFindex.length; ++i) {
            yip0[i] = (int)yFindex[i];
            if (yip0[i] == source.columns() - 1) {
                int n = i;
                yip0[n] = yip0[n] - 1;
            }
            yip1[i] = 1 + yip0[i];
            yfp0[i] = yFindex[i] - (float)yip0[i];
            yfp1[i] = 1.0 - yfp0[i];
        }
        for (i = 0; i < xFindex.length; ++i) {
            for (int j = 0; j < yFindex.length; ++j) {
                double a00 = xfp0[i] * yfp0[j];
                double a01 = xfp0[i] * yfp1[j];
                double a10 = xfp1[i] * yfp0[j];
                double a11 = xfp1[i] * yfp1[j];
                double p00 = source.get(xip0[i], yip0[j]);
                double p01 = source.get(xip0[i], yip1[j]);
                double p10 = source.get(xip1[i], yip0[j]);
                double p11 = source.get(xip1[i], yip1[j]);
                double value = p00 * a11 + p01 * a10 + p10 * a01 + p11 * a00;
                result.put(i, j, value);
            }
        }
        return result;
    }

    private static final class DDoubleArrayImpl
    implements DDoubleArray {
        double[] back;
        int rows;
        int columns;
        static final boolean boundsCheck = false;

        DDoubleArrayImpl(int columns, int rows) {
            this.back = new double[rows * columns];
            this.columns = columns;
            this.rows = rows;
        }

        public double get(int i, int j) {
            return this.back[j * this.rows + i];
        }

        public void put(int i, int j, double value) {
            this.back[j * this.rows + i] = value;
        }

        public int rows() {
            return this.rows;
        }

        public int columns() {
            return this.columns;
        }
    }

    public static interface FDoubleArray {
        public float get(int var1, int var2);

        public void put(int var1, int var2, float var3);

        public int rows();

        public int columns();
    }

    public static interface DDoubleArray {
        public double get(int var1, int var2);

        public void put(int var1, int var2, double var3);

        public int rows();

        public int columns();
    }
}

