/*
 * Decompiled with CFR 0.152.
 */
package org.das2.math.fft;

import org.das2.dataset.ClippedVectorDataSet;
import org.das2.dataset.DataSet;
import org.das2.dataset.DataSetUtil;
import org.das2.dataset.TableDataSet;
import org.das2.dataset.TableDataSetBuilder;
import org.das2.dataset.VectorDataSet;
import org.das2.datum.DatumVector;
import org.das2.datum.Units;
import org.das2.datum.UnitsUtil;
import org.das2.math.fft.FFTUtil;
import org.das2.math.fft.GeneralFFT;

public class WaveformToSpectrum {
    private static final double LOG_2 = Math.log(2.0);

    static DatumVector getFrequencyDomainTags(DatumVector timeDomainTags) {
        Units frequencyUnit;
        int i;
        Units timeUnit = timeDomainTags.getUnits();
        double[] x = timeDomainTags.toDoubleArray(timeUnit);
        double[] result = new double[x.length];
        result[0] = 0.0;
        double T = x[1] - x[0];
        int n = x.length;
        int n21 = n / 2 + 1;
        for (i = 0; i < n21; ++i) {
            result[i] = (double)i / ((double)n * T);
        }
        for (i = 0; i < n21 - 2; ++i) {
            result[i + n21] = (double)(n21 - n + i) / ((double)n * T);
        }
        double unitMult = 1.0;
        if (timeUnit.isConvertableTo(Units.seconds)) {
            unitMult = timeUnit.getConverter(Units.seconds).convert(1.0);
            timeUnit = Units.seconds;
            frequencyUnit = Units.hertz;
            for (int i2 = 0; i2 < result.length; ++i2) {
                result[i2] = result[i2] / unitMult;
            }
        } else {
            frequencyUnit = UnitsInverter.getInverseUnit(timeUnit);
        }
        return DatumVector.newDatumVector((double[])result, (Units)frequencyUnit);
    }

    private static boolean checkXTagsGrid(DataSet ds, int st, int en) {
        if (ds.getXLength() < 1) {
            return false;
        }
        Units units = ds.getXUnits();
        double base = ds.getXTagDouble(st, units);
        double delta = (ds.getXTagDouble(en - 1, units) - base) / (double)(en - st - 1);
        for (int i = st; i < en; ++i) {
            double rr = (ds.getXTagDouble(i, units) - base) / delta % 1.0;
            if (!(rr > 0.01) || !(rr < 0.09)) continue;
            return false;
        }
        return true;
    }

    public static double[][] fft(double[][] array) {
        double t_i;
        double t_r;
        int i;
        int n = array[0].length;
        int ln = (int)(Math.log(n) / LOG_2 + 0.5);
        if (Math.pow(2.0, ln) != (double)n) {
            throw new IllegalArgumentException("input array ([" + array.length + "][" + n + "]) is not [2][2^k]");
        }
        int nv2 = n / 2;
        int j = 1;
        for (i = 1; i < n; ++i) {
            int k;
            if (i < j) {
                t_r = array[0][i - 1];
                t_i = array[1][i - 1];
                array[0][i - 1] = array[0][j - 1];
                array[1][i - 1] = array[1][j - 1];
                array[0][j - 1] = t_r;
                array[1][j - 1] = t_i;
            }
            for (k = nv2; k < j; j -= k, k /= 2) {
            }
            j += k;
        }
        for (int l = 1; l <= ln; ++l) {
            int le = (int)(Math.exp((double)l * LOG_2) + 0.5);
            int le1 = le / 2;
            double u_r = 1.0;
            double u_i = 0.0;
            double w_r = Math.cos(Math.PI / (double)le1);
            double w_i = -Math.sin(Math.PI / (double)le1);
            for (j = 1; j <= le1; ++j) {
                for (i = j; i <= n; i += le) {
                    int ip = i + le1;
                    t_r = array[0][ip - 1] * u_r - u_i * array[1][ip - 1];
                    t_i = array[1][ip - 1] * u_r + u_i * array[0][ip - 1];
                    array[0][ip - 1] = array[0][i - 1] - t_r;
                    array[1][ip - 1] = array[1][i - 1] - t_i;
                    array[0][i - 1] = array[0][i - 1] + t_r;
                    array[1][i - 1] = array[1][i - 1] + t_i;
                }
                t_r = u_r * w_r - w_i * u_i;
                u_i = w_r * u_i + w_i * u_r;
                u_r = t_r;
            }
        }
        return array;
    }

    public static TableDataSet getTableDataSet2(VectorDataSet vds, int windowSize) {
        GeneralFFT fft = GeneralFFT.newDoubleFFT(windowSize);
        if (!WaveformToSpectrum.checkXTagsGrid(vds, 0, vds.getXLength())) {
            throw new IllegalArgumentException("xtags don't appear to be gridded");
        }
        Units xUnits = vds.getXUnits();
        double[] yt = FFTUtil.getFrequencyDomainTags(1.0 / (vds.getXTagDouble(1, xUnits) - vds.getXTagDouble(0, xUnits)), windowSize / 2);
        DatumVector yTags = DatumVector.newDatumVector((double[])yt, (Units)UnitsUtil.getInverseUnit((Units)xUnits.getOffsetUnits()));
        Units zUnits = vds.getYUnits();
        TableDataSetBuilder tdsb = new TableDataSetBuilder(vds.getXUnits(), yTags.getUnits(), zUnits);
        int nTableXTags = vds.getXLength() / windowSize;
        VectorDataSet window = FFTUtil.getWindow10PercentEdgeCosine(windowSize);
        double[] d = new double[windowSize / 2];
        for (int i = 0; i < nTableXTags; ++i) {
            VectorDataSet ds = FFTUtil.fftPower(fft, new ClippedVectorDataSet(vds, i * windowSize, windowSize));
            Units u = ds.getYUnits();
            for (int j = 0; j < d.length; ++j) {
                d[j] = ds.getDouble(j, u);
            }
            tdsb.insertYScan(vds.getXTagDatum((int)(((double)i + 0.5) * (double)windowSize)), yTags, DatumVector.newDatumVector((double[])d, (Units)u));
        }
        return tdsb.toTableDataSet();
    }

    public static TableDataSet getTableDataSet(VectorDataSet vds, int windowSize) {
        int i;
        Units xOffsetUnits;
        int n21 = windowSize / 2 + 1;
        Units xUnits = vds.getXUnits();
        Units timeDomainUnits = xOffsetUnits = xUnits.getOffsetUnits();
        Object buf = new double[windowSize];
        double base = vds.getXTagDouble(0, vds.getXUnits());
        for (i = 0; i < windowSize; ++i) {
            buf[i] = xOffsetUnits.convertDoubleTo(timeDomainUnits, vds.getXTagDouble(i, xUnits) - base);
        }
        DatumVector yTags = WaveformToSpectrum.getFrequencyDomainTags(DatumVector.newDatumVector((double[])buf, (Units)timeDomainUnits)).getSubVector(1, n21);
        Units zUnits = vds.getYUnits();
        TableDataSetBuilder tdsb = new TableDataSetBuilder(vds.getXUnits(), yTags.getUnits(), zUnits);
        VectorDataSet wvds = (VectorDataSet)DataSetUtil.getWeightsDataSet(vds);
        buf = new double[2][windowSize];
        int ngood = 0;
        int nTableXTags = vds.getXLength() / windowSize;
        for (i = 0; i < nTableXTags; ++i) {
            int j;
            boolean fill = false;
            if (!WaveformToSpectrum.checkXTagsGrid(vds, i * windowSize, (i + 1) * windowSize)) continue;
            ++ngood;
            for (int j2 = 0; j2 < windowSize; ++j2) {
                buf[0][j2] = vds.getDouble(i * windowSize + j2, zUnits);
                if (wvds.getDouble(i * windowSize + j2, Units.dimensionless) == 0.0) {
                    fill = true;
                }
                buf[1][j2] = 0.0;
            }
            double[] zBuf = new double[n21 - 1];
            if (fill) {
                for (j = 1; j < n21; ++j) {
                    zBuf[j - 1] = zUnits.getFillDouble();
                }
            } else {
                WaveformToSpectrum.fft((double[][])buf);
                for (j = 1; j < n21; ++j) {
                    zBuf[j - 1] = Math.sqrt((double)(buf[0][j] * buf[0][j] + buf[1][j] * buf[1][j]));
                }
            }
            tdsb.insertYScan(vds.getXTagDatum((int)(((double)i + 0.5) * (double)windowSize)), yTags, DatumVector.newDatumVector((double[])zBuf, (Units)zUnits));
        }
        if (ngood == 0) {
            throw new IllegalArgumentException("xtags don't appear to be gridded");
        }
        return tdsb.toTableDataSet();
    }

    static class UnitsInverter {
        UnitsInverter() {
        }

        static Units getInverseUnit(Units unit) {
            if (unit == Units.seconds) {
                return Units.hertz;
            }
            if (unit == Units.dimensionless) {
                return Units.dimensionless;
            }
            throw new IllegalArgumentException("units not supported: " + unit);
        }
    }
}

