/*
 * Decompiled with CFR 0.152.
 */
package org.das2.math.fft;

import java.util.Map;
import org.das2.dataset.DataSet;
import org.das2.dataset.TableDataSet;
import org.das2.dataset.VectorDataSet;
import org.das2.datum.Datum;
import org.das2.datum.DatumVector;
import org.das2.datum.Units;

public class WindowTableDataSet
implements TableDataSet {
    VectorDataSet source;
    int windowSize;
    double delta;
    Units deltaUnits;

    private static boolean checkXTagsGrid(DataSet ds) {
        if (ds.getXLength() < 1) {
            return false;
        }
        Units units = ds.getXUnits().getOffsetUnits();
        double base = ds.getXTagDouble(0, units);
        double delta = (ds.getXTagDouble(ds.getXLength() - 1, units) - base) / (double)(ds.getXLength() - 1);
        for (int i = 0; i < ds.getXLength(); ++i) {
            double rr = (ds.getXTagDouble(i, units) - base) / delta % 1.0;
            if (!(rr > 0.01) || !(rr < 0.09)) continue;
            return false;
        }
        return true;
    }

    public WindowTableDataSet(VectorDataSet source, int windowSize) {
        this.source = source;
        this.windowSize = windowSize;
        if (!WindowTableDataSet.checkXTagsGrid(source)) {
            throw new IllegalArgumentException("xTags don't appear to be gridded");
        }
        if (source.getXLength() < windowSize) {
            throw new IllegalArgumentException("windowSize (" + windowSize + ") exceeds source xTag length (" + source.getXLength() + ")");
        }
        Units units = source.getXUnits().getOffsetUnits();
        this.delta = (source.getXTagDouble(source.getXLength() - 1, units) - source.getXTagDouble(0, units)) / (double)(source.getXLength() - 1);
        this.deltaUnits = units;
    }

    public Datum getDatum(int i, int j) {
        return this.source.getDatum(i * this.windowSize + j);
    }

    public double getDouble(int i, int j, Units units) {
        return this.source.getDouble(i * this.windowSize + j, units);
    }

    public int getInt(int i, int j, Units units) {
        return this.source.getInt(i * this.windowSize + j, units);
    }

    public DataSet getPlanarView(String planeID) {
        return new WindowTableDataSet((VectorDataSet)this.source.getPlanarView(planeID), this.windowSize);
    }

    public Object getProperty(String name) {
        return this.source.getProperty(name);
    }

    public Object getProperty(int table, String name) {
        return this.getProperty(name);
    }

    public int getXLength() {
        return this.source.getXLength() / this.windowSize;
    }

    public VectorDataSet getXSlice(int i) {
        throw new IllegalArgumentException();
    }

    public Datum getXTagDatum(int i) {
        return this.source.getXTagDatum(i * this.windowSize);
    }

    public double getXTagDouble(int i, Units units) {
        return this.source.getXTagDouble(i * this.windowSize, units);
    }

    public int getXTagInt(int i, Units units) {
        return this.source.getXTagInt(i * this.windowSize, units);
    }

    public Units getXUnits() {
        return this.source.getXUnits();
    }

    public int getYLength(int table) {
        return this.windowSize;
    }

    public VectorDataSet getYSlice(int j, int table) {
        throw new IllegalArgumentException("not implemented");
    }

    public Datum getYTagDatum(int table, int j) {
        return this.getYUnits().createDatum(this.getYTagDouble(table, j, this.getYUnits()));
    }

    public DatumVector getYTags(int table) {
        double[] ytags = new double[this.getYLength(table)];
        for (int j = 0; j < this.getYLength(table); ++j) {
            ytags[j] = this.delta * (double)j;
        }
        return DatumVector.newDatumVector((double[])ytags, (Units)this.getYUnits());
    }

    public double getYTagDouble(int table, int j, Units units) {
        return this.getYUnits().convertDoubleTo(units, this.delta * (double)j);
    }

    public int getYTagInt(int table, int j, Units units) {
        return (int)this.getYTagDouble(table, j, units);
    }

    public Units getYUnits() {
        return this.deltaUnits;
    }

    public Units getZUnits() {
        return this.source.getYUnits();
    }

    public int tableCount() {
        return 1;
    }

    public int tableEnd(int table) {
        return this.source.getXLength() / this.windowSize;
    }

    public int tableOfIndex(int i) {
        return 0;
    }

    public int tableStart(int table) {
        return 0;
    }

    public double[] getDoubleScan(int i, Units units) {
        DatumVector vv = this.getScan(i);
        return vv.toDoubleArray(units);
    }

    public DatumVector getScan(int i) {
        double[] zz = new double[this.getYLength(this.tableOfIndex(i))];
        for (int j = 0; j < zz.length; ++j) {
            zz[j] = this.getDouble(i, j, this.getYUnits());
        }
        return DatumVector.newDatumVector((double[])zz, (Units)this.getYUnits());
    }

    public String[] getPlaneIds() {
        return this.source.getPlaneIds();
    }

    public Map getProperties() {
        return this.source.getProperties();
    }
}

