/*
 * Decompiled with CFR 0.152.
 */
package org.das2.stream;

import java.text.ParseException;
import java.util.HashMap;
import java.util.Map;
import org.das2.datum.Units;
import org.virbo.dataset.SemanticOps;

public final class PropertyType {
    private static final Map map = new HashMap();
    public static final PropertyType DOUBLE = new PropertyType("double");
    public static final PropertyType DOUBLE_ARRAY = new PropertyType("doubleArray");
    public static final PropertyType DATUM = new PropertyType("Datum");
    public static final PropertyType INTEGER = new PropertyType("int");
    private final String name;

    public static PropertyType getByName(String name) {
        PropertyType result = (PropertyType)map.get(name);
        if (result == null) {
            throw new IllegalArgumentException("Unrecognized property type: " + name);
        }
        return result;
    }

    private PropertyType(String name) {
        this.name = name;
        map.put(name, this);
    }

    public Object parse(String s) throws ParseException {
        if (this.name.equals("double")) {
            try {
                return new Double(s);
            }
            catch (NumberFormatException nfe) {
                throw new ParseException(nfe.getMessage(), 0);
            }
        }
        if (this.name.equals("int")) {
            try {
                return new Integer(s);
            }
            catch (NumberFormatException nfe) {
                throw new ParseException(nfe.getMessage(), 0);
            }
        }
        if (this.name.equals("doubleArray")) {
            try {
                String[] strings = s.split(",");
                double[] doubles = new double[strings.length];
                for (int i = 0; i < strings.length; ++i) {
                    doubles[i] = Double.parseDouble(strings[i]);
                }
                return doubles;
            }
            catch (NumberFormatException nfe) {
                throw new ParseException(nfe.getMessage(), 0);
            }
        }
        if (this.name.equals("Datum")) {
            String[] split = s.split("\\s+");
            if (split.length == 1) {
                return Units.dimensionless.parse(split[0]);
            }
            if (split.length == 2) {
                Units units = SemanticOps.lookupUnits((String)split[1]);
                return units.parse(split[0]);
            }
            throw new IllegalArgumentException("Too many tokens: '" + s + "'");
        }
        throw new IllegalStateException("unrecognized name: " + this.name);
    }

    public String toString() {
        return this.name;
    }
}

