/*
 * Decompiled with CFR 0.152.
 */
package test.graph;

import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.JFrame;
import javax.swing.JPanel;
import org.das2.datum.DatumRange;
import org.das2.datum.Units;
import org.das2.graph.DasCanvas;
import org.das2.graph.DasPlot;
import org.das2.graph.GraphUtil;
import org.das2.graph.RGBImageRenderer;
import org.das2.graph.Renderer;
import org.virbo.dataset.DataSetUtil;
import org.virbo.dataset.QDataSet;
import org.virbo.dataset.SDataSet;
import org.virbo.dsops.Ops;
import test.graph.PlotDemo;

public class RGBImageDemo
extends PlotDemo {
    JPanel contentPane;

    private synchronized JPanel getContentPane() {
        if (this.contentPane == null) {
            this.contentPane = new JPanel();
        }
        return this.contentPane;
    }

    public void showFrame() {
        JFrame frame = new JFrame("Axis Demo");
        frame.getContentPane().add(this.getContentPane());
        frame.pack();
        frame.setDefaultCloseOperation(3);
        frame.setVisible(true);
    }

    public RGBImageDemo() {
        int width = 500;
        int height = 500;
        this.getContentPane().setLayout(new BorderLayout());
        DasCanvas canvas = new DasCanvas(width, height);
        this.getContentPane().add((Component)canvas, "Center");
        DatumRange xrange = DatumRange.newDatumRange((double)-100.0, (double)400.0, (Units)Units.dimensionless);
        DatumRange yrange = DatumRange.newDatumRange((double)-100.0, (double)400.0, (Units)Units.dimensionless);
        DasPlot plot = GraphUtil.newDasPlot(canvas, xrange, yrange);
        plot.getXAxis().setUseDomainDivider(true);
        plot.getYAxis().setUseDomainDivider(true);
        RGBImageRenderer r = new RGBImageRenderer();
        QDataSet red = Ops.multiply((QDataSet)DataSetUtil.asDataSet((double)255.0), (QDataSet)Ops.rand((int)200, (int)200));
        QDataSet green = Ops.multiply((QDataSet)DataSetUtil.asDataSet((double)0.0), (QDataSet)Ops.rand((int)200, (int)200));
        QDataSet blue = Ops.multiply((QDataSet)DataSetUtil.asDataSet((double)0.0), (QDataSet)Ops.rand((int)200, (int)200));
        SDataSet rgb = SDataSet.createRank3((int)200, (int)200, (int)3);
        for (int i = 0; i < rgb.length(); ++i) {
            for (int j = 0; j < rgb.length(0); ++j) {
                rgb.putValue(i, j, 0, 255.0);
                rgb.putValue(i, j, 1, i % 3 == 0 ? 255.0 : 0.0);
                rgb.putValue(i, j, 2, j % 5 == 0 ? 255.0 : 0.0);
            }
        }
        rgb.putProperty("DEPEND_2", (Object)Ops.labels((String[])new String[]{"b", "g", "r"}));
        ((Renderer)r).setDataSet((QDataSet)rgb);
        plot.addRenderer(r);
    }

    public static void main(String[] args) {
        new RGBImageDemo().showFrame();
    }
}

