/*
 * Decompiled with CFR 0.152.
 */
package org.virbo.qstream;

import java.nio.ByteBuffer;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.virbo.dataset.DDataSet;
import org.virbo.dataset.DataSetUtil;
import org.virbo.dataset.JoinDataSet;
import org.virbo.dataset.MutablePropertyDataSet;
import org.virbo.dataset.QDataSet;
import org.virbo.dsutil.DataSetBuilder;
import org.virbo.qstream.AsciiTransferType;
import org.virbo.qstream.PacketDescriptor;
import org.virbo.qstream.PlaneDescriptor;
import org.virbo.qstream.SerializeDelegate;
import org.virbo.qstream.SerializeRegistry;
import org.virbo.qstream.StreamDescriptor;
import org.virbo.qstream.StreamException;
import org.virbo.qstream.StreamHandler;
import org.virbo.qstream.TransferType;
import org.virbo.qstream.Util;
import org.virbo.qstream.XMLSerializeDelegate;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QDataSetStreamHandler
implements StreamHandler {
    public static final String BUILDER_JOIN_CHILDREN = "join";
    Map<String, DataSetBuilder> builders;
    Map<String, JoinDataSet> joinDataSets;
    XPathFactory factory = XPathFactory.newInstance();
    XPath xpath = this.factory.newXPath();
    String dsname;
    boolean readPackets = true;

    public QDataSetStreamHandler() {
        this.builders = new HashMap<String, DataSetBuilder>();
        this.joinDataSets = new HashMap<String, JoinDataSet>();
    }

    public List<String> getDataSetNames() {
        return new ArrayList<String>(this.builders.keySet());
    }

    DataSetBuilder createBuilder(int rank, int[] qube) {
        DataSetBuilder result;
        block15: {
            block17: {
                block16: {
                    block14: {
                        if (rank != qube.length) break block14;
                        switch (rank) {
                            case 1: {
                                result = new DataSetBuilder(rank, qube[0]);
                                break block15;
                            }
                            case 2: {
                                result = new DataSetBuilder(rank, qube[0], qube[1]);
                                break block15;
                            }
                            case 3: {
                                result = new DataSetBuilder(rank, qube[0], qube[1], qube[2]);
                                break block15;
                            }
                            default: {
                                throw new IllegalArgumentException("rank limit");
                            }
                        }
                    }
                    if (rank != qube.length + 1) break block16;
                    switch (rank) {
                        case 1: {
                            result = new DataSetBuilder(rank, 100);
                            break block15;
                        }
                        case 2: {
                            result = new DataSetBuilder(rank, 100, qube[0]);
                            break block15;
                        }
                        case 3: {
                            result = new DataSetBuilder(rank, 100, qube[0], qube[1]);
                            break block15;
                        }
                        default: {
                            throw new IllegalArgumentException("rank limit");
                        }
                    }
                }
                if (rank != qube.length + 2) break block17;
                switch (rank) {
                    case 2: {
                        result = new DataSetBuilder(rank - 1, 100);
                        break block15;
                    }
                    case 3: {
                        result = new DataSetBuilder(rank - 1, 100, qube[0]);
                        break block15;
                    }
                    default: {
                        throw new IllegalArgumentException("rank limit");
                    }
                }
            }
            throw new IllegalArgumentException("rank and qube don't reconcile");
        }
        return result;
    }

    @Override
    public void streamDescriptor(StreamDescriptor sd) throws StreamException {
        try {
            Element e = sd.getDomElement();
            this.dsname = this.xpath.evaluate("//stream/@dataset_id", e);
        }
        catch (XPathExpressionException ex) {
            Logger.getLogger(QDataSetStreamHandler.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    private DDataSet doInLine(Element vn) throws XPathExpressionException {
        double[] data;
        String svals = this.xpath.evaluate("@values", vn).trim();
        String sdims = this.xpath.evaluate("@length", vn);
        String[] ss = svals.split(",");
        int[] dims = sdims == null || sdims.length() == 0 ? (svals.length() == 0 ? new int[]{} : new int[]{ss.length}) : Util.decodeArray(sdims);
        int total = dims[0];
        for (int i = 1; i < dims.length; ++i) {
            total *= dims[i];
        }
        if (svals != null && !svals.trim().equals("")) {
            data = new double[total];
            if (total != ss.length) {
                throw new IllegalArgumentException("number of elements inline doesn't match length");
            }
            for (int j = 0; j < total; ++j) {
                data[j] = Double.parseDouble(ss[j]);
            }
        } else {
            if (total > 0) {
                throw new IllegalArgumentException("nonzero length but no inline elements");
            }
            data = new double[]{};
        }
        DDataSet result = DDataSet.wrap((double[])data, (int[])dims);
        return result;
    }

    @Override
    public void packetDescriptor(PacketDescriptor pd) throws StreamException {
        try {
            Element e = pd.getDomElement();
            XPathExpression expr = this.xpath.compile("/packet/qdataset");
            Object o = expr.evaluate(e, XPathConstants.NODESET);
            NodeList nodes = (NodeList)o;
            for (int i = 0; i < nodes.getLength(); ++i) {
                Element n = (Element)nodes.item(i);
                String name = n.getAttribute("id");
                int rank = Integer.parseInt(n.getAttribute("rank"));
                DataSetBuilder builder = null;
                String sdims = null;
                int[] dims = null;
                String ttype = null;
                String joinChildren = null;
                String joinParent = null;
                boolean isInline = false;
                joinParent = n.getAttribute("joinId");
                NodeList values = (NodeList)this.xpath.evaluate("values", n, XPathConstants.NODESET);
                if (values.getLength() == 0) {
                    throw new IllegalArgumentException("no values node in " + n.getNodeName() + " " + n.getAttribute("id"));
                }
                for (int iv = 0; iv < values.getLength(); ++iv) {
                    Element vn = (Element)values.item(iv);
                    DDataSet inlineDs = null;
                    if (vn.hasAttribute("values")) {
                        inlineDs = this.doInLine(vn);
                        isInline = true;
                    }
                    sdims = this.xpath.evaluate("@length", vn);
                    ttype = this.xpath.evaluate("@encoding", vn);
                    joinChildren = this.xpath.evaluate("@join", vn);
                    dims = sdims == null ? new int[]{} : Util.decodeArray(sdims);
                    if (isInline && inlineDs.rank() < rank) {
                        JoinDataSet join = this.joinDataSets.get(name);
                        if (join == null) {
                            join = new JoinDataSet(rank);
                            this.joinDataSets.put(name, join);
                        }
                        join.join((QDataSet)inlineDs);
                        builder = new DataSetBuilder(0, 0);
                        this.builders.put(name, builder);
                        continue;
                    }
                    if (isInline && inlineDs.rank() == rank) {
                        builder = new DataSetBuilder(rank, inlineDs.length());
                        for (int j = 0; j < inlineDs.length(); ++j) {
                            DDataSet slice = (DDataSet)inlineDs.slice(j);
                            builder.putValues(-1, slice, DataSetUtil.totalLength((QDataSet)slice));
                            builder.nextRecord();
                        }
                        this.builders.put(name, builder);
                        continue;
                    }
                    if (joinChildren.length() > 0) {
                        JoinDataSet join = this.joinDataSets.get(name);
                        if (join == null) {
                            join = new JoinDataSet(rank);
                            this.joinDataSets.put(name, join);
                        }
                        builder = new DataSetBuilder(1, 10);
                        builder.putProperty(BUILDER_JOIN_CHILDREN, (Object)joinChildren);
                        this.builders.put(name, builder);
                        continue;
                    }
                    builder = this.builders.get(name);
                    if (builder == null) {
                        builder = this.createBuilder(rank, dims);
                        this.builders.put(name, builder);
                        continue;
                    }
                    JoinDataSet join = joinParent.equals("") ? this.joinDataSets.get(name) : this.joinDataSets.get(joinParent);
                    if (join == null) {
                        join = new JoinDataSet(rank);
                        this.joinDataSets.put(name, join);
                    }
                    MutablePropertyDataSet mds = this.resolveProps((MutablePropertyDataSet)builder.getDataSet());
                    join.join((QDataSet)mds);
                    builder = this.createBuilder(rank, dims);
                    this.builders.put(name, builder);
                }
                NodeList odims = (NodeList)this.xpath.evaluate("properties[not(@index)]/property", n, XPathConstants.NODESET);
                QDataSetStreamHandler.doProps(odims, builder);
                odims = (NodeList)this.xpath.evaluate("properties[@index]/property", n, XPathConstants.NODESET);
                QDataSetStreamHandler.doPropsIndex(odims, this.joinDataSets.get(name));
                PlaneDescriptor planeDescriptor = new PlaneDescriptor();
                planeDescriptor.setRank(rank);
                planeDescriptor.setQube(dims);
                boolean isStream = rank > dims.length;
                pd.setStream(isStream);
                pd.setStreamRank(rank - dims.length);
                TransferType tt = TransferType.getForName(ttype, builder.getProperties());
                if (tt == null && isInline) {
                    tt = new AsciiTransferType(10, true);
                }
                if (tt == null && joinChildren != null && joinChildren.length() > 0) {
                    tt = new AsciiTransferType(10, true);
                }
                if (tt == null) {
                    throw new IllegalArgumentException("unrecognized transfer type: " + ttype);
                }
                planeDescriptor.setType(tt);
                planeDescriptor.setName(name);
                planeDescriptor.setBuilder(builder);
                pd.addPlane(planeDescriptor);
            }
        }
        catch (XPathExpressionException ex) {
            Logger.getLogger(QDataSetStreamHandler.class.getName()).log(Level.SEVERE, null, ex);
            throw new RuntimeException(ex);
        }
    }

    private MutablePropertyDataSet resolveProps(MutablePropertyDataSet result) {
        String s;
        int i;
        for (i = 0; i < 4; ++i) {
            s = (String)result.property("DEPEND_" + i);
            if (s == null) continue;
            result.putProperty("DEPEND_" + i, (Object)this.getDataSet(s));
        }
        for (i = 0; i < 4; ++i) {
            s = (String)result.property("BUNDLE_" + i);
            if (s == null) continue;
            result.putProperty("BUNDLE_" + i, (Object)this.getDataSet(s));
        }
        for (i = 0; i < 50 && (s = (String)result.property("PLANE_" + i)) != null; ++i) {
            result.putProperty("PLANE_" + i, (Object)this.getDataSet(s));
        }
        return result;
    }

    @Override
    public void packet(PacketDescriptor pd, ByteBuffer data) throws StreamException {
        if (this.readPackets) {
            for (PlaneDescriptor planeDescriptor : pd.planes) {
                DataSetBuilder builder = planeDescriptor.getBuilder();
                if (planeDescriptor.getElements() > 1) {
                    DDataSet rec = DDataSet.createRank1((int)planeDescriptor.getElements());
                    for (int ii = 0; ii < planeDescriptor.getElements(); ++ii) {
                        rec.putValue(ii, planeDescriptor.getType().read(data));
                    }
                    if (!pd.isStream()) {
                        if (planeDescriptor.getRank() > 1) {
                            throw new IllegalArgumentException("non-streaming and rank>1 not supported");
                        }
                        for (int i = 0; i < rec.length(); ++i) {
                            builder.putValue(-1, rec.value(i));
                            builder.nextRecord();
                        }
                        continue;
                    }
                    builder.putValues(-1, rec, planeDescriptor.getElements());
                    builder.nextRecord();
                    continue;
                }
                builder.putValue(-1, planeDescriptor.getType().read(data));
                builder.nextRecord();
            }
        }
    }

    @Override
    public void streamClosed(StreamDescriptor sd) throws StreamException {
    }

    @Override
    public void streamException(StreamException se) throws StreamException {
    }

    public QDataSet getDataSet(String name) {
        DDataSet result;
        System.err.println("getDataSet(" + name + ")");
        DataSetBuilder builder = this.builders.get(name);
        if (builder == null) {
            throw new IllegalArgumentException("No such dataset \"" + name + "\"");
        }
        JoinDataSet join = this.joinDataSets.get(name);
        Object sliceDs = null;
        if (join != null) {
            if (builder.rank() > 0) {
                sliceDs = builder.getDataSet();
                if (sliceDs.property(BUILDER_JOIN_CHILDREN) != null) {
                    String joinChild = (String)sliceDs.property(BUILDER_JOIN_CHILDREN);
                    DataSetBuilder childBuilder = this.builders.get(joinChild);
                    sliceDs = childBuilder != null ? childBuilder.getDataSet() : null;
                }
                if (sliceDs != null) {
                    join.join((QDataSet)sliceDs);
                }
            } else {
                DataSetUtil.putProperties((Map)builder.getProperties(), (MutablePropertyDataSet)join);
                sliceDs = (MutablePropertyDataSet)join.slice(join.length() - 1);
            }
            result = join;
        } else {
            result = builder.getDataSet();
        }
        if (join != null) {
            if (sliceDs != null) {
                this.resolveProps((MutablePropertyDataSet)sliceDs);
            }
        } else {
            this.resolveProps((MutablePropertyDataSet)result);
        }
        return result;
    }

    public QDataSet getDataSet() {
        return this.getDataSet(this.dsname);
    }

    public void setReadPackets(boolean val) {
        this.readPackets = val;
    }

    public boolean getReadPackets() {
        return this.readPackets;
    }

    private static void doProps(NodeList odims, DataSetBuilder builder) {
        for (int j = 0; j < odims.getLength(); ++j) {
            String stype;
            Element n2 = (Element)odims.item(j);
            String pname = n2.getAttribute("name");
            if (pname.equals("USER_PROPERTIES")) {
                // empty if block
            }
            String svalue = n2.hasAttribute("value") ? n2.getAttribute("value") : n2.getTextContent();
            Element evalue = null;
            if (n2.hasAttribute("type")) {
                stype = n2.getAttribute("type");
            } else {
                evalue = Util.singletonChildElement(n2);
                stype = evalue.getTagName();
            }
            if (stype.equals("qdataset")) {
                if (pname.equals("DELTA_MINUS") || pname.equals("DELTA_PLUS")) {
                    System.err.println("skipping DELTA_MINUS and DELTA_PLUS because bug");
                    continue;
                }
                builder.putProperty(pname, (Object)svalue);
                continue;
            }
            SerializeDelegate delegate = SerializeRegistry.getByName(stype);
            if (delegate == null) {
                Logger.getLogger(QDataSetStreamHandler.class.getName()).log(Level.SEVERE, "no delegate found for \"" + stype + "\"");
                continue;
            }
            try {
                Object oval = evalue != null && delegate instanceof XMLSerializeDelegate ? ((XMLSerializeDelegate)((Object)delegate)).xmlParse(evalue) : delegate.parse(stype, svalue);
                builder.putProperty(pname, oval);
                continue;
            }
            catch (ParseException ex) {
                Logger.getLogger(QDataSetStreamHandler.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }

    private static void doPropsIndex(NodeList odims, JoinDataSet join) {
        for (int j = 0; j < odims.getLength(); ++j) {
            String stype;
            Element n2 = (Element)odims.item(j);
            String sidx = ((Element)n2.getParentNode()).getAttribute("index");
            int index = Integer.parseInt(sidx);
            String pname = n2.getAttribute("name");
            if (pname.equals("USER_PROPERTIES")) {
                // empty if block
            }
            String svalue = n2.hasAttribute("value") ? n2.getAttribute("value") : n2.getTextContent();
            Element evalue = null;
            if (n2.hasAttribute("type")) {
                stype = n2.getAttribute("type");
            } else {
                evalue = Util.singletonChildElement(n2);
                stype = evalue.getTagName();
            }
            if (stype.equals("qdataset")) {
                join.putProperty(pname, index, (Object)svalue);
                continue;
            }
            SerializeDelegate delegate = SerializeRegistry.getByName(stype);
            if (delegate == null) {
                Logger.getLogger(QDataSetStreamHandler.class.getName()).log(Level.SEVERE, "no delegate found for \"" + stype + "\"");
                continue;
            }
            try {
                Object oval = evalue != null && delegate instanceof XMLSerializeDelegate ? ((XMLSerializeDelegate)((Object)delegate)).xmlParse(evalue) : delegate.parse(stype, svalue);
                join.putProperty(pname, index, oval);
                continue;
            }
            catch (ParseException ex) {
                Logger.getLogger(QDataSetStreamHandler.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }
}

