/*
 * Decompiled with CFR 0.152.
 */
package org.virbo.qstream;

import java.text.ParseException;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.das2.datum.Datum;
import org.das2.datum.Units;
import org.virbo.dataset.DRank0DataSet;
import org.virbo.dataset.DataSetUtil;
import org.virbo.dataset.QDataSet;
import org.virbo.dataset.RankZeroDataSet;
import org.virbo.qstream.SerializeDelegate;
import org.virbo.qstream.SerializeRegistry;

public class Rank0DataSetSerializeDelegate
implements SerializeDelegate {
    public String format(Object o) {
        Datum d;
        String svalue;
        QDataSet ds = (QDataSet)o;
        if (ds.rank() > 0) {
            throw new IllegalArgumentException("rank>0 in Rank0DataSetSerializeDelegate");
        }
        Map props = DataSetUtil.getProperties((QDataSet)ds);
        Units u = (Units)ds.property("UNITS");
        if (u == null) {
            u = Units.dimensionless;
        }
        if ((svalue = (d = DataSetUtil.asDatum((QDataSet)ds)).getFormatter().format(d, u)).contains(" ")) {
            throw new RuntimeException("formatted value contains string");
        }
        StringBuffer sb = new StringBuffer(d.getFormatter().format(d, d.getUnits()));
        for (Map.Entry e : props.entrySet()) {
            Object value = e.getValue();
            SerializeDelegate sd = SerializeRegistry.getDelegate(value.getClass());
            if (sd == null || value instanceof RankZeroDataSet) continue;
            sb.append(" " + sd.typeId(value.getClass()) + ":" + (String)e.getKey() + "=" + sd.format(value));
        }
        return sb.toString();
    }

    public Object parse(String typeId, String s) throws ParseException {
        int i = (s = s.trim()).indexOf(" ");
        if (i == -1) {
            return DataSetUtil.asDataSet((double)Double.parseDouble(s));
        }
        String svalue = s.substring(0, i);
        String smeta = s.substring(i + 1);
        Pattern p = Pattern.compile("\\s*(\\S+)\\:([A-Z]+)=(\\S+)");
        Matcher m = p.matcher(smeta);
        LinkedHashMap<String, Object> props = new LinkedHashMap<String, Object>();
        while (m.find()) {
            String proptype = m.group(1);
            String propname = m.group(2);
            String propsvalue = m.group(3);
            SerializeDelegate sd = SerializeRegistry.getByName(proptype);
            Object value = sd.parse(proptype, propsvalue);
            props.put(propname, value);
        }
        Units u = (Units)props.get("UNITS");
        if (u == null) {
            u = Units.dimensionless;
        }
        DRank0DataSet result = u == Units.dimensionless ? DRank0DataSet.create((Datum)u.parse(svalue)) : DRank0DataSet.create((double)u.parse(svalue).doubleValue(u), (Units)u);
        for (Map.Entry e : props.entrySet()) {
            if (!((String)e.getKey()).equals("UNITS")) continue;
            result.putProperty((String)e.getKey(), e.getValue());
        }
        return result;
    }

    public String typeId(Class clas) {
        return "rank0dataset";
    }
}

