/*
 * Decompiled with CFR 0.152.
 */
package org.virbo.qstream;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.Channels;
import java.nio.channels.WritableByteChannel;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.das2.datum.Datum;
import org.das2.datum.EnumerationUnits;
import org.das2.datum.TimeLocationUnits;
import org.das2.datum.TimeUtil;
import org.das2.datum.Units;
import org.das2.datum.UnitsUtil;
import org.virbo.dataset.DataSetOps;
import org.virbo.dataset.DataSetUtil;
import org.virbo.dataset.MutablePropertyDataSet;
import org.virbo.dataset.QDataSet;
import org.virbo.dataset.QubeDataSetIterator;
import org.virbo.dataset.RankZeroDataSet;
import org.virbo.dataset.SemanticOps;
import org.virbo.dataset.Slice0DataSet;
import org.virbo.dsops.Ops;
import org.virbo.qstream.AsciiIntegerTransferType;
import org.virbo.qstream.AsciiTimeTransferType;
import org.virbo.qstream.AsciiTransferType;
import org.virbo.qstream.DoubleTransferType;
import org.virbo.qstream.FloatTransferType;
import org.virbo.qstream.IntegerTransferType;
import org.virbo.qstream.PacketDescriptor;
import org.virbo.qstream.PlaneDescriptor;
import org.virbo.qstream.SerializeDelegate;
import org.virbo.qstream.SerializeRegistry;
import org.virbo.qstream.StreamDescriptor;
import org.virbo.qstream.StreamException;
import org.virbo.qstream.TransferType;
import org.virbo.qstream.Util;
import org.virbo.qstream.XMLSerializeDelegate;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class SimpleStreamFormatter {
    Map<PlaneDescriptor, QDataSet> planeToDataSet;
    boolean asciiTypes = true;
    boolean isBigEndian = true;
    private static final Logger logger = Logger.getLogger("autoplot.qstream");
    Map<QDataSet, String> names = new HashMap<QDataSet, String>();
    Map<QDataSet, String> joinDataSets = new HashMap<QDataSet, String>();

    Document getNewDocument() {
        try {
            DocumentBuilder builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            return builder.newDocument();
        }
        catch (ParserConfigurationException pce) {
            throw new RuntimeException(pce);
        }
    }

    Element getPacketElement(Document document) {
        Element packet = document.createElement("packet");
        return packet;
    }

    private void doValuesElement(QDataSet ds, PacketDescriptor pd, PlaneDescriptor planeDescriptor, Document document, Element qdatasetElement) throws DOMException {
        QDataSet bundleDescriptor;
        Object sunits = ds.property("UNITS");
        if (sunits != null && !(sunits instanceof Units)) {
            throw new IllegalArgumentException("UNITS property doesn't contain type units, it's type " + sunits.getClass() + ": " + sunits);
        }
        boolean highResKludge = false;
        Units u = (Units)sunits;
        if (u == null && this.isBundle(ds) && ds.rank() == 2 && (bundleDescriptor = (QDataSet)ds.property("BUNDLE_1")) != null) {
            for (int i = 0; i < bundleDescriptor.length(); ++i) {
                Units u1 = (Units)bundleDescriptor.property("UNITS", i);
                if (u1 == null || !UnitsUtil.isTimeLocation((Units)u1)) continue;
                highResKludge = true;
                System.err.println("using high res kludge to format bundle dataset that contains " + u1);
            }
        }
        if (!pd.isValuesInDescriptor()) {
            if (this.asciiTypes) {
                double min = Double.POSITIVE_INFINITY;
                double max = Double.NEGATIVE_INFINITY;
                double absMin = Double.MAX_VALUE;
                double maxFp = 0.0;
                double minFp = 1.0;
                QubeDataSetIterator it = new QubeDataSetIterator(ds);
                while (it.hasNext()) {
                    double dd;
                    double fp;
                    it.next();
                    double d = it.getValue(ds);
                    if (d < min) {
                        min = d;
                    }
                    if ((fp = (dd = Math.abs(d)) - (double)((long)dd)) > maxFp) {
                        maxFp = fp;
                    }
                    if (fp > 0.0 && fp < minFp) {
                        minFp = fp;
                    }
                    if (dd > 0.0 && dd < absMin) {
                        absMin = dd;
                    }
                    if (!(d > max)) continue;
                    max = d;
                }
                if (u instanceof EnumerationUnits) {
                    planeDescriptor.setType(new AsciiIntegerTransferType(10));
                } else if (u instanceof TimeLocationUnits) {
                    AsciiTimeTransferType att = this.getTT(ds);
                    planeDescriptor.setType(att);
                } else if (highResKludge) {
                    planeDescriptor.setType(new AsciiTransferType(18, true));
                } else if (maxFp == 0.0 && min > -1.0E8 && max < 1.0E8) {
                    planeDescriptor.setType(new AsciiIntegerTransferType(10));
                } else if (min > -10000.0 && max < 10000.0 && absMin > 1.0E-4) {
                    planeDescriptor.setType(new AsciiTransferType(10, false));
                } else if (min > -100000.0 && max < 100000.0 && minFp == 0.5 && maxFp == 0.5) {
                    planeDescriptor.setType(new AsciiTransferType(10, false));
                } else if (absMin > 1.0E-100 && max < 1.0E100) {
                    planeDescriptor.setType(new AsciiTransferType(10, true));
                } else {
                    planeDescriptor.setType(new AsciiTransferType(12, true));
                }
            } else if (highResKludge) {
                planeDescriptor.setType(new DoubleTransferType());
            } else if (u instanceof EnumerationUnits) {
                planeDescriptor.setType(new IntegerTransferType());
            } else if (u instanceof TimeLocationUnits) {
                planeDescriptor.setType(new DoubleTransferType());
            } else {
                planeDescriptor.setType(new FloatTransferType());
            }
        }
        if (pd.isValuesInDescriptor() && ds.rank() == 2) {
            for (int i = 0; i < ds.length(); ++i) {
                Element values = this.doValues(document, pd, planeDescriptor, (QDataSet)DataSetOps.slice0((QDataSet)ds, (int)i));
                values.setAttribute("index", String.valueOf(i));
                qdatasetElement.appendChild(values);
            }
        } else {
            Element values = this.doValues(document, pd, planeDescriptor, ds);
            qdatasetElement.appendChild(values);
        }
    }

    private int timeDigits(QDataSet ds) {
        Units u = SemanticOps.getUnits((QDataSet)ds);
        double micros = UnitsUtil.isTimeLocation((Units)u) ? TimeUtil.getMicroSecondsSinceMidnight((Datum)DataSetUtil.asDatum((RankZeroDataSet)((RankZeroDataSet)ds))) : DataSetUtil.value((RankZeroDataSet)((RankZeroDataSet)ds), (Units)Units.microseconds);
        if (micros == 0.0 || micros >= 6.0E7 && micros % 6.0E7 < 0.1) {
            return 17;
        }
        if (micros >= 1000000.0 && micros % 1000000.0 < 0.001) {
            return 20;
        }
        if (micros >= 1000.0 && micros % 1000.0 < 0.1) {
            return 24;
        }
        if (micros >= 1.0 && micros % 1.0 < 0.001) {
            return 27;
        }
        return 30;
    }

    private AsciiTimeTransferType getTT(QDataSet ds) {
        Units u = SemanticOps.getUnits((QDataSet)ds);
        int timeDigits = this.timeDigits((QDataSet)DataSetOps.slice0((QDataSet)ds, (int)0));
        QDataSet gcd = null;
        try {
            QDataSet diffs = Ops.subtract((QDataSet)ds, (QDataSet)DataSetOps.slice0((QDataSet)ds, (int)0));
            gcd = DataSetUtil.gcd((QDataSet)diffs, (QDataSet)DataSetUtil.asDataSet((double)1.0, (Units)Units.picoseconds));
        }
        catch (IllegalArgumentException ex) {
            gcd = null;
        }
        if (gcd == null) {
            return new AsciiTimeTransferType(timeDigits, u);
        }
        int timeDigitsGcd = this.timeDigits(gcd);
        return new AsciiTimeTransferType(Math.max(timeDigits, timeDigitsGcd), u);
    }

    private PlaneDescriptor doPlaneDescriptor(Document document, PacketDescriptor pd, QDataSet ds, int streamRank) {
        Element qdatasetElement = document.createElement("qdataset");
        qdatasetElement.setAttribute("id", this.nameFor(ds));
        logger.log(Level.FINE, "writing qdataset {0}", this.nameFor(ds));
        if (this.isJoin(ds)) {
            qdatasetElement.setAttribute("rank", "" + ds.rank());
        } else {
            qdatasetElement.setAttribute("rank", "" + (ds.rank() + (streamRank - 1)));
        }
        if (this.isBundle(ds)) {
            QDataSet bds = ds.rank() == 1 ? (QDataSet)ds.property("BUNDLE_0") : (QDataSet)ds.property("BUNDLE_1");
            if (bds == null) {
                for (int i = 0; i < ds.length(); ++i) {
                    MutablePropertyDataSet ds1 = DataSetOps.slice0((QDataSet)ds, (int)i);
                    Element props = this.doProperties(document, (QDataSet)ds1);
                    props.setAttribute("index", String.valueOf(i));
                    qdatasetElement.appendChild(props);
                }
            }
        } else if (this.isJoin(ds)) {
            Element values = document.createElement("values");
            String sliceName = this.nameFor(ds.slice(0));
            for (int i = 0; i < ds.length(); ++i) {
                this.setNameFor(ds.slice(i), sliceName);
            }
            values.setAttribute("join", sliceName);
            qdatasetElement.appendChild(values);
        }
        Element props = this.doProperties(document, ds);
        qdatasetElement.appendChild(props);
        PlaneDescriptor planeDescriptor = new PlaneDescriptor();
        planeDescriptor.setRank(ds.rank());
        if (!this.isJoin(ds)) {
            int[] qube = DataSetUtil.qubeDims((QDataSet)ds);
            if (!pd.valuesInDescriptor) {
                if (pd.isStream()) {
                    planeDescriptor.setQube(Util.subArray(qube, 1, qube.length - 1));
                } else {
                    planeDescriptor.setQube(qube);
                }
            } else if (ds.length() == 0) {
                System.err.println("here");
            }
        }
        planeDescriptor.setDs(ds);
        planeDescriptor.setName(this.nameFor(ds));
        if (!this.isJoin(ds)) {
            this.doValuesElement(ds, pd, planeDescriptor, document, qdatasetElement);
        }
        planeDescriptor.setDomElement(qdatasetElement);
        return planeDescriptor;
    }

    private boolean isBundle(QDataSet ds) {
        if (ds.property("BUNDLE_0") != null) {
            return true;
        }
        if (ds.property("BUNDLE_1") != null) {
            return true;
        }
        return ds.property("NAME", 0) != null && ds.property("NAME", 0) != ds.property("NAME");
    }

    private boolean isJoin(QDataSet ds) {
        return ds.property("JOIN_0") != null;
    }

    private Element doProperties(Document document, QDataSet ds) {
        Element properties = document.createElement("properties");
        Map props = DataSetUtil.getProperties((QDataSet)ds);
        for (String name : props.keySet()) {
            Element prop = null;
            Object value = props.get(name);
            if (value instanceof QDataSet) {
                QDataSet qds = (QDataSet)value;
                String sliceName = (String)qds.property("NAME");
                if (ds instanceof Slice0DataSet && sliceName != null && sliceName.startsWith("slice")) continue;
                prop = document.createElement("property");
                prop.setAttribute("name", name);
                if (qds.rank() == 0) {
                    SerializeDelegate r0d = SerializeRegistry.getByName("rank0dataset");
                    prop.setAttribute("type", "rank0dataset");
                    Units u = (Units)qds.property("UNITS");
                    if (u != null && u instanceof EnumerationUnits) continue;
                    prop.setAttribute("value", r0d.format(value));
                } else {
                    prop.setAttribute("type", "qdataset");
                    prop.setAttribute("value", this.nameFor((QDataSet)value));
                }
            } else {
                SerializeDelegate sd = SerializeRegistry.getDelegate(value.getClass());
                if (sd == null) {
                    System.err.println("dropping " + name + " because unsupported type: " + value.getClass());
                } else {
                    prop = document.createElement("property");
                    prop.setAttribute("name", name);
                    if (sd instanceof XMLSerializeDelegate) {
                        prop.appendChild(((XMLSerializeDelegate)((Object)sd)).xmlFormat(document, value));
                    } else {
                        prop.setAttribute("type", sd.typeId(value.getClass()));
                        prop.setAttribute("value", sd.format(value));
                    }
                }
            }
            if (prop == null) continue;
            properties.appendChild(prop);
        }
        return properties;
    }

    private StreamDescriptor doStreamDescriptor(QDataSet ds) throws ParserConfigurationException {
        StreamDescriptor sd = new StreamDescriptor(DocumentBuilderFactory.newInstance());
        Document document = sd.newDocument(sd);
        Element streamElement = document.createElement("stream");
        String name = this.nameFor(ds);
        streamElement.setAttribute("dataset_id", name);
        if (!this.asciiTypes) {
            streamElement.setAttribute("byte_order", this.isBigEndian ? "big_endian" : "little_endian");
        }
        sd.setDomElement(streamElement);
        sd.addDescriptor(sd);
        return sd;
    }

    private Element doValues(Document document, PacketDescriptor packetDescriptor, PlaneDescriptor planeDescriptor, QDataSet ds) {
        Element values = document.createElement("values");
        int[] qubeDims = null;
        if (!packetDescriptor.isValuesInDescriptor()) {
            values.setAttribute("encoding", planeDescriptor.getType().name());
            qubeDims = DataSetUtil.qubeDims((QDataSet)ds);
        }
        if (packetDescriptor.isStream()) {
            if (ds.rank() > 1) {
                values.setAttribute("length", Util.encodeArray(qubeDims, 1, qubeDims.length - 1));
            } else {
                values.setAttribute("length", "");
            }
        } else {
            if (qubeDims != null) {
                values.setAttribute("length", Util.encodeArray(qubeDims, 0, qubeDims.length));
            }
            if (packetDescriptor.isValuesInDescriptor()) {
                StringBuilder s = new StringBuilder("");
                for (int i = 0; i < ds.length(); ++i) {
                    s.append(",").append(ds.value(i));
                }
                values.setAttribute("values", ds.length() == 0 ? "" : s.substring(1));
                if (ds.length() == 0) {
                    values.setAttribute("length", "0");
                }
            }
        }
        return values;
    }

    private void formatPackets(WritableByteChannel channel, StreamDescriptor sd, PacketDescriptor pd) throws IOException {
        int bufferSize = 4 + pd.sizeBytes();
        byte[] bbuf = new byte[bufferSize];
        ByteBuffer buffer = ByteBuffer.wrap(bbuf);
        if (this.isBigEndian) {
            buffer.order(ByteOrder.BIG_ENDIAN);
        } else {
            buffer.order(ByteOrder.LITTLE_ENDIAN);
        }
        String packetTag = String.format(":%02d:", sd.descriptorId(pd));
        buffer.put(packetTag.getBytes());
        if (pd.isStream()) {
            int packetCount = pd.planes.get(0).getDs().length();
            int planeCount = pd.planes.size();
            for (int i = 0; i < packetCount; ++i) {
                for (int iplane = 0; iplane < planeCount; ++iplane) {
                    boolean lastPlane;
                    PlaneDescriptor plane = pd.planes.get(iplane);
                    TransferType tt = plane.getType();
                    QDataSet planeds = plane.getDs();
                    boolean bl = lastPlane = iplane == planeCount - 1;
                    if (planeds.rank() == 1) {
                        tt.write(planeds.value(i), buffer);
                    } else if (planeds.rank() == 2) {
                        for (int j = 0; j < planeds.length(i); ++j) {
                            tt.write(planeds.value(i, j), buffer);
                        }
                    } else {
                        MutablePropertyDataSet slice = DataSetOps.slice0((QDataSet)planeds, (int)i);
                        QubeDataSetIterator it = new QubeDataSetIterator((QDataSet)slice);
                        while (it.hasNext()) {
                            it.next();
                            tt.write(it.getValue((QDataSet)slice), buffer);
                        }
                    }
                    if (!lastPlane || !tt.isAscii() || !Character.isWhitespace(buffer.get(bufferSize - 1))) continue;
                    buffer.put(bufferSize - 1, (byte)10);
                }
                buffer.flip();
                channel.write(buffer);
                buffer.position(4);
            }
            buffer.flip();
        } else {
            int planeCount = pd.planes.size();
            for (int iplane = 0; iplane < planeCount; ++iplane) {
                boolean lastPlane;
                PlaneDescriptor plane = pd.planes.get(iplane);
                TransferType tt = plane.getType();
                QDataSet planeds = plane.getDs();
                QubeDataSetIterator it = new QubeDataSetIterator(planeds);
                while (it.hasNext()) {
                    it.next();
                    tt.write(it.getValue(planeds), buffer);
                }
                boolean bl = lastPlane = iplane == planeCount - 1;
                if (!lastPlane || !tt.isAscii() || !Character.isWhitespace(buffer.get(bufferSize - 1))) continue;
                buffer.put(bufferSize - 1, (byte)10);
            }
            buffer.flip();
            channel.write(buffer);
            buffer.flip();
        }
    }

    private synchronized void setNameFor(QDataSet slice, String name) {
        if (name.equals(this.names.get(slice))) {
            return;
        }
        if (this.names.get(slice) != null) {
            throw new IllegalArgumentException("already have name for: " + slice + "  want to set to " + name);
        }
        this.maybePutName(slice, name);
    }

    private synchronized String nameFor(QDataSet dep0) {
        boolean assignName;
        String name = this.names.get(dep0);
        boolean bl = assignName = name == null;
        if (name == null) {
            name = (String)dep0.property("NAME");
        }
        if (name == null) {
            name = "ds_" + this.names.size();
        }
        if (assignName) {
            this.maybePutName(dep0, name);
        }
        return name;
    }

    PacketDescriptor doPacketDescriptorNonQube(StreamDescriptor sd, QDataSet ds, boolean stream, boolean valuesInDescriptor, int streamRank) throws ParserConfigurationException {
        QDataSet plane0;
        PacketDescriptor packetDescriptor = new PacketDescriptor();
        packetDescriptor.setStream(stream);
        packetDescriptor.setStreamRank(streamRank);
        if (valuesInDescriptor) {
            packetDescriptor.setValuesInDescriptor(true);
        }
        Document document = sd.newDocument(packetDescriptor);
        Element packetElement = this.getPacketElement(document);
        QDataSet dep0 = (QDataSet)ds.property("DEPEND_0");
        if (dep0 != null) {
            PlaneDescriptor planeDescriptor = this.doPlaneDescriptor(document, packetDescriptor, dep0, streamRank);
            packetDescriptor.addPlane(planeDescriptor);
            packetElement.appendChild(planeDescriptor.getDomElement());
        }
        for (int i = 0; i < 50 && (plane0 = (QDataSet)ds.property("PLANE_" + i)) != null; ++i) {
            PlaneDescriptor planeDescriptor = this.doPlaneDescriptor(document, packetDescriptor, plane0, streamRank);
            packetDescriptor.addPlane(planeDescriptor);
            packetElement.appendChild(planeDescriptor.getDomElement());
        }
        PlaneDescriptor planeDescriptor = this.doPlaneDescriptor(document, packetDescriptor, ds, streamRank);
        packetDescriptor.addPlane(planeDescriptor);
        packetElement.appendChild(planeDescriptor.getDomElement());
        packetDescriptor.setDomElement(packetElement);
        return packetDescriptor;
    }

    PacketDescriptor doPacketDescriptorJoin(StreamDescriptor sd, QDataSet ds, boolean stream, boolean valuesInDescriptor, int streamRank) throws ParserConfigurationException {
        PacketDescriptor packetDescriptor = new PacketDescriptor();
        packetDescriptor.setStream(stream);
        packetDescriptor.setStreamRank(streamRank);
        if (valuesInDescriptor) {
            packetDescriptor.setValuesInDescriptor(true);
        }
        Document document = sd.newDocument(packetDescriptor);
        Element packetElement = this.getPacketElement(document);
        Object join = ds.property("JOIN_0");
        if (join == null) {
            throw new IllegalArgumentException("expected join");
        }
        PlaneDescriptor planeDescriptor = this.doPlaneDescriptor(document, packetDescriptor, ds, streamRank);
        packetDescriptor.addPlane(planeDescriptor);
        packetElement.appendChild(planeDescriptor.getDomElement());
        packetDescriptor.setDomElement(packetElement);
        return packetDescriptor;
    }

    PacketDescriptor doPacketDescriptor(StreamDescriptor sd, QDataSet ds, boolean stream, boolean valuesInDescriptor, int streamRank, String joinId) throws ParserConfigurationException {
        QDataSet plane0;
        if (!valuesInDescriptor && !DataSetUtil.isQube((QDataSet)ds)) {
            throw new IllegalArgumentException("must be qube!");
        }
        PacketDescriptor packetDescriptor = new PacketDescriptor();
        packetDescriptor.setStream(stream);
        packetDescriptor.setStreamRank(streamRank);
        if (valuesInDescriptor) {
            packetDescriptor.setValuesInDescriptor(true);
        }
        Document document = sd.newDocument(packetDescriptor);
        Element packetElement = this.getPacketElement(document);
        QDataSet dep0 = (QDataSet)ds.property("DEPEND_0");
        if (dep0 != null) {
            PlaneDescriptor planeDescriptor = this.doPlaneDescriptor(document, packetDescriptor, dep0, streamRank);
            packetDescriptor.addPlane(planeDescriptor);
            packetElement.appendChild(planeDescriptor.getDomElement());
        }
        for (int i = 0; i < 50 && (plane0 = (QDataSet)ds.property("PLANE_" + i)) != null; ++i) {
            PlaneDescriptor planeDescriptor = this.doPlaneDescriptor(document, packetDescriptor, plane0, streamRank);
            packetDescriptor.addPlane(planeDescriptor);
            packetElement.appendChild(planeDescriptor.getDomElement());
        }
        PlaneDescriptor planeDescriptor = this.doPlaneDescriptor(document, packetDescriptor, ds, streamRank);
        packetDescriptor.addPlane(planeDescriptor);
        Element dselement = planeDescriptor.getDomElement();
        if (joinId != null) {
            dselement.setAttribute("joinId", joinId);
        }
        packetElement.appendChild(dselement);
        packetDescriptor.setDomElement(packetElement);
        return packetDescriptor;
    }

    public void format(QDataSet ds, OutputStream osout, boolean asciiTypes) throws StreamException, IOException {
        try {
            boolean isjoin;
            int streamRank;
            this.asciiTypes = asciiTypes;
            WritableByteChannel out = Channels.newChannel(osout);
            StreamDescriptor sd = this.doStreamDescriptor(ds);
            ArrayList probs = new ArrayList();
            if (!DataSetUtil.validate((QDataSet)ds, probs)) {
                throw new IllegalArgumentException("DataSet is not valid: " + (String)probs.get(0));
            }
            ArrayList<PacketDescriptor> depPackets = new ArrayList<PacketDescriptor>();
            sd.send(sd, out);
            int packetDescriptorCount = 1;
            String dep0Name = null;
            if (this.isBundle(ds) && asciiTypes) {
                System.err.println("suboptimal implementation doesn't use different formatters for each bundled dataset");
            }
            if (DataSetUtil.isQube((QDataSet)ds)) {
                packetDescriptorCount = 1;
                streamRank = 1;
            } else if (this.isJoin(ds)) {
                packetDescriptorCount = ds.length();
                streamRank = 1;
            } else {
                packetDescriptorCount = ds.length();
                streamRank = 2;
            }
            QDataSet dep0 = (QDataSet)ds.property("DEPEND_0");
            if (dep0 != null) {
                dep0Name = this.nameFor(dep0);
            }
            String joinDataSet = null;
            boolean bl = isjoin = ds.property("JOIN_0") != null;
            if (isjoin) {
                PacketDescriptor join = this.doPacketDescriptorJoin(sd, ds, false, false, streamRank);
                sd.addDescriptor(join);
                sd.send(join, out);
                joinDataSet = this.nameFor(ds);
            }
            for (int ipacket = 0; ipacket < packetDescriptorCount; ++ipacket) {
                PacketDescriptor pd;
                QDataSet depi;
                int i;
                QDataSet packetDs;
                ArrayList<PacketDescriptor> retire = new ArrayList<PacketDescriptor>();
                if (streamRank == 1 && !isjoin) {
                    packetDs = ds;
                } else {
                    packetDs = ds.slice(ipacket);
                    this.maybePutName(packetDs, this.nameFor(packetDs));
                    if (dep0Name != null) {
                        this.maybePutName((QDataSet)packetDs.property("DEPEND_0"), dep0Name);
                    }
                }
                if (this.isJoin(packetDs)) {
                    throw new IllegalArgumentException("join of join not supported");
                }
                PacketDescriptor mainPd = this.doPacketDescriptor(sd, packetDs, true, false, streamRank, joinDataSet);
                sd.addDescriptor(mainPd);
                for (i = 1; i < 4; ++i) {
                    depi = (QDataSet)packetDs.property("DEPEND_" + i);
                    if (depi == null) continue;
                    if (depi == dep0) {
                        throw new RuntimeException("bug in QStream prevents DEPEND_0==DEPEND_1");
                    }
                    boolean valuesInDescriptor = true;
                    pd = this.doPacketDescriptor(sd, depi, false, valuesInDescriptor, 1, null);
                    sd.addDescriptor(pd);
                    depPackets.add(pd);
                    sd.send(pd, out);
                    retire.add(pd);
                }
                for (i = 0; i < 2; ++i) {
                    depi = (QDataSet)packetDs.property("BUNDLE_" + i);
                    if (depi == null) continue;
                    ArrayList<QDataSet> retireBundleDep1 = new ArrayList<QDataSet>();
                    for (int j = 0; j < depi.length(); ++j) {
                        QDataSet b1;
                        QDataSet dep1 = (QDataSet)depi.property("DEPEND_1", j);
                        if (dep1 != null && !retireBundleDep1.contains(dep1)) {
                            pd = this.doPacketDescriptor(sd, dep1, false, true, 1, null);
                            sd.addDescriptor(pd);
                            depPackets.add(pd);
                            sd.send(pd, out);
                            retireBundleDep1.add(dep1);
                        }
                        if ((b1 = (QDataSet)depi.property("BUNDLE_1", j)) == null || retireBundleDep1.contains(b1)) continue;
                        pd = this.doPacketDescriptor(sd, b1, false, true, 1, null);
                        sd.addDescriptor(pd);
                        depPackets.add(pd);
                        sd.send(pd, out);
                        retireBundleDep1.add(b1);
                    }
                    boolean valuesInDescriptor = true;
                    pd = this.doPacketDescriptor(sd, depi, false, valuesInDescriptor, 1, null);
                    sd.addDescriptor(pd);
                    depPackets.add(pd);
                    sd.send(pd, out);
                    retire.add(pd);
                }
                sd.send(mainPd, out);
                for (PacketDescriptor deppd : depPackets) {
                    if (deppd.isValuesInDescriptor()) continue;
                    this.formatPackets(out, sd, deppd);
                }
                this.formatPackets(out, sd, mainPd);
                for (PacketDescriptor r : retire) {
                    sd.retireDescriptor(r);
                }
                sd.retireDescriptor(mainPd);
            }
        }
        catch (ParserConfigurationException ex) {
            throw new RuntimeException(ex);
        }
    }

    private void maybePutName(QDataSet packetDs, String nameFor) {
        if (!this.names.containsKey(packetDs)) {
            this.names.put(packetDs, nameFor);
        } else {
            System.err.println("already have name for " + packetDs);
        }
    }
}

