/*
 * Decompiled with CFR 0.152.
 */
package org.virbo.qstream;

import java.nio.ByteBuffer;
import java.util.Map;
import org.virbo.qstream.AsciiIntegerTransferType;
import org.virbo.qstream.AsciiTimeTransferType;
import org.virbo.qstream.AsciiTransferType;
import org.virbo.qstream.DoubleTransferType;
import org.virbo.qstream.FloatTransferType;
import org.virbo.qstream.IntegerTransferType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class TransferType {
    public static TransferType getForName(String ttype, Map<String, Object> properties) {
        TransferType tt = DoubleTransferType.getByName(ttype, properties);
        if (tt != null) {
            return tt;
        }
        tt = FloatTransferType.getByName(ttype, properties);
        if (tt != null) {
            return tt;
        }
        tt = IntegerTransferType.getByName(ttype, properties);
        if (tt != null) {
            return tt;
        }
        tt = AsciiTransferType.getByName(ttype, properties);
        if (tt != null) {
            return tt;
        }
        tt = AsciiIntegerTransferType.getByName(ttype, properties);
        if (tt != null) {
            return tt;
        }
        tt = AsciiTimeTransferType.getByName(ttype, properties);
        if (tt != null) {
            return tt;
        }
        return null;
    }

    public abstract void write(double var1, ByteBuffer var3);

    public abstract double read(ByteBuffer var1);

    abstract int sizeBytes();

    abstract boolean isAscii();

    abstract String name();

    public String toString() {
        return this.name();
    }
}

