/*
 * Decompiled with CFR 0.152.
 */
package org.das2.jythoncompletion;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.event.KeyEvent;
import java.util.logging.Logger;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import javax.swing.text.Position;
import org.das2.jythoncompletion.DefaultDocumentationItem;
import org.das2.jythoncompletion.support.CompletionItem;
import org.das2.jythoncompletion.support.CompletionResultSet;
import org.das2.jythoncompletion.support.CompletionTask;
import org.das2.jythoncompletion.support.CompletionUtilities;
import org.das2.jythoncompletion.ui.CompletionImpl;

public class DefaultCompletionItem
implements CompletionItem {
    String text;
    int offset;
    String complete;
    String label;
    String link;
    int sortPriority;
    static final Logger logger = Logger.getLogger("pvwave");

    public DefaultCompletionItem(String text, int offset, String complete, String label, String link, int sortPriority) {
        this.text = text;
        this.offset = offset;
        this.complete = complete;
        if (label == null) {
            label = complete;
        }
        this.label = label;
        this.link = link;
        this.sortPriority = sortPriority;
    }

    public DefaultCompletionItem(String text, int offset, String complete, String label, String link) {
        this(text, offset, complete, label, link, 1);
    }

    public static DefaultCompletionItem error(String message) {
        return new DefaultCompletionItem(message, 0, "", message, null);
    }

    public void defaultAction(JTextComponent jTextComponent) {
        try {
            int pos = jTextComponent.getCaretPosition();
            Document d = jTextComponent.getDocument();
            d.insertString(pos, this.complete.substring(this.offset), null);
        }
        catch (BadLocationException ex) {
            throw new RuntimeException(ex);
        }
        CompletionImpl.get().hideCompletion();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void substituteText(JTextComponent c, int offset, int len, String toAdd) {
        Document doc = c.getDocument();
        String textl = ((Object)this.getInsertPrefix()).toString().substring(offset);
        if (textl != null) {
            try {
                String textToReplace = doc.getText(offset, len);
                if (textl.equals(textToReplace)) {
                    return;
                }
                Position position = doc.createPosition(offset);
                doc.remove(offset, len);
                doc.insertString(position.getOffset(), textl, null);
            }
            catch (BadLocationException e) {}
        }
    }

    public void processKeyEvent(KeyEvent keyEvent) {
    }

    public int getPreferredWidth(Graphics graphics, Font font) {
        String left = this.label;
        String right = null;
        int i2 = this.label.indexOf("->");
        if (i2 > -1) {
            right = this.label.substring(i2 + 2);
            left = this.label.substring(0, i2);
        }
        return CompletionUtilities.getPreferredWidth(left, right, graphics, font);
    }

    public void render(Graphics graphics, Font font, Color color, Color color0, int i, int i0, boolean b) {
        String left = this.label;
        String right = null;
        int i2 = this.label.indexOf("->");
        if (i2 > -1) {
            right = this.label.substring(i2 + 2);
            left = this.label.substring(0, i2);
        }
        CompletionUtilities.renderHtml(null, left, right, graphics, font, color, i, i0, b);
    }

    public CompletionTask createDocumentationTask() {
        if (this.link == null) {
            return null;
        }
        return new CompletionTask(){

            public void query(CompletionResultSet resultSet) {
                resultSet.setDocumentation(new DefaultDocumentationItem(DefaultCompletionItem.this.link));
                resultSet.finish();
            }

            public void refresh(CompletionResultSet resultSet) {
                this.query(resultSet);
            }

            public void cancel() {
            }
        };
    }

    public CompletionTask createToolTipTask() {
        return null;
    }

    public boolean instantSubstitution(JTextComponent jTextComponent) {
        this.defaultAction(jTextComponent);
        return true;
    }

    public int getSortPriority() {
        return this.sortPriority;
    }

    public CharSequence getSortText() {
        return this.text;
    }

    public CharSequence getInsertPrefix() {
        return this.text.substring(0, this.offset);
    }
}

