/*
 * Decompiled with CFR 0.152.
 */
package org.das2.jythoncompletion;

import java.net.MalformedURLException;
import java.net.URL;
import javax.swing.Action;
import org.das2.jythoncompletion.support.CompletionDocumentation;

public class DefaultDocumentationItem
implements CompletionDocumentation {
    String link;
    String text;

    public DefaultDocumentationItem(String link) {
        this(link, null);
    }

    public DefaultDocumentationItem(String link, String text) {
        this.link = link;
        this.text = text;
    }

    public String getText() {
        if (this.text != null) {
            return this.text;
        }
        URL url = this.getURL();
        if (url == null) {
            return "<html>unable to resolve link: <br>" + this.link + "</html>";
        }
        return null;
    }

    public URL getURL() {
        URL result = DefaultDocumentationItem.resolveURL(this.link);
        System.err.println("getURL=" + result);
        return result;
    }

    private static URL resolveURL(String link) {
        URL url;
        if (link == null) {
            return null;
        }
        if (link.contains("://")) {
            try {
                return new URL(link);
            }
            catch (MalformedURLException ex) {
                ex.printStackTrace();
                return null;
            }
        }
        int i = link.indexOf("#");
        if (i == -1) {
            url = DefaultDocumentationItem.class.getResource(link);
        } else {
            url = DefaultDocumentationItem.class.getResource(link.substring(0, i));
            try {
                url = new URL(url, link.substring(i));
            }
            catch (MalformedURLException ex) {
                ex.printStackTrace();
            }
        }
        return url;
    }

    public CompletionDocumentation resolveLink(String string) {
        try {
            URL url = new URL(new URL(this.link), string);
            return new DefaultDocumentationItem(url.toString());
        }
        catch (MalformedURLException ex) {
            return null;
        }
    }

    public Action getGotoSourceAction() {
        return null;
    }
}

