/*
 * Decompiled with CFR 0.152.
 */
package org.das2.jythoncompletion;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import javax.swing.text.BadLocationException;
import javax.swing.text.JTextComponent;
import javax.swing.text.Utilities;
import org.das2.jythoncompletion.CompletionContext;
import org.das2.jythoncompletion.CompletionSupport;
import org.das2.jythoncompletion.DataSetUrlCompletionTask;
import org.das2.jythoncompletion.DefaultCompletionItem;
import org.das2.jythoncompletion.JythonCompletionProvider;
import org.das2.jythoncompletion.JythonInterpreterProvider;
import org.das2.jythoncompletion.MessageCompletionItem;
import org.das2.jythoncompletion.support.CompletionResultSet;
import org.das2.jythoncompletion.support.CompletionTask;
import org.python.core.PyClass;
import org.python.core.PyClassPeeker;
import org.python.core.PyException;
import org.python.core.PyJavaClass;
import org.python.core.PyJavaClassPeeker;
import org.python.core.PyJavaInstance;
import org.python.core.PyJavaInstancePeeker;
import org.python.core.PyJavaPackage;
import org.python.core.PyList;
import org.python.core.PyMethod;
import org.python.core.PyMethodPeeker;
import org.python.core.PyObject;
import org.python.core.PyReflectedFunction;
import org.python.core.PyReflectedFunctionPeeker;
import org.python.core.PyString;
import org.python.core.PyStringMap;
import org.python.util.PythonInterpreter;
import org.virbo.jythonsupport.JythonOps;
import org.virbo.jythonsupport.JythonUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JythonCompletionTask
implements CompletionTask {
    public static final String CLIENT_PROPERTY_INTERPRETER_PROVIDER = "JYTHON_INTERPRETER_PROVIDER";
    JTextComponent editor;
    String context;
    private JythonInterpreterProvider jythonInterpreterProvider;

    public JythonCompletionTask(JTextComponent t) {
        this.editor = t;
        this.jythonInterpreterProvider = (JythonInterpreterProvider)t.getClientProperty(CLIENT_PROPERTY_INTERPRETER_PROVIDER);
    }

    private Method getReadMethod(PyObject context, PyObject po, Class dc, String propName) {
        try {
            String methodName = "get" + propName.substring(0, 1).toUpperCase() + propName.substring(1);
            Method m = dc.getMethod(methodName, new Class[0]);
            return m;
        }
        catch (NoSuchMethodException ex) {
            return null;
        }
        catch (SecurityException ex) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void query(CompletionResultSet arg0) {
        try {
            JythonCompletionProvider.getInstance().setMessage("busy: getting completions");
            CompletionContext cc = CompletionSupport.getCompletionContext(this.editor);
            if (cc == null) {
                return;
            }
            if (cc.contextType == "module") {
                this.queryModules(cc, arg0);
            } else if (cc.contextType == "package") {
                this.queryPackages(cc, arg0);
            } else if (cc.contextType == "default") {
                this.queryNames(cc, arg0);
            } else if (cc.contextType == "method") {
                this.queryMethods(cc, arg0);
            } else if (cc.contextType == "stringLiteralArgument") {
                this.queryStringLiteralArgument(cc, arg0);
            }
            JythonCompletionProvider.getInstance().setMessage("done getting completions");
        }
        catch (BadLocationException badLocationException) {
        }
        finally {
            arg0.finish();
        }
    }

    private Method getJavaMethod(PyMethod m, int i) {
        PyMethodPeeker mpeek = new PyMethodPeeker(m);
        return new PyReflectedFunctionPeeker(mpeek.getReflectedFunction()).getMethod(i);
    }

    private int getMethodCount(PyMethod m) {
        PyMethodPeeker mpeek = new PyMethodPeeker(m);
        return new PyReflectedFunctionPeeker(mpeek.getReflectedFunction()).getArgsCount();
    }

    private void queryMethods(CompletionContext cc, CompletionResultSet rs) throws BadLocationException {
        PyList po2;
        PyObject context;
        PythonInterpreter interp = this.getInterpreter();
        String eval = this.editor.getText(0, Utilities.getRowStart(this.editor, this.editor.getCaretPosition()));
        if (eval.endsWith(":\n")) {
            eval = eval + "  pass\n";
        }
        Logger logger = Logger.getLogger(JythonCompletionTask.class.getName());
        try {
            interp.exec(eval);
        }
        catch (PyException ex) {
            rs.addItem(new MessageCompletionItem("Eval error in code before current position", ex.toString()));
            return;
        }
        try {
            context = interp.eval(cc.contextString);
        }
        catch (PyException ex) {
            rs.addItem(new MessageCompletionItem("Eval error: " + cc.contextString, ex.toString()));
            return;
        }
        try {
            po2 = (PyList)context.__dir__();
        }
        catch (PyException e) {
            e.printStackTrace();
            return;
        }
        for (int i = 0; i < po2.__len__(); ++i) {
            Method jm;
            Class dc;
            Object peek;
            Method m;
            PyObject po;
            PyString s = (PyString)po2.__getitem__(i);
            String ss = s.toString();
            if (!ss.startsWith(cc.completable)) continue;
            try {
                po = context.__getattr__(s);
            }
            catch (PyException e) {
                System.err.println("PyException from \"" + ss + "\":");
                e.printStackTrace();
                continue;
            }
            catch (IllegalArgumentException e) {
                e.printStackTrace();
                continue;
            }
            String label = ss;
            String signature = null;
            String args = "";
            if (context instanceof PyJavaClass) {
                if (po instanceof PyReflectedFunction) {
                    m = new PyReflectedFunctionPeeker((PyReflectedFunction)po).getMethod(0);
                    signature = this.methodSignature(m);
                    args = this.methodArgs(m);
                }
            } else if (context instanceof PyJavaPackage) {
                if (po instanceof PyJavaClass) {
                    Class dc2 = new PyJavaClassPeeker((PyJavaClass)po).getProxyClass();
                    if (dc2.getConstructors().length > 0) {
                        Constructor<?> constructor = dc2.getConstructors()[0];
                        signature = this.constructorSignature(constructor);
                        args = this.argsList(constructor.getParameterTypes());
                        signature = signature + args;
                    } else {
                        signature = dc2.getCanonicalName().replaceAll("\\.", "/") + ".html";
                    }
                } else if (po instanceof PyJavaPackage) {
                    // empty if block
                }
            } else if (context instanceof PyClass) {
                peek = new PyClassPeeker((PyClass)context);
                dc = ((PyClassPeeker)peek).getJavaClass();
                Field f = null;
                try {
                    f = dc.getField(label);
                }
                catch (NoSuchFieldException ex) {
                }
                catch (SecurityException ex) {
                    // empty catch block
                }
                if (f == null) continue;
                signature = this.fieldSignature(f);
            } else if (context instanceof PyJavaInstance) {
                if (po instanceof PyMethod) {
                    block44: {
                        m = (PyMethod)po;
                        try {
                            jm = this.getJavaMethod((PyMethod)m, 0);
                            if (this.getMethodCount((PyMethod)m) <= 1) break block44;
                            jm = this.getJavaMethod((PyMethod)m, this.getMethodCount((PyMethod)m) - 1);
                        }
                        catch (RuntimeException ex) {
                            continue;
                        }
                    }
                    signature = this.methodSignature(jm);
                    args = this.methodArgs(jm);
                    label = ss + args;
                } else {
                    peek = new PyJavaInstancePeeker((PyJavaInstance)context);
                    dc = ((PyJavaInstancePeeker)peek).getInstanceClass();
                    Method propReadMethod = this.getReadMethod(context, po, dc, label);
                    if (propReadMethod != null) {
                        signature = this.methodSignature(propReadMethod);
                        args = "";
                        String type = propReadMethod.getReturnType().getCanonicalName();
                        label = ss + " <em>(" + type + ")</em>";
                    } else {
                        Field f = null;
                        try {
                            f = dc.getField(label);
                        }
                        catch (NoSuchFieldException ex) {
                            logger.finest("NoSuchFieldException for item " + s);
                        }
                        catch (SecurityException ex) {
                            logger.finest("SecurityException for item " + s);
                        }
                        if (f == null) continue;
                        signature = this.fieldSignature(f);
                        label = ss;
                    }
                }
            } else if (context instanceof PyObject) {
                PyObject o = context.__dir__();
                label = ss;
                signature = null;
            } else if (po instanceof PyReflectedFunction) {
                label = ss + "() STATIC JAVA";
            } else if (po.isCallable()) {
                label = ss + "() " + (context instanceof PyJavaInstance ? "JAVA" : "");
                m = (PyMethod)po;
                jm = this.getJavaMethod((PyMethod)m, 0);
                signature = this.methodSignature(this.getJavaMethod((PyMethod)m, 0));
            } else {
                System.err.println("");
            }
            String link = null;
            if (signature != null) {
                link = signature.startsWith("javax") || signature.startsWith("java") || signature.startsWith("org.w3c.dom") || signature.startsWith("org.xml.sax") ? "http://download.oracle.com/javase/1.5.0/docs/api/" + signature.replaceAll(",", ", ") : (signature.startsWith("org/das2/") ? "http://www-pw.physics.uiowa.edu/das2/javadoc/" + signature : null);
            }
            rs.addItem(new DefaultCompletionItem(ss, cc.completable.length(), ss + args, label, link));
        }
    }

    private void queryModules(CompletionContext cc, CompletionResultSet rs) {
        PythonInterpreter interp = this.getInterpreter();
        String eval = "targetComponents = '" + cc.contextString + "'.split('.')\n" + "base = targetComponents[0]\n" + "baseModule = __import__(base, globals(), locals())\n" + "module = baseModule    \n" + "for component in targetComponents[1:]:\n" + "    module = getattr(module, component)\n" + "list = dir(module)\n" + "if ( list.count('__name__')>0 ):\n" + "    list.remove('__name__')\n" + "list.append('*')\n" + "list";
        interp.exec(eval);
        PyList po2 = (PyList)interp.eval("list");
        for (int i = 0; i < po2.__len__(); ++i) {
            PyString s = (PyString)po2.__getitem__(i);
            String ss = s.toString();
            if (!ss.startsWith(cc.completable)) continue;
            rs.addItem(new DefaultCompletionItem(ss, cc.completable.length(), ss, ss, null));
        }
    }

    private void queryPackages(CompletionContext cc, CompletionResultSet rs) {
        PythonInterpreter interp = this.getInterpreter();
        String eval = "targetComponents = '" + cc.contextString + "'.split('.')\n" + "base = targetComponents[0]\n" + "baseModule = __import__(base, globals(), locals())\n" + "module = baseModule    \n" + "for component in targetComponents[1:]:\n" + "    module = getattr(module, component)\n" + "list = dir(module)\n" + "if ( '__name__' in list ): list.remove('__name__')\n" + "list.append('*')\n" + "list";
        interp.exec(eval);
        PyList po2 = (PyList)interp.eval("list");
        for (int i = 0; i < po2.__len__(); ++i) {
            PyString s = (PyString)po2.__getitem__(i);
            String ss = s.toString();
            if (!ss.startsWith(cc.completable)) continue;
            rs.addItem(new DefaultCompletionItem(ss, cc.completable.length(), ss, ss, null));
        }
    }

    private static String join(String[] list, String delim) {
        return JythonCompletionTask.join(Arrays.asList(list), delim);
    }

    private static String join(List<String> list, String delim) {
        if (list.size() == 0) {
            return "";
        }
        StringBuffer result = new StringBuffer(list.get(0));
        for (int i = 1; i < list.size(); ++i) {
            result.append(delim).append(list.get(i));
        }
        return result.toString();
    }

    private void queryNames(CompletionContext cc, CompletionResultSet rs) throws BadLocationException {
        String[] keywords;
        for (String kw : keywords = new String[]{"assert", "def", "elif", "except", "from", "for", "finally", "import", "while", "print", "raise"}) {
            if (!kw.startsWith(cc.completable)) continue;
            rs.addItem(new DefaultCompletionItem(kw, cc.completable.length(), kw, kw, null, 0));
        }
        PythonInterpreter interp = this.getInterpreter();
        String eval = this.editor.getText(0, Utilities.getRowStart(this.editor, this.editor.getCaretPosition()));
        try {
            Map locals = JythonUtil.getLocals(new BufferedReader(new StringReader(eval)));
        }
        catch (IOException ex) {
            // empty catch block
        }
        try {
            eval = JythonUtil.removeSideEffects(new BufferedReader(new StringReader(eval)));
        }
        catch (IOException ex) {
            // empty catch block
        }
        String ss2 = "def getDataSet( st, mon ):\n   return findgen(100)\n\ndef getDataSet( st ):\n   return findgen(100)\n\n";
        System.err.println(ss2);
        interp.exec(ss2);
        interp.exec(eval);
        PyStringMap locals = (PyStringMap)interp.getLocals();
        PyList po2 = locals.keys();
        for (int i = 0; i < po2.__len__(); ++i) {
            PyString s = (PyString)po2.__getitem__(i);
            String ss = s.toString();
            String signature = null;
            if (!ss.startsWith(cc.completable)) continue;
            PyObject po = locals.get((PyObject)s);
            String label = ss;
            String args = "";
            if (po instanceof PyReflectedFunction) {
                label = ss + "() JAVA";
                PyReflectedFunction prf = (PyReflectedFunction)po;
                PyReflectedFunctionPeeker peek = new PyReflectedFunctionPeeker(prf);
                signature = this.methodSignature(peek.getMethod(0));
                args = this.methodArgs(peek.getMethod(0));
                int j = signature.indexOf("#");
                if (j > -1) {
                    label = signature.substring(j + 1);
                    label = label.replaceAll("org.virbo.dataset.QDataSet", "QDataSet").replaceAll("java.lang.String", "String");
                    Class<?> ret = peek.getMethod(0).getReturnType();
                    label = label + "->" + ret.getCanonicalName().replaceAll("org.virbo.dataset.QDataSet", "QDataSet").replaceAll("java.lang.String", "String");
                }
            } else if (po.isCallable()) {
                label = ss + "() ";
            } else if (po.isNumberType()) {
                String sss;
                label = po.getType().getFullName().equals("javaclass") ? ss : (po.getType().getFullName().equals("javapackage") ? ss : ((sss = po.toString()).contains("<") ? ss : ss + " = " + sss));
            } else {
                System.err.println("");
            }
            String link = null;
            if (signature != null) {
                String autoplotDoc = "http://autoplot.org/developer.scripting#";
                link = autoplotDoc + ss;
            }
            rs.addItem(new DefaultCompletionItem(ss, cc.completable.length(), ss + args, label, link));
        }
    }

    private String argsList(Class[] classes) {
        String LPAREN = "(";
        String RPAREN = ")";
        String SPACE = " ";
        StringBuffer sig = new StringBuffer();
        sig.append(LPAREN);
        ArrayList<String> sargs = new ArrayList<String>();
        for (Class arg : classes) {
            sargs.add(arg.getSimpleName());
        }
        sig.append(JythonCompletionTask.join(sargs, ","));
        sig.append(RPAREN);
        return sig.toString();
    }

    private String methodArgs(Method javaMethod) {
        return this.argsList(javaMethod.getParameterTypes());
    }

    private String methodSignature(Method javaMethod) {
        String javadocPath = JythonCompletionTask.join(javaMethod.getDeclaringClass().getCanonicalName().split("\\."), "/") + ".html";
        StringBuffer sig = new StringBuffer(javadocPath);
        String LPAREN = "(";
        String RPAREN = ")";
        String SPACE = " ";
        sig.append("#" + javaMethod.getName() + LPAREN);
        ArrayList<String> sargs = new ArrayList<String>();
        for (Class<?> arg : javaMethod.getParameterTypes()) {
            sargs.add(arg.getCanonicalName());
        }
        sig.append(JythonCompletionTask.join(sargs, ","));
        sig.append(RPAREN);
        return sig.toString();
    }

    private String fieldSignature(Field f) {
        String javadocPath = JythonCompletionTask.join(f.getDeclaringClass().getCanonicalName().split("\\."), "/") + ".html";
        StringBuffer sig = new StringBuffer(javadocPath);
        sig.append("#" + f.getName());
        return sig.toString();
    }

    private String constructorSignature(Constructor f) {
        String javadocPath = JythonCompletionTask.join(f.getDeclaringClass().getCanonicalName().split("\\."), "/") + ".html";
        StringBuffer sig = new StringBuffer(javadocPath);
        int i = f.getName().lastIndexOf(".");
        sig.append("#" + f.getName().substring(i + 1));
        return sig.toString();
    }

    private void queryStringLiteralArgument(CompletionContext cc, CompletionResultSet arg0) {
        String method = cc.contextString;
        if (method.equals("getDataSet")) {
            DataSetUrlCompletionTask task = new DataSetUrlCompletionTask(this.editor);
            task.query(arg0);
        }
    }

    private PythonInterpreter getInterpreter() {
        try {
            PythonInterpreter interp;
            if (this.jythonInterpreterProvider != null) {
                interp = this.jythonInterpreterProvider.createInterpreter();
                URL imports = JythonOps.class.getResource("imports.py");
                interp.execfile(imports.openStream());
            } else {
                interp = new PythonInterpreter();
                URL imports = JythonOps.class.getResource("imports.py");
                interp.execfile(imports.openStream());
            }
            return interp;
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    @Override
    public void refresh(CompletionResultSet arg0) {
    }

    @Override
    public void cancel() {
    }
}

